/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.net.URLFileSystem;

public final class VCSProcessUtils {
    private static final int COMMAND_BUFFER_LIMIT = (int)Math.pow(2.0, 10.0);

    private VCSProcessUtils() {
    }

    public static final URL[][] splitCommandArgumentURLs(URL[] arguments, int maxArguments, boolean usePaths) {
        ArrayList<ArrayList<URL>> all = new ArrayList<ArrayList<URL>>();
        ArrayList<URL> current = new ArrayList<URL>();
        int i = 0;
        while (i < arguments.length) {
            if (maxArguments <= 0 || current.size() < maxArguments) {
                current.add(arguments[i]);
                int n = VCSProcessUtils.predictCommandLength(current, usePaths);
                if (n > COMMAND_BUFFER_LIMIT && current.size() > 1) {
                    current.remove(arguments[i]);
                } else {
                    ++i;
                    continue;
                }
            }
            all.add(current);
            current = new ArrayList();
        }
        if (current.size() > 0) {
            all.add(current);
        }
        URL[][] array = new URL[all.size()][];
        Iterator itr = all.iterator();
        for (int i2 = 0; i2 < array.length; ++i2) {
            Collection c = (Collection)itr.next();
            array[i2] = c.toArray(new URL[0]);
        }
        return array;
    }

    public static final String[] createEnvironmentParams(Map<String, String> envp) {
        ArrayList<String> c = new ArrayList<String>();
        for (String key : envp.keySet()) {
            String value = envp.get(key);
            if (value == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            c.add(sb.toString());
        }
        return c.toArray(new String[0]);
    }

    public static final void sendInputData(Process process, String data, boolean close) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        out.write(data);
        out.newLine();
        out.flush();
        if (close) {
            out.close();
        }
    }

    public static final void sendInputData(Process process, String data) throws IOException {
        VCSProcessUtils.sendInputData(process, data, false);
    }

    private static final int predictCommandLength(Collection<URL> arguments, boolean usePaths) {
        int n = 0;
        Iterator<URL> itr = arguments.iterator();
        while (itr.hasNext()) {
            ++n;
            URL url = itr.next();
            String s = usePaths ? URLFileSystem.getPlatformPathName((URL)url) : URLFileSystem.getFileName((URL)url);
            n += s.length();
        }
        return n;
    }
}

