/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;

public final class VCSNodeIconUtils {
    private VCSNodeIconUtils() {
    }

    public static Icon getIconForURL(URL url) {
        if (URLFileSystem.isDirectory((URL)url)) {
            return OracleIcons.getIcon((String)"folder.png");
        }
        return VCSNodeIconUtils.getIconForSuffix(URLFileSystem.getSuffix((URL)url));
    }

    public static Icon getIconForSuffix(String suffix) {
        Icon icon;
        if (suffix == null || suffix.length() <= 0) {
            return OracleIcons.getIcon((String)"file.png");
        }
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExts = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        if (documentExts == null) {
            return OracleIcons.getIcon((String)"file.png");
        }
        DocumentExtensions.DocRecord docRecord = documentExts.findDocumentFromExtension(suffix);
        Icon icon2 = icon = docRecord != null ? docRecord.getIcon() : null;
        if (icon == null) {
            return OracleIcons.getIcon((String)"file.png");
        }
        return icon;
    }
}

