/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.EventQueue;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;

public final class VCSIdeEventRecorder {
    private static boolean _hasAddinsLoaded;
    private static boolean _hasMainWindowClosing;
    private static boolean _hasMainWindowOpened;

    private VCSIdeEventRecorder() {
    }

    public static final void initialize() {
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public final void addinsLoaded(IdeEvent e) {
                _hasAddinsLoaded = true;
                this.checkRemoveListener();
            }

            public final void mainWindowClosing(IdeEvent e) {
                _hasMainWindowClosing = true;
                this.checkRemoveListener();
            }

            public final void mainWindowOpened(IdeEvent e) {
                _hasMainWindowOpened = true;
                this.checkRemoveListener();
            }

            private final void checkRemoveListener() {
                if (_hasAddinsLoaded && _hasMainWindowClosing && _hasMainWindowOpened) {
                    Ide.removeIdeListener((IdeListener)this);
                }
            }
        });
    }

    public static final boolean hasAddinsLoaded() {
        return _hasAddinsLoaded;
    }

    public static final boolean hasMainWindowClosing() {
        return _hasMainWindowClosing;
    }

    public static final boolean hasMainWindowOpened() {
        return _hasMainWindowOpened;
    }

    public static final void invokeAfterMainWindowOpened(final Runnable r) {
        if (VCSIdeEventRecorder.hasMainWindowOpened()) {
            EventQueue.invokeLater(r);
            return;
        }
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public final void mainWindowOpened(IdeEvent e) {
                r.run();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
    }

    public static final void invokeAfterAddinsLoaded(final Runnable r) {
        if (VCSIdeEventRecorder.hasAddinsLoaded()) {
            r.run();
            return;
        }
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public final void addinsLoaded(IdeEvent e) {
                r.run();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
    }
}

