/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.RegisteredDynamicNode;
import oracle.ide.model.ContentType;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.util.StringTokenizerEx;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.compare.CompareUtil;

public final class VCSFileSystemUtils {
    private VCSFileSystemUtils() {
    }

    @Deprecated
    public static final Map<URL, Collection<URL>> organizeURLsByParent(URL[] urls) {
        LinkedHashMap<URL, Collection<URL>> map = new LinkedHashMap<URL, Collection<URL>>();
        for (int i = 0; i < urls.length; ++i) {
            URL parent = URLFileSystem.getParent((URL)urls[i]);
            ArrayList<URL> c = (ArrayList<URL>)map.get(parent);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(parent, c);
            }
            c.add(urls[i]);
        }
        return map;
    }

    public static final Map<VCSHashURL, Collection<URL>> mapURLsByParent(URL[] urls) {
        LinkedHashMap<VCSHashURL, Collection<URL>> map = new LinkedHashMap<VCSHashURL, Collection<URL>>();
        for (int i = 0; i < urls.length; ++i) {
            URL parentUrl = URLFileSystem.getParent((URL)urls[i]);
            VCSHashURL parent = parentUrl != null ? new VCSHashURL(parentUrl) : null;
            ArrayList<URL> c = (ArrayList<URL>)map.get(parent);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(parent, c);
            }
            c.add(urls[i]);
        }
        return map;
    }

    @Deprecated
    public static final Map<URL, Collection<String>> organizeFilenamesByParent(URL[] urls) {
        LinkedHashMap<URL, Collection<String>> map = new LinkedHashMap<URL, Collection<String>>();
        for (int i = 0; i < urls.length; ++i) {
            URL parent = URLFileSystem.getParent((URL)urls[i]);
            ArrayList<String> c = (ArrayList<String>)map.get(parent);
            if (c == null) {
                c = new ArrayList<String>();
                map.put(parent, c);
            }
            c.add(URLFileSystem.getFileName((URL)urls[i]));
        }
        return map;
    }

    public static final Map<VCSHashURL, Collection<String>> mapFilenamesByParent(URL[] urls) {
        LinkedHashMap<VCSHashURL, Collection<String>> map = new LinkedHashMap<VCSHashURL, Collection<String>>();
        for (int i = 0; i < urls.length; ++i) {
            URL parentUrl = URLFileSystem.getParent((URL)urls[i]);
            VCSHashURL parent = parentUrl != null ? new VCSHashURL(parentUrl) : null;
            ArrayList<String> c = (ArrayList<String>)map.get(parent);
            if (c == null) {
                c = new ArrayList<String>();
                map.put(parent, c);
            }
            c.add(URLFileSystem.getFileName((URL)urls[i]));
        }
        return map;
    }

    public static final String[] getURLFileNames(URL[] urls) {
        String[] filenames = new String[urls.length];
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = URLFileSystem.getFileName((URL)urls[i]);
        }
        return filenames;
    }

    public static final URL[] canonicalizeURLs(URL[] urls) {
        URL[] urls2 = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            urls2[i] = URLFileSystem.canonicalize((URL)urls[i]);
        }
        return urls2;
    }

    public static final URL searchSystemPath(String name) {
        URL[] urls = VCSFileSystemUtils._searchSystemPath(name, false);
        return urls.length > 0 ? urls[0] : null;
    }

    public static final URL[] searchSystemPathFully(String name) {
        return VCSFileSystemUtils._searchSystemPath(name, true);
    }

    private static final URL[] _searchSystemPath(String name, boolean fullSearch) {
        String path;
        LinkedHashSet<VCSHashURL> urls = null;
        if (fullSearch) {
            urls = new LinkedHashSet<VCSHashURL>();
        }
        if ((path = System.getenv("PATH")) == null) {
            return new URL[0];
        }
        StringTokenizerEx tokenizer = new StringTokenizerEx(path, File.pathSeparator, false, true, false);
        URL workingDirectory = URLFactory.newDirURL((File)new File("."));
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextElement().toString();
            URL dir = new File(entry).isAbsolute() ? URLFactory.newDirURL((String)entry) : URLFactory.newURL((URL)workingDirectory, (String)entry);
            URL url = URLFactory.newURL((URL)dir, (String)(VCSOperatingSystem.isWindows() ? name + ".exe" : name));
            if (URLFileSystem.isDirectory((URL)url) || !URLFileSystem.exists((URL)url)) continue;
            url = URLFileSystem.canonicalize((URL)url);
            if (!fullSearch) {
                return new URL[]{url};
            }
            urls.add(new VCSHashURL(url));
        }
        if (urls == null) {
            return new URL[0];
        }
        return VCSHashURL.convertToURLs(urls).toArray(new URL[0]);
    }

    public static final URL[] getParentURLs(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        while ((url = URLFileSystem.getParent((URL)url)) != null) {
            urls.add(url);
        }
        return urls.toArray(new URL[0]);
    }

    public static final URL[] getParentURLs(URL[] urls) {
        LinkedHashSet<VCSHashURL> parents = new LinkedHashSet<VCSHashURL>();
        for (int i = 0; i < urls.length; ++i) {
            parents.addAll(VCSHashURL.convertFromURLs(Arrays.asList(VCSFileSystemUtils.getParentURLs(urls[i]))));
        }
        return VCSHashURL.convertToURLs(parents).toArray(new URL[parents.size()]);
    }

    public static final boolean isBaseURLFor(URL url1, URL url2) {
        if (URLFileSystem.isDirectoryPath((URL)url1)) {
            return URLFileSystem.isBaseURLFor((URL)url1, (URL)url2);
        }
        return url1.toString().equals(url2.toString());
    }

    public static final URL[] newTargetURLs(URL[] urls, URL target) {
        URL[] targets = new URL[urls.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = URLFileSystem.isDirectoryPath((URL)urls[i]) ? URLFactory.newDirURL((URL)target, (String)URLFileSystem.getFileName((URL)urls[i])) : URLFactory.newURL((URL)target, (String)URLFileSystem.getFileName((URL)urls[i]));
        }
        return targets;
    }

    public static final URL newFileURL(String filePath) {
        return filePath.endsWith(File.separator) ? URLFactory.newDirURL((String)filePath) : URLFactory.newFileURL((String)filePath);
    }

    public static final String getPlatformPathName(URL url) {
        String path = URLFileSystem.getPlatformPathName((URL)url);
        return URLFileSystem.isDirectoryPath((URL)url) && !path.endsWith(File.separator) ? (path = path + File.separator) : path;
    }

    public static final URL[] removeRefAndQueryParts(URL[] urls) {
        URL[] urls2 = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            urls2[i] = urls[i];
            urls2[i] = URLFactory.replaceRefPart((URL)urls2[i], null);
            urls2[i] = URLFactory.replaceQueryPart((URL)urls2[i], null);
        }
        return urls2;
    }

    public static final ContentType getContentType(String extension) {
        return VCSFileSystemUtils.findContentTypeFromExtension(extension);
    }

    public static final URL[] getContentTypeURLs(URL[] urls, ContentType contentType) {
        ArrayList<URL> contentTypeUrls = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (VCSFileSystemUtils.findContentTypeFromExtension(URLFileSystem.getSuffix((URL)urls[i])) != contentType) continue;
            contentTypeUrls.add(urls[i]);
        }
        return contentTypeUrls.toArray(new URL[0]);
    }

    private static final ContentType findContentTypeFromExtension(String extension) {
        ContentType contentType = DocumentExtensions.findRecognizerContentType((String)extension);
        if (contentType == null && extension != null && extension.length() > 0 && Recognizer.getClassForExtension((String)extension) != null) {
            return ContentType.TEXT;
        }
        return contentType;
    }

    public static final Map<ContentType, Collection<URL>> organizeURLsByContentType(URL[] urls) {
        LinkedHashMap<ContentType, Collection<URL>> map = new LinkedHashMap<ContentType, Collection<URL>>();
        for (int i = 0; i < urls.length; ++i) {
            ContentType contentType = VCSFileSystemUtils.findContentTypeFromExtension(URLFileSystem.getSuffix((URL)urls[i]));
            ArrayList<URL> c = (ArrayList<URL>)map.get(contentType);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(contentType, c);
            }
            c.add(urls[i]);
        }
        return map;
    }

    public static final void registerFileType(String extension, ContentType contentType) {
        DocumentExtensions.DocRecord currentDocRecord;
        if (extension.equals("")) {
            return;
        }
        extension = DocumentExtensions.DocRecord.sanitizeExtensionAsString((String)extension);
        DocumentExtensions.DocRecord docRecord = null;
        DocumentExtensions documentExtensions = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        Map documentMap = documentExtensions._getDocumentMap();
        for (Map.Entry entry : documentMap.entrySet()) {
            currentDocRecord = (DocumentExtensions.DocRecord)entry.getValue();
            if (!currentDocRecord.isExtensionInUse(extension)) continue;
            docRecord = currentDocRecord;
            break;
        }
        if (docRecord == null) {
            for (Map.Entry entry : documentMap.entrySet()) {
                currentDocRecord = (DocumentExtensions.DocRecord)entry.getValue();
                if (!currentDocRecord.getDocClassName().equals(RegisteredDynamicNode.class.getName())) continue;
                docRecord = currentDocRecord;
                break;
            }
            if (docRecord == null) {
                docRecord = new DocumentExtensions.DocRecord(RegisteredDynamicNode.class, null);
                documentMap.put(RegisteredDynamicNode.class, docRecord);
            }
            DocumentExtensions.ExtInfo extInfo = docRecord.addUserExtension(extension);
            extInfo.setLocked(true);
        }
        documentExtensions._setDocumentMap(documentMap);
        Recognizer.mapExtensionToContentType((String)extension, (ContentType)contentType);
        Ide.getSettings().save();
    }

    public static final URL getDirectoryPathURL(URL url) {
        return URLFileSystem.isDirectoryPath((URL)url) ? url : URLFactory.newDirURL((URL)url, (String)"");
    }

    public static final URL[] coalesceURLs(URL[] urls) {
        Collection<VCSHashURL> urls0 = VCSHashURL.convertFromURLs(Arrays.asList(urls));
        ArrayList<VCSHashURL> urls1 = new ArrayList<VCSHashURL>();
        while (!urls0.isEmpty()) {
            VCSHashURL shallowUrl = urls0.iterator().next();
            String shallowUrlExternal = shallowUrl.getExternalForm();
            for (VCSHashURL currentUrl : urls0) {
                String currentUrlExternal = currentUrl.getExternalForm();
                if (!URLFileSystem.isDirectoryPath((URL)currentUrl.getURL()) || !shallowUrlExternal.startsWith(currentUrlExternal)) continue;
                shallowUrl = currentUrl;
                shallowUrlExternal = currentUrlExternal;
            }
            if (URLFileSystem.isDirectoryPath((URL)shallowUrl.getURL())) {
                Iterator<VCSHashURL> itr = urls0.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().getExternalForm().startsWith(shallowUrlExternal)) continue;
                    itr.remove();
                }
            } else {
                urls0.remove(shallowUrl);
            }
            urls1.add(shallowUrl);
        }
        return VCSHashURL.convertToURLs(urls1).toArray(new URL[0]);
    }

    public static void registerDecorator(String protocol, URLFileSystemHelperDecorator decorator) {
        if (protocol != null && protocol.length() > 0 && decorator != null) {
            URLFileSystemHelper helper = URLFileSystem.findHelper((String)protocol);
            if (!(helper instanceof URLFileSystemHelperDecorator)) {
                URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)decorator);
                return;
            }
            while (true) {
                URLFileSystemHelperDecorator thisDecorator;
                URLFileSystemHelper nextHelper;
                if (!((nextHelper = (thisDecorator = (URLFileSystemHelperDecorator)helper).getHelper()) instanceof URLFileSystemHelperDecorator)) {
                    thisDecorator.insertNextDecorator(decorator);
                    break;
                }
                helper = nextHelper;
            }
        }
    }

    public static boolean isNonEditable(URL url) {
        final Node node = NodeFactory.find((URL)url);
        if (node == null) {
            return false;
        }
        if (node.getAttributes().isSet(ElementAttributes.NON_EDITABLE)) {
            return true;
        }
        if (!Ide.getIdeArgs().getCreateUI()) {
            return false;
        }
        final Map[] transientProperties = new Map[1];
        node.tryRunUnderReadLock(new Runnable(){

            @Override
            public final void run() {
                transientProperties[0] = node.getTransientProperties();
            }
        });
        Boolean suppressCheckOut = transientProperties[0] != null ? (Boolean)transientProperties[0].get("VCS.suppressCheckOut") : null;
        return suppressCheckOut != null && suppressCheckOut != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final InputStream openConflictsStreamAsContributor(URL url, String charsetName) throws IOException {
        InputStream inputStream = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            inputStream = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(inputStream, charsetName);
            StringWriter sw = new StringWriter();
            br = new BufferedReader(isr);
            bw = new BufferedWriter(sw);
            int conflictSection = 0;
            block20: while (br.ready()) {
                String line = br.readLine();
                switch (conflictSection) {
                    case 0: {
                        if (!line.startsWith("<<<<<<<")) break;
                        conflictSection = 1;
                        continue block20;
                    }
                    case 1: {
                        if (!line.startsWith("=======")) break;
                        conflictSection = 2;
                        continue block20;
                    }
                    case 2: {
                        if (!line.startsWith(">>>>>>>")) continue block20;
                        conflictSection = 0;
                        continue block20;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                bw.write(line);
                bw.newLine();
            }
            bw.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sw.getBuffer().toString().getBytes(charsetName));
            return byteArrayInputStream;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] listBinaryExtensions() {
        Map extensionToContentTypeMap;
        HashSet<String> extensions = new HashSet<String>();
        Map map = extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
        synchronized (map) {
            for (File file : extensionToContentTypeMap.keySet()) {
                if (ContentType.BINARY != extensionToContentTypeMap.get(file)) continue;
                extensions.add(file.getPath());
            }
        }
        Object[] extensionsArray = extensions.toArray(new String[extensions.size()]);
        Arrays.sort(extensionsArray);
        return extensionsArray;
    }

    public static final boolean isContentTypeBinary(URL url) {
        return CompareUtil.isContentTypeBinary((URL)url);
    }
}

