/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;

public class VCSURLFileSystemHelper
extends URLFileSystemHelperDecorator {
    private boolean _enabled = true;
    private final VCSExtension _extension;
    public static final String DEFAULT_AUTO_CHECK_OUT_COMMENTS = VCSArb.format(45, Ide.getProgramName());

    public VCSURLFileSystemHelper(URLFileSystemHelper helper, String vcsId) {
        super(helper);
        this._extension = (VCSExtension)VCSRegistry.lookup((String)vcsId);
        if (this._extension == null) {
            throw new IllegalArgumentException("VCS not registered: " + vcsId);
        }
    }

    public VCSURLFileSystemHelper(URLFileSystemHelper helper, VCSExtension extension) {
        super(helper);
        this._extension = extension;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean canCreate(URL url) {
        if (!this._enabled) {
            return this.getHelper().canCreate(url);
        }
        return this.canCreateImpl(url);
    }

    public boolean canDelete(URL url) {
        if (!this._enabled) {
            return this.getHelper().canDelete(url);
        }
        if (!this.isOperable(url)) {
            return this.getHelper().canDelete(url);
        }
        if (VCSFileSystemUtils.isNonEditable(url)) {
            return this.getHelper().canDelete(url);
        }
        return this.canDeleteImpl(url);
    }

    public boolean isValid(URL url) {
        if (!this._enabled) {
            return this.getHelper().isValid(url);
        }
        return this.isValidImpl(url);
    }

    public void delete(URL url) throws IOException {
        if (!this._enabled) {
            this.getHelper().delete(url);
            return;
        }
        if (!this.exists(url)) {
            this.getHelper().delete(url);
            return;
        }
        if (!this.isOperable(url)) {
            this.getHelper().delete(url);
            return;
        }
        if (VCSFileSystemUtils.isNonEditable(url)) {
            this.getHelper().delete(url);
            return;
        }
        if (!this.deleteImpl(url)) {
            throw new IOException("Deletion failed in VCS on " + URLFileSystem.getPlatformPathName((URL)url));
        }
    }

    public void rename(URL oldUrl, URL newUrl) throws IOException {
        if (!this._enabled) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (!this.exists(oldUrl)) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (!this.isOperable(oldUrl)) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (VCSFileSystemUtils.isNonEditable(oldUrl)) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (!this.renameToImpl(oldUrl, newUrl)) {
            throw new IOException("Rename failed in VCS");
        }
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        if (!this._enabled || readOnly) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        if (!this.isReadOnly(url)) {
            return true;
        }
        if (!this.canMakeWritable(url)) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        return this.setReadWrite(url);
    }

    private final boolean canMakeWritable(URL url) {
        if (!this.exists(url)) {
            return false;
        }
        if (!this.isAutoCheckoutsSet(url)) {
            return false;
        }
        if (!this.isOperable(url)) {
            return false;
        }
        return !VCSFileSystemUtils.isNonEditable(url);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        if (!this._enabled) {
            return super.openOutputStream(url);
        }
        try {
            return super.openOutputStream(url);
        }
        catch (FileNotFoundException fnfe) {
            if (this.isReadOnly(url) && this.canMakeWritable(url) && this.setReadOnly(url, false)) {
                return super.openOutputStream(url);
            }
            throw fnfe;
        }
    }

    protected boolean deleteImpl(URL url) {
        try {
            this.getHelper().delete(url);
            return true;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            return false;
        }
    }

    protected boolean renameToImpl(URL oldUrl, URL newUrl) {
        try {
            this.getHelper().rename(oldUrl, newUrl);
            return true;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            return false;
        }
    }

    protected boolean canCreateImpl(URL url) {
        return this.getHelper().canCreate(url);
    }

    protected boolean canDeleteImpl(URL url) {
        return true;
    }

    protected boolean isValidImpl(URL url) {
        return this.getHelper().isValid(url);
    }

    protected boolean setReadWrite(URL url) {
        if (this._extension == null) {
            return this.getHelper().setReadOnly(url, false);
        }
        try {
            return this._extension.setReadWrite(new URL[]{url}, VCSProgress.createNullInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean isOperable(URL url) {
        return this.isControlled(url) && VCSManager.getVCSManager().isVersioned(url);
    }

    private final boolean isControlled(URL url) {
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        return extension != null && extension.getId().equals(this._extension.getId());
    }

    protected boolean isAutoCheckoutsSet(URL url) {
        if (this._extension != null) {
            return VCSManagerImpl.isAutoCheckoutsSet(this._extension);
        }
        return VCSManagerImpl.isAutoCheckoutsSet(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeAndPushEventQueue(Runnable r) {
        WaitCursor waitCursor;
        block4: {
            PopEventQueue popEventQueue0;
            Window currentWindow;
            PopEventQueue popEventQueue = null;
            if (EventQueue.isDispatchThread() && !(EventQueue.getCurrentEvent() instanceof KeyEvent)) {
                popEventQueue = new PopEventQueue();
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(popEventQueue);
            }
            waitCursor = (currentWindow = VCSWindowUtils.getCurrentWindow()) == IdeUtil.getMainWindow() ? Ide.getWaitCursor() : new WaitCursor((Component)currentWindow);
            waitCursor.show();
            try {
                r.run();
                popEventQueue0 = popEventQueue;
                if (popEventQueue == null) break block4;
            }
            catch (Throwable throwable) {
                PopEventQueue popEventQueue02 = popEventQueue;
                if (popEventQueue != null) {
                    EventQueue.invokeLater(new Runnable(popEventQueue02){
                        final /* synthetic */ PopEventQueue val$popEventQueue0;
                        {
                            this.val$popEventQueue0 = popEventQueue;
                        }

                        @Override
                        public void run() {
                            this.val$popEventQueue0.pop();
                        }
                    });
                }
                waitCursor.hide();
                throw throwable;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        waitCursor.hide();
    }

    public final void deleteRecursively(URL url, URLFilter filter, boolean tolerant) throws IOException, InterruptedException {
        if (!this._enabled || !this.isOperable(url) || VCSFileSystemUtils.isNonEditable(url)) {
            VCSURLFileSystemHelper helper = this.getNextVCSHelper();
            if (helper != null) {
                this.getNextVCSHelper().deleteRecursively(url, filter, tolerant);
            } else {
                this._deleteRecursively(url, filter, tolerant, true);
            }
            return;
        }
        if ((filter == null || filter.accept(url)) && this.canDelete(url) && this.deleteImpl(url)) {
            return;
        }
        this._deleteRecursively(url, filter, tolerant, false);
    }

    private final void _deleteRecursively(URL url, URLFilter filter, boolean tolerant, boolean propagate) throws IOException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("deleteRecursively() called from AWT event thread").printStackTrace();
        }
        if (!this._deleteRecursively(url, filter, tolerant, true, propagate, new boolean[1])) {
            throw new IOException("Unable to delete " + URLFileSystem.getPath((URL)url));
        }
    }

    private final boolean _deleteRecursively(URL url, URLFilter filter, boolean tolerant, boolean success, boolean propagate, boolean[] var_filtered) throws IOException, InterruptedException {
        URLFileSystem.FileInfo[] children;
        if (filter != null && !filter.accept(url)) {
            var_filtered[0] = true;
            return success;
        }
        boolean[] filtered = new boolean[1];
        if (URLFileSystem.isDirectory((URL)url) && (children = URLFileSystem.ls((URL)url)) != null) {
            for (URLFileSystem.FileInfo child : children) {
                success = success && this._deleteRecursively(child.getURL(), filter, tolerant, success, propagate, filtered);
            }
            if (children.length > 0 && Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        if (filtered[0]) {
            var_filtered[0] = true;
            return success;
        }
        try {
            if (propagate) {
                super.delete(url);
            } else {
                this.delete(url);
            }
            return success;
        }
        catch (IOException ioe) {
            if (tolerant) {
                return false;
            }
            throw ioe;
        }
    }

    private final VCSURLFileSystemHelper getNextVCSHelper() {
        VCSURLFileSystemHelper helper = this;
        do {
            if (helper instanceof URLFileSystemHelperDecorator) continue;
            return null;
        } while (!((helper = ((URLFileSystemHelperDecorator)helper).getHelper()) instanceof VCSURLFileSystemHelper));
        return helper;
    }

    private class PopEventQueue
    extends EventQueue {
        private PopEventQueue() {
        }

        @Override
        public void pop() {
            super.pop();
        }
    }
}

