/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.EventObject;

public final class VCSURLBasedCacheEvent
extends EventObject {
    private final URL[] _urls;
    private final URL _oldUrl;
    private final URL _newUrl;
    private final Object[] _values;
    private final boolean _invalidate;

    VCSURLBasedCacheEvent(Object source, URL[] urls, boolean invalidate) {
        super(source);
        this._urls = urls;
        this._oldUrl = null;
        this._newUrl = null;
        this._values = null;
        this._invalidate = invalidate;
    }

    VCSURLBasedCacheEvent(Object source, URL[] urls, Object[] values) {
        super(source);
        this._urls = urls;
        this._oldUrl = null;
        this._newUrl = null;
        this._values = values;
        this._invalidate = false;
    }

    VCSURLBasedCacheEvent(Object source, URL oldUrl, URL newUrl, Object value) {
        super(source);
        this._urls = null;
        this._oldUrl = oldUrl;
        this._newUrl = newUrl;
        this._values = new Object[]{value};
        this._invalidate = false;
    }

    public final URL[] getURLs() {
        return this._urls;
    }

    public final URL getOldURL() {
        return this._oldUrl;
    }

    public final URL getNewURL() {
        return this._newUrl;
    }

    public final Object getValue() {
        return this._values != null && this._values.length > 0 ? this._values[0] : null;
    }

    public final Object[] getValues() {
        return this._values;
    }

    public final boolean isInvalidate() {
        return this._invalidate;
    }
}

