/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSPropertyKey;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;

public abstract class VCSPropertyCustomizer
extends VCSPropertyTraversable {
    private static final int TIMEOUT_SCALE_SECONDS = 1;
    private static final int TIMEOUT_SCALE_MINUTES = 2;
    private static final int TIMEOUT_SCALE_HOURS = 3;
    private VCSPropertyCustomizerUI _customizerUI;
    private final Collection _propertyKeys;
    private final ResourceProxy _resourceProxy;
    public static final int RES_ID_USE_OVERLAYS_CHECKBOX_TEXT = 56;
    public static final int RES_ID_USE_OVERLAYS_CHECKBOX_MNEMONIC = 57;
    public static final int RES_ID_SILENTLY_SAVE_CHECKBOX_TEXT = 58;
    public static final int RES_ID_SILENTLY_SAVE_CHECKBOX_MNEMONIC = 59;
    public static final int RES_ID_AUTO_CHECKOUTS_CHECKBOX_TEXT = 60;
    public static final int RES_ID_AUTO_CHECKOUTS_CHECKBOX_MNEMONIC = 61;
    public static final int RES_ID_USE_LABEL_DECORATIONS_TEXT = 62;
    public static final int RES_ID_USE_LABEL_DECORATIONS_MNEMONIC = 63;
    public static final int RES_ID_AUTO_CHECKOUTS_COMMENT_TEXT = 238;
    public static final int RES_ID_AUTO_CHECKOUTS_COMMENT_MNEMONIC = 239;
    public static final int RES_ID_AUTO_ADDFILE_TEXT = 69;
    public static final int RES_ID_AUTO_ADDFILE_MNEMONIC = 70;
    public static final int RES_ID_AUTO_PROGRESS_ON_CHECKOUT_TEXT = 71;
    public static final int RES_ID_AUTO_PROGRESS_ON_CHECKOUT_MNEMONIC = 72;
    public static final int RES_ID_AUTO_LOG_MESSAGE_TEXT = 73;
    public static final int RES_ID_AUTO_LOG_MESSAGE_MNEMONIC = 74;

    public VCSPropertyCustomizer() {
        this(null, null);
    }

    @Override
    protected String getDataKey() {
        return "VCS.Properties";
    }

    public VCSPropertyCustomizer(String[] propertyKeys) {
        this._propertyKeys = propertyKeys != null ? Arrays.asList(propertyKeys) : null;
        this._resourceProxy = new ResourceProxy();
    }

    public VCSPropertyCustomizer(String[] propertyKeys, ResourceProxy resourceProxy) {
        this._propertyKeys = propertyKeys != null ? Arrays.asList(propertyKeys) : null;
        this._resourceProxy = resourceProxy != null ? resourceProxy : new ResourceProxy();
    }

    public static final Map createDefaultProperties(String[] propertyKeys) {
        List<String> propertyKeys2 = propertyKeys != null ? Arrays.asList(propertyKeys) : null;
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "useOverlays")) {
            m.put("useOverlays", VCSPropertyKey.DEFAULT_USE_OVERLAYS);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "silentlySave")) {
            m.put("silentlySave", VCSPropertyKey.DEFAULT_SILENTLY_SAVE);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "autoCheckouts")) {
            m.put("autoCheckouts", VCSPropertyKey.DEFAULT_AUTO_CHECKOUTS);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "property_operation_timeout")) {
            m.put("property_operation_timeout", VCSPropertyKey.DEFAULT_OPERATION_TIMEOUT);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "useLabelDecorations")) {
            m.put("useLabelDecorations", VCSPropertyKey.DEFAULT_USE_LABEL_DECORATIONS);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "autoCheckoutComment")) {
            m.put("autoCheckoutComment", VCSURLFileSystemHelper.DEFAULT_AUTO_CHECK_OUT_COMMENTS);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "autoAddFiles")) {
            m.put("autoAddFiles", VCSPropertyKey.DEFAULT_AUTO_ADDFILE);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "autoProgrssOnCheckout")) {
            m.put("autoProgrssOnCheckout", VCSPropertyKey.DEFAULT_USE_AUTO_PROGRESS_CHECKOUT);
        }
        if (VCSPropertyCustomizer.isHandlingProperty(propertyKeys2, "logMessagesToLogWindow")) {
            m.put("logMessagesToLogWindow", VCSPropertyKey.DEFAULT_LOG_MESSAGES);
        }
        return m;
    }

    @Override
    protected Component getPropertyPage() {
        if (this._customizerUI == null) {
            int displayFlags = 0;
            if (this.isHandlingProperty("useOverlays")) {
                displayFlags |= 1;
            }
            if (this.isHandlingProperty("silentlySave")) {
                displayFlags |= 2;
            }
            if (this.isHandlingProperty("autoCheckouts")) {
                displayFlags |= 4;
            }
            if (this.isHandlingProperty("autoAddFiles")) {
                displayFlags |= 0x40;
            }
            if (this.isHandlingProperty("property_operation_timeout")) {
                displayFlags |= 8;
            }
            if (this.isHandlingProperty("useLabelDecorations")) {
                displayFlags |= 0x10;
            }
            if (this.isHandlingProperty("autoCheckoutComment")) {
                displayFlags |= 0x20;
            }
            if (this.isHandlingProperty("autoProgrssOnCheckout")) {
                displayFlags |= 0x80;
            }
            if (this.isHandlingProperty("logMessagesToLogWindow")) {
                displayFlags |= 0x100;
            }
            this._customizerUI = new VCSPropertyCustomizerUI(displayFlags, this._resourceProxy);
        }
        return this._customizerUI;
    }

    @Override
    protected void setProperties(Map<String, ?> props) {
        this.getComponent();
        if (this.isHandlingProperty("useOverlays") && props.containsKey("useOverlays")) {
            this._customizerUI.getUseOverlaysCheckBox().setSelected((Boolean)props.get("useOverlays"));
        }
        if (this.isHandlingProperty("silentlySave") && props.containsKey("silentlySave")) {
            this._customizerUI.getSilentlySaveCheckBox().setSelected((Boolean)props.get("silentlySave"));
        }
        if (this.isHandlingProperty("autoCheckouts") && props.containsKey("autoCheckouts")) {
            this._customizerUI.getAutoCheckoutsCheckBox().setSelected((Boolean)props.get("autoCheckouts"));
        }
        if (this.isHandlingProperty("autoAddFiles") && props.containsKey("autoAddFiles")) {
            this._customizerUI.getAutoAddFilesCheckBox().setSelected((Boolean)props.get("autoAddFiles"));
        }
        if (this.isHandlingProperty("useLabelDecorations") && props.containsKey("useLabelDecorations")) {
            this._customizerUI.getUseLabelDecorationsCheckBox().setSelected((Boolean)props.get("useLabelDecorations"));
        }
        if (this.isHandlingProperty("autoProgrssOnCheckout") && props.containsKey("autoProgrssOnCheckout")) {
            this._customizerUI.getAutoProgessOnCheckoutCheckBox().setSelected((Boolean)props.get("autoProgrssOnCheckout"));
        }
        if (this.isHandlingProperty("property_operation_timeout") && props.containsKey("property_operation_timeout")) {
            Object value = props.get("property_operation_timeout");
            int seconds = (Integer)value;
            int scale = this.calculateTimeoutScale(seconds);
            this._customizerUI.getOperationTimeoutQuantity().setNumber((Number)new Integer(this.calculateTimeoutQuantity(seconds, scale)));
            if (scale == 3) {
                this._customizerUI.getOperationTimeoutHours().setSelected(true);
            }
            if (scale == 2) {
                this._customizerUI.getOperationTimeoutMinutes().setSelected(true);
            }
            if (scale == 1) {
                this._customizerUI.getOperationTimeoutSeconds().setSelected(true);
            }
        }
        if (this.isHandlingProperty("autoCheckoutComment") && props.containsKey("autoCheckoutComment")) {
            this._customizerUI.getAutoCheckoutCommentField().setText((String)props.get("autoCheckoutComment"));
        }
        if (this.isHandlingProperty("logMessagesToLogWindow") && props.containsKey("logMessagesToLogWindow")) {
            this._customizerUI.getAutoLogMessagesField().setSelected((Boolean)props.get("logMessagesToLogWindow"));
        }
    }

    @Override
    protected Map<String, ?> getProperties() {
        this.getComponent();
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.isHandlingProperty("useOverlays")) {
            props.put("useOverlays", new Boolean(this._customizerUI.getUseOverlaysCheckBox().isSelected()));
        }
        if (this.isHandlingProperty("silentlySave")) {
            props.put("silentlySave", new Boolean(this._customizerUI.getSilentlySaveCheckBox().isSelected()));
        }
        if (this.isHandlingProperty("autoCheckouts")) {
            props.put("autoCheckouts", new Boolean(this._customizerUI.getAutoCheckoutsCheckBox().isSelected()));
        }
        if (this.isHandlingProperty("useLabelDecorations")) {
            props.put("useLabelDecorations", new Boolean(this._customizerUI.getUseLabelDecorationsCheckBox().isSelected()));
        }
        if (this.isHandlingProperty("autoAddFiles")) {
            props.put("autoAddFiles", new Boolean(this._customizerUI.getAutoAddFilesCheckBox().isSelected()));
        }
        if (this.isHandlingProperty("autoProgrssOnCheckout")) {
            props.put("autoProgrssOnCheckout", new Boolean(this._customizerUI.getAutoProgessOnCheckoutCheckBox().isSelected()));
        }
        if (this.isHandlingProperty("property_operation_timeout")) {
            Integer quantity;
            int scale = 1;
            if (this._customizerUI.getOperationTimeoutHours().isSelected()) {
                scale = 3;
            }
            if (this._customizerUI.getOperationTimeoutMinutes().isSelected()) {
                scale = 2;
            }
            Integer quantity0 = (quantity = (Integer)this._customizerUI.getOperationTimeoutQuantity().getNumber()) != null ? new Integer(this.calculateTimeoutSeconds(quantity, scale)) : VCSPropertyKey.DEFAULT_OPERATION_TIMEOUT;
            props.put("property_operation_timeout", quantity0);
        }
        if (this.isHandlingProperty("autoCheckoutComment")) {
            props.put("autoCheckoutComment", this._customizerUI.getAutoCheckoutCommentField().getText());
        }
        if (this.isHandlingProperty("logMessagesToLogWindow")) {
            props.put("logMessagesToLogWindow", new Boolean(this._customizerUI.getAutoLogMessagesField().isSelected()));
        }
        return props;
    }

    @Override
    protected void validateProperties() throws TraversalException {
    }

    private int calculateTimeoutScale(int seconds) {
        if (seconds > 0 && seconds % 3600 == 0) {
            return 3;
        }
        if (seconds > 0 && seconds % 60 == 0) {
            return 2;
        }
        return 1;
    }

    private int calculateTimeoutQuantity(int seconds, int scale) {
        if (scale == 3) {
            return seconds / 3600;
        }
        if (scale == 2) {
            return seconds / 60;
        }
        return seconds;
    }

    private int calculateTimeoutSeconds(int quantity, int scale) {
        if (scale == 3) {
            return quantity * 3600;
        }
        if (scale == 2) {
            return quantity * 60;
        }
        return quantity;
    }

    private boolean isHandlingProperty(String propertyKey) {
        return VCSPropertyCustomizer.isHandlingProperty(this._propertyKeys, propertyKey);
    }

    private static final boolean isHandlingProperty(Collection propertyKeys, String requiredPropertyKey) {
        return propertyKeys == null || propertyKeys.contains(requiredPropertyKey);
    }

    private static class VCSPropertyCustomizerUI
    extends JPanel {
        private static final int DISPLAY_USE_OVERLAYS_CHECKBOX = 1;
        private static final int DISPLAY_SILENTLY_SAVE_CHECKBOX = 2;
        private static final int DISPLAY_AUTO_CHECKOUTS_CHECKBOX = 4;
        private static final int DISPLAY_OPERATION_TIMEOUT_CONTROL = 8;
        private static final int DISPLAY_USE_LABEL_DECORATIONS_CHECKBOX = 16;
        private static final int DISPLAY_AUTO_CHECKOUT_COMMENT_FIELD = 32;
        private static final int DISPLAY_AUTO_ADD_FILES_CHECKBOX = 64;
        private static final int DISPLAY_AUTO_PROGRESS_ON_CHECKOUT = 128;
        private static final int DISPLAY_AUTO_LOG_MESSAGES = 256;
        private JLabel _environmentSettingsLabel = new JLabel();
        private JCheckBox _useOverlaysCheckBox = new JCheckBox();
        private JCheckBox _silentlySaveCheckBox;
        private JCheckBox _autoCheckoutsCheckBox;
        private JCheckBox _useLabelDecorationsCheckBox;
        private JCheckBox _autoAddFilesCheckBox;
        private JCheckBox _autoProgressOnCheckBox;
        private JCheckBox _autoLogMessagesCheckBox;
        private JLabel _operationTimeoutLabel;
        private JRadioButton _operationTimeoutSeconds;
        private JRadioButton _operationTimeoutMinutes;
        private JRadioButton _operationTimeoutHours;
        private NumberTextField _operationTimeoutQuantity;
        private JLabel _autoCheckoutCommentLabel;
        private JTextField _autoCheckoutCommentField;

        VCSPropertyCustomizerUI(int displayFlags, ResourceProxy resourceProxy) {
            this._useOverlaysCheckBox.setText(resourceProxy.getString(56));
            this._useOverlaysCheckBox.setMnemonic(resourceProxy.getMnemonic(57));
            this._silentlySaveCheckBox = new JCheckBox();
            this._silentlySaveCheckBox.setText(resourceProxy.getString(58));
            this._silentlySaveCheckBox.setMnemonic(resourceProxy.getMnemonic(59));
            this._autoCheckoutsCheckBox = new JCheckBox();
            this._autoCheckoutsCheckBox.setText(resourceProxy.getString(60));
            this._autoCheckoutsCheckBox.setMnemonic(resourceProxy.getMnemonic(61));
            this._autoAddFilesCheckBox = new JCheckBox();
            this._autoAddFilesCheckBox.setText(resourceProxy.getString(69));
            this._autoAddFilesCheckBox.setMnemonic(resourceProxy.getMnemonic(70));
            this._useLabelDecorationsCheckBox = new JCheckBox();
            this._useLabelDecorationsCheckBox.setText(resourceProxy.getString(62));
            this._useLabelDecorationsCheckBox.setMnemonic(resourceProxy.getMnemonic(63));
            this._autoCheckoutCommentLabel = new JLabel();
            this._autoCheckoutCommentLabel.setText(resourceProxy.getString(238));
            this._autoCheckoutCommentLabel.setDisplayedMnemonic(resourceProxy.getMnemonic(239));
            this._autoProgressOnCheckBox = new JCheckBox();
            this._autoProgressOnCheckBox.setText(resourceProxy.getString(71));
            this._autoProgressOnCheckBox.setMnemonic(resourceProxy.getMnemonic(72));
            this._autoLogMessagesCheckBox = new JCheckBox();
            this._autoLogMessagesCheckBox.setText(resourceProxy.getString(73));
            this._autoLogMessagesCheckBox.setMnemonic(resourceProxy.getMnemonic(74));
            this._operationTimeoutLabel = new JLabel();
            this._operationTimeoutSeconds = new JRadioButton();
            this._operationTimeoutMinutes = new JRadioButton();
            this._operationTimeoutHours = new JRadioButton();
            this._operationTimeoutQuantity = new NumberTextField();
            this._autoCheckoutCommentField = new JTextField();
            this._autoCheckoutCommentLabel.setLabelFor(this._autoCheckoutCommentField);
            ResourceUtils.resLabel((JLabel)this._environmentSettingsLabel, (Component)this._environmentSettingsLabel, (String)VCSArb.getString(68));
            ResourceUtils.resLabel((JLabel)this._operationTimeoutLabel, (Component)this._operationTimeoutQuantity, (String)VCSArb.getString(64));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutSeconds, (String)VCSArb.getString(65));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutMinutes, (String)VCSArb.getString(66));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutHours, (String)VCSArb.getString(67));
            ButtonGroup operationTimeoutButtonGroup = new ButtonGroup();
            operationTimeoutButtonGroup.add(this._operationTimeoutSeconds);
            operationTimeoutButtonGroup.add(this._operationTimeoutMinutes);
            operationTimeoutButtonGroup.add(this._operationTimeoutHours);
            operationTimeoutButtonGroup = null;
            this._operationTimeoutQuantity.setColumns(10);
            this._operationTimeoutQuantity.setDecimal(true);
            this._operationTimeoutQuantity.setSigned(false);
            this._operationTimeoutQuantity.setDataType(Integer.class);
            if ((displayFlags & 1) <= 0) {
                this._useOverlaysCheckBox.setEnabled(false);
            }
            if ((displayFlags & 2) <= 0) {
                this._silentlySaveCheckBox.setEnabled(false);
            }
            if ((displayFlags & 4) <= 0) {
                this._autoCheckoutsCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x40) <= 0) {
                this._autoAddFilesCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x10) <= 0) {
                this._useLabelDecorationsCheckBox.setEnabled(false);
            }
            if ((displayFlags & 0x80) <= 0) {
                this._autoProgressOnCheckBox.setEnabled(false);
            }
            if ((displayFlags & 8) <= 0) {
                this._operationTimeoutLabel.setEnabled(false);
                this._operationTimeoutSeconds.setEnabled(false);
                this._operationTimeoutMinutes.setEnabled(false);
                this._operationTimeoutHours.setEnabled(false);
                this._operationTimeoutQuantity.setEnabled(false);
            }
            if (!(this._useOverlaysCheckBox.isEnabled() || this._useLabelDecorationsCheckBox.isEnabled() || this._silentlySaveCheckBox.isEnabled() || this._autoCheckoutsCheckBox.isEnabled())) {
                this._environmentSettingsLabel.setEnabled(false);
            }
            this.layoutComponents(displayFlags);
        }

        public JCheckBox getUseOverlaysCheckBox() {
            return this._useOverlaysCheckBox;
        }

        public JCheckBox getSilentlySaveCheckBox() {
            return this._silentlySaveCheckBox;
        }

        public JCheckBox getAutoCheckoutsCheckBox() {
            return this._autoCheckoutsCheckBox;
        }

        public JCheckBox getAutoAddFilesCheckBox() {
            return this._autoAddFilesCheckBox;
        }

        public JCheckBox getUseLabelDecorationsCheckBox() {
            return this._useLabelDecorationsCheckBox;
        }

        public JRadioButton getOperationTimeoutSeconds() {
            return this._operationTimeoutSeconds;
        }

        public JRadioButton getOperationTimeoutMinutes() {
            return this._operationTimeoutMinutes;
        }

        public JRadioButton getOperationTimeoutHours() {
            return this._operationTimeoutHours;
        }

        public NumberTextField getOperationTimeoutQuantity() {
            return this._operationTimeoutQuantity;
        }

        public JTextField getAutoCheckoutCommentField() {
            return this._autoCheckoutCommentField;
        }

        private void layoutComponents(int displayFlags) {
            Insets i = new Insets(2, 2, 2, 2);
            LayoutBuilder builder = new LayoutBuilder();
            int columns = (displayFlags & 8) > 0 ? 7 : 2;
            builder.setDefaultAnchor(18);
            builder.add((Component)this._environmentSettingsLabel, i, columns, false, true);
            builder.nl();
            builder.setDefaultAnchor(18);
            builder.addHGap();
            builder.add((Component)this._useOverlaysCheckBox, i, columns - 1, false, true);
            builder.nl();
            if ((displayFlags & 0x10) > 0) {
                builder.addHGap();
                builder.add((Component)this._useLabelDecorationsCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x40) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoAddFilesCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x100) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoLogMessagesCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 0x80) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoProgressOnCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            builder.setDefaultAnchor(18);
            builder.addHGap();
            builder.add((Component)this._autoCheckoutsCheckBox, i, columns - 1, false, true);
            builder.nl();
            if ((displayFlags & 0x20) > 0) {
                builder.addHGap();
                builder.add((Component)this._autoCheckoutCommentLabel, i, columns - 1, false, true);
                builder.nl();
                builder.addHGap();
                builder.add((Component)this._autoCheckoutCommentField, i, columns - 1, false, true);
                builder.nl();
            }
            if ((displayFlags & 2) > 0) {
                builder.setDefaultAnchor(18);
                builder.addHGap();
                builder.add((Component)this._silentlySaveCheckBox, i, columns - 1, false, true);
                builder.nl();
            }
            builder.setDefaultAnchor(18);
            builder.addVGap();
            builder.nl();
            builder.setDefaultAnchor(18);
            if ((displayFlags & 8) > 0) {
                builder.add((Component)this._operationTimeoutLabel, i, columns, false, true);
                builder.nl();
                builder.addHGap();
                builder.add((Component)this._operationTimeoutQuantity, i, 1, false, true);
                builder.add((Component)this._operationTimeoutSeconds, i, 1, false, false);
                builder.add((Component)this._operationTimeoutMinutes, i, 1, false, false);
                builder.add((Component)this._operationTimeoutHours, i, 1, false, false);
                builder.addHFiller();
                builder.nl();
                builder.addVGap();
                builder.nl();
            }
            builder.addToPanel((Container)this);
        }

        private JCheckBox getAutoProgessOnCheckoutCheckBox() {
            return this._autoProgressOnCheckBox;
        }

        private JCheckBox getAutoLogMessagesField() {
            return this._autoLogMessagesCheckBox;
        }
    }

    public static class ResourceProxy {
        protected String getString(int id) {
            return VCSArb.getString(id);
        }

        protected int getMnemonic(int id) {
            return VCSArb.getMnemonic(id);
        }
    }
}

