/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import oracle.jdeveloper.vcs.spi.VCSHashURL;

public abstract class VCSInvokableState {
    protected final Collection<URL> _urls;
    protected Collection<URL[]> _batches;
    protected int _maxBatchArguments = Integer.MAX_VALUE;
    protected int _n;
    protected final Collection<VCSHashURL> _completedUrls = new LinkedHashSet<VCSHashURL>();
    protected final Collection<VCSHashURL> _processedUrls = new LinkedHashSet<VCSHashURL>();
    protected int _batchCount;

    public VCSInvokableState(Collection<URL> urls) {
        this._urls = urls;
    }

    public URL[] getURLs() {
        return this._urls.toArray(new URL[0]);
    }

    void initialize(int maxBatchArguments) {
        this._maxBatchArguments = maxBatchArguments;
        this.reset();
    }

    int getN() {
        return this._n;
    }

    int getBatchCount() {
        return this._batchCount;
    }

    int getBatchesRemainingCount() {
        return this._batches.size();
    }

    URL[] nextURLs() {
        if (!this._batches.isEmpty()) {
            return this._batches.iterator().next();
        }
        return null;
    }

    void notifyProcessed(URL[] urls) {
        this._processedUrls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(urls)));
    }

    void notifyCompleted(URL[] urls) {
        this._completedUrls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(urls)));
        this._batches.remove(urls);
    }

    public boolean hasProcessed() {
        return this._processedUrls.size() > 0;
    }

    public boolean hasCompleted() {
        return this._completedUrls.containsAll(VCSHashURL.convertFromURLs(this._urls));
    }

    public Collection<URL> getCompletedURLs() {
        return Collections.unmodifiableCollection(VCSHashURL.convertToURLs(this._completedUrls));
    }

    public Collection<URL> getProcessedURLs() {
        return Collections.unmodifiableCollection(VCSHashURL.convertToURLs(this._processedUrls));
    }

    public abstract void reset();

    protected abstract String getProgressNote(URL var1);
}

