/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.vcs.VCSRegistry;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public class VCSController
implements Controller {
    public static final String VCS = "VCSController.VCS";
    public static final String COMMAND_RESULT = "VCSController.COMMAND_RESULT";
    static final String THREAD_AUTHORIZED = "VCSController.THREAD_AUTHORIZED";
    private final Package m_commandPackage;

    public VCSController(Package commandPackage) {
        this.m_commandPackage = commandPackage;
    }

    protected boolean isHandledAction(IdeAction action) {
        return action.getCommand() != null && action.getCommand().startsWith(this.m_commandPackage.getName());
    }

    protected Command createCommand(String command, Context context) {
        return CommandProcessor.createCommand((String)command, (Context)context);
    }

    public boolean handleEvent(final IdeAction action, final Context context) {
        if (this.isHandledAction(action)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSController.this.handleEventImpl(action, context);
                }
            });
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.isHandledAction(action)) {
            this.updateImpl(action, context);
            return true;
        }
        return false;
    }

    protected void updateImpl(IdeAction action, Context context) {
        VCSCommand clientCommand;
        if (!this.isSystemActive()) {
            action.setEnabled(false);
            return;
        }
        Command command = this.createCommand(action.getCommand(), context);
        this.prepareContext(context);
        this.preUpdate(action, command);
        VCSCommand vCSCommand = clientCommand = command instanceof VCSCommand ? (VCSCommand)command : null;
        if (clientCommand != null) {
            action.setEnabled(clientCommand.isAvailable());
        }
    }

    protected void preUpdate(IdeAction action, Command command) {
    }

    protected void handleEventImpl(IdeAction action, Context context) {
        Command command = this.createCommand(action.getCommand(), context);
        this.prepareContext(context);
        VCSCommand clientCommand = command instanceof VCSCommand ? (VCSCommand)command : null;
        this.preInvoke(action, command);
        try {
            int result = this.invokeCommand(action, command);
            if (result == 9 && clientCommand != null) {
                clientCommand.noOp();
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)e, (String)VCSArb.getString(11), (String)e.getMessage(), null);
            return;
        }
    }

    protected void preInvoke(IdeAction action, Command command) {
    }

    protected boolean isSystemActive() {
        return !VCSRegistry.keySet().isEmpty();
    }

    protected int invokeCommand(IdeAction action, Command command) throws Exception {
        return CommandProcessor.getInstance().invoke(command);
    }

    private void prepareContext(Context context) {
        context.setBoolean(THREAD_AUTHORIZED, true);
        context.setProperty(VCS, (Object)VCSExtensionUtils.getActiveExtension(context));
    }
}

