/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.share;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.ide.wizard.Wizard;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.share.ShareController;
import oracle.jdeveloper.vcs.share.ShareWizard;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

abstract class BaseShareCommand
extends VCSCommand {
    protected static final IdeAction getShareAction(int cmdId, String cmd, String text) {
        IdeAction shareAction = IdeAction.find((int)cmdId);
        if (shareAction != null) {
            return shareAction;
        }
        shareAction = IdeAction.get((int)cmdId, (String)cmd, (String)StringUtils.stripMnemonic((String)text), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)text)), (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
        shareAction.addController((Controller)new ShareController());
        return shareAction;
    }

    protected BaseShareCommand(int cmdId) {
        super(cmdId);
        this.initializeCommandStyle(VCSCommandStyle.SINGLE);
    }

    private Collection<Wizard> getAvailableWizards() {
        return ShareWizard.getAvailableWizards(this.createOperandContext());
    }

    private final Context createOperandContext() {
        Context context = new Context();
        Node node = this.getNodeOperand();
        if (node != null) {
            context.setSelection(new Element[]{node});
            context.setNode(node);
            context.setElement((Element)node);
        }
        return context;
    }

    protected abstract Node getNodeOperand();

    @Override
    protected boolean isAvailableImpl() throws Exception {
        Node node = this.getNodeOperand();
        if (node == null) {
            return false;
        }
        if (VCSManager.getVCSManager().isVersioned(node.getURL()) || this.isCandidate(node.getURL())) {
            return false;
        }
        Collection<Wizard> wizards = this.getAvailableWizards();
        return !wizards.isEmpty();
    }

    private boolean isCandidate(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs == null) {
            return false;
        }
        try {
            return vcs.getStatus(new URL[]{url})[0].isCandidate();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract String getDialogItemDescription(String var1);

    protected abstract String getDialogTitle();

    @Override
    protected int doitImpl() {
        Wizard wizard;
        Collection<Wizard> wizards = this.getAvailableWizards();
        if (wizards.isEmpty()) {
            throw new IllegalStateException();
        }
        if (wizards.size() == 1) {
            wizard = wizards.iterator().next();
        } else {
            final NiceList list = new NiceList();
            list.setCellRenderer((ListCellRenderer)new NiceListRenderer<Wizard>(){

                protected String getTitle(Wizard wizard) {
                    return wizard.getShortLabel();
                }

                protected String getDescription(Wizard wizard) {
                    return BaseShareCommand.this.getDialogItemDescription(wizard.getShortLabel());
                }

                protected boolean isItemSelected(Wizard wizard) {
                    return false;
                }

                protected Icon getIndicator(Wizard wizard) {
                    Icon icon = wizard.getIcon();
                    if (icon != null && icon instanceof ImageIcon) {
                        icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(24, 24, 4));
                    }
                    return icon;
                }

                protected boolean isCheckable(Wizard wizard) {
                    return false;
                }
            });
            Collections.sort((List)wizards, new Comparator<Wizard>(){

                @Override
                public int compare(Wizard o1, Wizard o2) {
                    return o1.getShortLabel().compareTo(o2.getShortLabel());
                }
            });
            DefaultListModel<Wizard> listModel = new DefaultListModel<Wizard>();
            for (Wizard o : wizards) {
                listModel.addElement(o);
            }
            list.setModel(listModel);
            list.setPrototypeCellValue((Object)new ShareWizard("Acme VCS v1.0", OracleIcons.getIcon((String)"action.png"), 0));
            list.setPreferredSize(new Dimension(320, 0));
            list.setVisibleRowCount(Math.min(wizards.size() + 1, 5));
            JLabel label = new JLabel();
            ResourceUtils.resLabel((JLabel)label, (Component)list, (String)VCSArb.getString(248));
            JPanel panel = new JPanel(new BorderLayout(4, 4));
            panel.add((Component)label, "North");
            panel.add((Component)new JScrollPane((Component)list), "Center");
            String title = this.getDialogTitle();
            DialogHeader dialogHeader = new DialogHeader(VCSArb.getString(252), ((ImageIcon)OracleIcons.getIcon((String)"header/database.png")).getImage());
            OnePageWizardDialogFactory.setDialogHeader((Component)panel, (DialogHeader)dialogHeader);
            final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)list, (String)title, (int)3);
            list.setSelectedIndex(0);
            list.addDoubleClickActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    dialog.closeDialog(false);
                }
            });
            list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    BaseShareCommand.this.updateDialogOKEnabled(dialog, (JList)list);
                }
            });
            this.updateDialogOKEnabled(dialog, (JList)list);
            if (!dialog.runDialog()) {
                return 1;
            }
            wizard = (Wizard)list.getSelectedValue();
        }
        return wizard.invoke(this.createOperandContext()) ? 0 : -1;
    }

    private void updateDialogOKEnabled(JEWTDialog dialog, JList list) {
        dialog.setOKButtonEnabled(list.getSelectedValue() != null);
    }
}

