/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.view.View;

public abstract class ConnectionProvider {
    private static final Map<String, ConnectionProvider> _providers = new HashMap<String, ConnectionProvider>();
    private String _vcsId;

    protected ConnectionProvider() {
    }

    public String getSystemId() {
        return this._vcsId;
    }

    public abstract Element getConnectionListNode();

    public String getALMTeamSourceControlType() {
        throw new UnsupportedOperationException();
    }

    public Element createConnectionListNode(Collection<Map<String, String>> criteria) {
        return this.createConnectionListNode(criteria, false);
    }

    public Element createConnectionListNode(Collection<Map<String, String>> criteria, boolean createConnections) {
        throw new UnsupportedOperationException();
    }

    public Observable getConnectionObservable() {
        throw new UnsupportedOperationException();
    }

    public static final void registerProvider(String vcsId, ConnectionProvider provider) {
        _providers.put(vcsId, provider);
        provider._vcsId = vcsId;
    }

    public static final ConnectionProvider lookupProvider(String vcsId) {
        return _providers.get(vcsId);
    }

    public static final boolean isVersioningConnectionView(View view) {
        if (view == null) {
            return false;
        }
        ViewId viewId = new ViewId(view.getId());
        return viewId.getType().equals("VersioningNavigatorWindow") || viewId.getType().equals("oracle-jdeveloper-vcsaccordion-VCS_ACCORDION_VIEW_TYPE");
    }

    protected Map<String, String> createTestCriteria(Map<String, String> criteria) {
        return criteria;
    }

    public Map<String, String> matchConnectionToCriteria(Collection<Map<String, String>> criteria, Map<String, String> connection) {
        String[] criteriaKeys = this.getConnectionCriteriaKeys();
        Collection<Object> connectionValues = this.getValuesFromCriteria(criteriaKeys, connection);
        if (connectionValues.isEmpty()) {
            return null;
        }
        for (Map<String, String> criteria1 : criteria) {
            Collection<Object> criteriaValues = this.getValuesFromCriteria(criteriaKeys, criteria1);
            if (!((Object)connectionValues).equals(criteriaValues)) continue;
            return criteria1;
        }
        return null;
    }

    private final Collection<Object> getValuesFromCriteria(String[] criteriaKeys, Map<String, String> criteria) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String criteriaKey : criteriaKeys) {
            if (!criteria.containsKey(criteriaKey)) continue;
            values.add(criteria.get(criteriaKey));
        }
        return values;
    }

    protected String[] getConnectionCriteriaKeys() {
        throw new UnsupportedOperationException();
    }

    public boolean canOpenVersionViewer(Map<String, String> criteria) {
        return false;
    }

    public void openVersionViewer(Map<String, String> criteria, String path, String revision) throws Exception {
        throw new UnsupportedOperationException();
    }
}

