/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.nav;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.vcs.nav.ConnectionNode;

public final class ConnectionNodeDecorator
extends DefaultContainer {
    private final Element _element;
    private ConnectionNode _connectionNode;

    public ConnectionNodeDecorator(Element element) {
        this._element = element;
    }

    public final ConnectionNode getConnectionNode() {
        return this._connectionNode;
    }

    public final void setConnectionNode(ConnectionNode connectionNode) {
        this._connectionNode = connectionNode;
    }

    public Icon getIcon() {
        return this._element.getIcon();
    }

    public String getToolTipText() {
        return this._element.getToolTipText();
    }

    public String getLongLabel() {
        return this._element.getLongLabel();
    }

    public String getShortLabel() {
        return this._element.getShortLabel();
    }

    protected void openImpl() throws IOException {
        Iterator itr = this._element.getChildren();
        while (itr != null && itr.hasNext()) {
            this._children.add(itr.next());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConnectionNodeDecorator.this._element instanceof LazyLoadable && !((LazyLoadable)ConnectionNodeDecorator.this._element).isOpen()) {
                    ConnectionNodeDecorator.this.forceNodeToCollapse();
                }
            }
        });
    }

    private void forceNodeToCollapse() {
        UpdateMessage.fireObjectClosed((Subject)this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectionNodeDecorator.this.setOpen(false);
            }
        });
    }

    protected void closeImpl() throws IOException {
        if (this._element instanceof Node) {
            ((Node)this._element).close();
        }
        this._children.clear();
    }
}

