/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset.cmd;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.cmd.BaseChangeSetCommand;
import oracle.jdeveloper.vcs.spi.VCSHashURL;

public abstract class ExistingChangeSetCommand
extends BaseChangeSetCommand {
    public ExistingChangeSetCommand() {
        super(0);
    }

    public int doit() throws Exception {
        ChangeSetAdapter adapter = this.getContextChangeSetAdapter();
        if (adapter == null) {
            return 1;
        }
        String name = this.getExistingChangeSetName();
        if (name == null) {
            throw new IllegalStateException();
        }
        URL[] urls = this.getContextURLs();
        Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(urls);
        for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
            adapter.removeFromChangeSet(VCSHashURL.convertToURLs(entry.getValue()).toArray(new URL[0]), entry.getKey());
        }
        adapter.addToChangeSet(urls, name);
        adapter.fireChangeSetsChanged();
        return 0;
    }

    protected abstract String getExistingChangeSetName();
}

