/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.ideimpl.controls.FlatTabbedWindow;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListController;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.util.IdeObserver;
import oracle.jdevimpl.vcs.util.PopupMenuListener;

public class ChangeListWindow
extends DockableWindow {
    private static final HelpInfo F1_HELP_INFO = new HelpInfo("f1_scspendingchanges_html");
    public static final int TOGGLE_COMMENTS_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.cmd.ToggleCommentsCommand");
    public static final int COPY_FILE_LIST_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.cmd.CopyFileListCommand");
    public static final int OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.cmd.OpenCommand");
    public static final int PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.cmd.PreferencesCommand");
    public static final int SET_SCOPE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.cmd.SetScopeCommand");
    public static final int SET_COMMENTS_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.cmd.SetCommentsCommand");
    public static final float CTX_GROUP_CONFLICTS = 1.0f;
    public static final float CTX_GROUP_OPERATIONS = 2.0f;
    public static final float CTX_GROUP_CLIPBOARD = 3.0f;
    public static final float CTX_GROUP_DIFF = 4.0f;
    public static final float CTX_GROUP_GENERAL = 5.0f;
    public static final float CTX_GROUP_SELECT_IN_NAV = 10.0f;
    private JPanel _panel;
    private final Controller _controller;
    private ChangeList[] _changeLists;
    private Listener _listener;
    private PropertyChangeListener _propertyChangeListener;
    private Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private ChangeListener _globalIgnoreListListener;
    private IdeListener _ideListener = null;
    private final String _persistenceKey;
    private ToggleToolButton _toggleToolButton;
    private List _persistenceKeys;
    private Object[] _modeIds;
    private JLabel _busyLabel;
    private Object _modeId;
    private FlatTabbedWindow _tabbedWindow;
    private JComboBox _scopeComboBox;
    private DefaultComboBoxModel _scopeComboBoxModel;
    private IdeObserver _scopeIdeObserver;
    private PropertyChangeListener _multiPropertyChangeListener;
    private final Action _refreshAllAction;
    private static final ScopeFilter ALL_APPLICATIONS_SCOPE = new ScopeFilter();
    private static final ScopeFilter ACTIVE_APPLICATION_SCOPE = new ScopeFilter(){

        @Override
        public boolean accept(URL url) {
            return this.getWorkspace() != null && super.accept(url);
        }
    };
    private ItemListener _scopeFilterListener;

    private static void createActions() {
        IdeAction toggleCommentsAction = IdeAction.get((int)TOGGLE_COMMENTS_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.cmd.ToggleCommentsCommand", (String)VCSArb.getString(80), (ArrayResourceBundle)VCSArb.getInstance(), (int)81);
        toggleCommentsAction.putValue("Check", (Object)Boolean.TRUE);
        IdeAction.get((int)COPY_FILE_LIST_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.cmd.CopyFileListCommand", (String)VCSArb.getString(83));
        IdeAction.get((int)OPEN_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.cmd.OpenCommand", (String)VCSArb.getString(86), null, (Integer)new Integer(VCSArb.getMnemonic(87)), null, null, (boolean)true);
        IdeAction.get((int)PREFERENCES_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.cmd.PreferencesCommand", (String)VCSArb.getString(240), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
        IdeAction.get((int)SET_SCOPE_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.cmd.SetScopeCommand", (String)VCSArb.getString(241), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
        IdeAction.get((int)SET_COMMENTS_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.cmd.SetCommentsCommand", (String)VCSArb.getString(242), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
    }

    public ChangeListWindow(ChangeList changeList, String windowID) {
        this(new ChangeList[]{changeList}, windowID);
    }

    protected ChangeListWindow(ChangeList[] changeLists, String windowID) {
        super(windowID);
        Ide.getSystem().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                if (Boolean.getBoolean("ide.vcs.noapplications") || Product.isRaptor()) {
                    return;
                }
                if (change.getMessageID() != IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    return;
                }
                Workspace workspace = (Workspace)change.getModifyObjects().get(1);
                if (workspace == ACTIVE_APPLICATION_SCOPE.getWorkspace()) {
                    return;
                }
                ACTIVE_APPLICATION_SCOPE.setWorkspace(workspace);
                if (ChangeListWindow.this._scopeComboBox.getSelectedItem() != null && ChangeListWindow.this._scopeComboBox.getSelectedItem() != ACTIVE_APPLICATION_SCOPE) {
                    return;
                }
                for (ChangeList changeList : ChangeListWindow.this.getChangeLists()) {
                    changeList.refreshImpl();
                }
            }
        });
        ACTIVE_APPLICATION_SCOPE.setWorkspace(Ide.getActiveWorkspace());
        this._scopeFilterListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                ChangeListWindow.this.updateScopeFilter();
            }
        };
        this._persistenceKey = this.createDisplayPersistenceKey(changeLists[0]);
        this._changeLists = changeLists;
        IdeAction.find((int)TOGGLE_COMMENTS_CMD_ID).setState(changeLists[0].isOptionsVisible());
        this._controller = this.createController();
        this.setType(32);
        this._busyLabel = new JLabel();
        this._busyLabel.setIcon(VCSArb.getIcon(88));
        this._scopeComboBoxModel = new DefaultComboBoxModel();
        this._scopeComboBox = new JComboBox(this._scopeComboBoxModel);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    return this;
                }
                if (value instanceof String) {
                    return this;
                }
                if (value == ALL_APPLICATIONS_SCOPE) {
                    this.setText(VCSArb.getString(89));
                    this.setIcon(OracleIcons.getIcon((String)"applications.png"));
                } else if (value == ACTIVE_APPLICATION_SCOPE) {
                    this.setText(VCSArb.getString(90));
                    this.setIcon(OracleIcons.getIcon((String)"application.png"));
                } else {
                    ScopeFilter scope = (ScopeFilter)value;
                    this.setText(scope.getShortLabel());
                    this.setIcon(scope.getIcon());
                }
                return this;
            }
        };
        this._scopeComboBox.setRenderer(renderer);
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(renderer.getFontMetrics(renderer.getFont()), "ReasonablyLongApplicationNameWithIcon.jws"), this._scopeComboBox.getPreferredSize().height);
        this._scopeComboBox.setMaximumSize(d);
        this._scopeComboBox.setPreferredSize(d);
        this._scopeComboBox.setMinimumSize(d);
        this._scopeIdeObserver = new IdeObserver(){

            @Override
            protected void updateImpl(Object source, UpdateMessage updateMessage) {
                int msgId = updateMessage.getMessageID();
                if (!(source != Ide.getWorkspaces() && !(source instanceof Workspace) || msgId != UpdateMessage.CHILD_ADDED && msgId != UpdateMessage.CHILD_REMOVED)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChangeListWindow.this.updateScopeComboBoxModel();
                        }
                    });
                }
            }
        };
        this._refreshAllAction = new RefreshAllAction();
        if (this.isMulti()) {
            this.constructMulti();
        }
        this.prefsChanged();
        this.updateScopeFilter();
        ChangeListener categoryCacheListener = new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent ce) {
                ChangeListWindow.this.updateScopeComboBoxModel();
            }
        };
        for (ChangeList changeList : this._changeLists) {
            changeList.setCategoryCacheListener(categoryCacheListener);
        }
    }

    public final String[] getContextPreferencesPath() {
        return this.getPreferencesPath();
    }

    protected String[] getPreferencesPath() {
        ChangeList changeList = this.getContextChangeList();
        return changeList != null ? changeList.getPreferencesPath() : null;
    }

    private void constructMulti() {
        int i;
        this._modeIds = new Object[this._changeLists.length];
        for (i = 0; i < this._changeLists.length; ++i) {
            this._modeIds[i] = this._changeLists[i].getModeId();
        }
        this._persistenceKeys = new ArrayList();
        for (i = 0; i < this._modeIds.length; ++i) {
            this._persistenceKeys.add(this.createDisplayPersistenceKey(this._modeIds[i]));
        }
        this._tabbedWindow = new FlatTabbedWindow(this.isTabCloseable());
        this._tabbedWindow.getCustomTab().setGapBeforeTabs(-1);
        for (i = 0; i < this._modeIds.length; ++i) {
            ChangeList changeList = this.getChangeList(this._modeIds[i]);
            changeList.putClientProperty(this.getModePersistenceKey(), this._modeIds[i]);
            String key = this.getTabToggleKey(changeList);
            if (key != null && !Ide.getDTCache().getBoolean(key, true)) continue;
            this.addToTabbedWindow(this.createModeText(changeList), changeList);
        }
        this._tabbedWindow.addTabbedWindowListener((TabbedWindowListener)new ModeTabbedWindowListener());
        Object modeId = this.getPersistedMode();
        if (modeId == null) {
            modeId = this._modeIds[0];
        }
        this.setModeId(modeId);
        IdeAction showDropdownAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        if (showDropdownAction != null) {
            showDropdownAction.addController(this.getController());
        }
        for (ChangeList changeList : this.getChangeLists()) {
            if (this.getTabToggleKey(changeList) == null) continue;
            this.getTabbedWindow().getCustomTab().addMouseListener((MouseListener)new MouseAdapter(){

                private void doIt(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        JPopupMenu menu = this.createSelectorMenu();
                        MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)ChangeListWindow.this.getTabbedWindow().getCustomTab(), (int)me.getX(), (int)me.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                    this.doIt(me);
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    this.doIt(me);
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    this.doIt(me);
                }

                private JPopupMenu createSelectorMenu() {
                    JPopupMenu popup = new JPopupMenu();
                    for (ChangeList changeList : ChangeListWindow.this.getChangeLists()) {
                        String key = ChangeListWindow.this.getTabToggleKey(changeList);
                        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this.createChangeListToggleAction(changeList, key));
                        mi.setSelected(ChangeListWindow.this.isChangeListVisible(changeList));
                        mi.setEnabled(key != null);
                        popup.add(mi);
                    }
                    MnemonicSolver mnemonicSolver = new MnemonicSolver(popup);
                    mnemonicSolver.solve();
                    return popup;
                }

                private Action createChangeListToggleAction(final ChangeList changeList, final String persistenceKey) {
                    return new AbstractAction(){
                        private final ChangeList _changeList;
                        private boolean _visible;
                        {
                            this.putValue("Name", changeList.getModeLongLabel());
                            this._changeList = changeList;
                            this._visible = ChangeListWindow.this.isChangeListVisible(changeList);
                        }

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            if (this._visible) {
                                ChangeListWindow.this.getTabbedWindow().removeComponent((Component)this._changeList);
                            } else {
                                ChangeListWindow.this.addToTabbedWindow(ChangeListWindow.this.createModeText(this._changeList), this._changeList);
                            }
                            boolean bl = this._visible = !this._visible;
                            if (persistenceKey != null) {
                                Ide.getDTCache().putBoolean(persistenceKey, this._visible);
                            }
                        }
                    };
                }
            });
            break;
        }
    }

    private boolean isTabCloseable() {
        for (ChangeList changeList : this.getChangeLists()) {
            if (this.getTabToggleKey(changeList) == null) continue;
            return true;
        }
        return false;
    }

    private void addToTabbedWindow(String modeText, ChangeList changelist) {
        this.getTabbedWindow().add(modeText, null, (Component)changelist, modeText, (Object)changelist, false);
        CustomTab customTab = this.getTabbedWindow().getCustomTab();
        customTab.getPage(customTab.getPageCount() - 1).setCloseable(this.getTabToggleKey(changelist) != null);
    }

    protected String getTabToggleKey(ChangeList changeList) {
        return changeList.getTabToggleKey();
    }

    private void updateScopeFilter() {
        ScopeFilter scopeFilter = (ScopeFilter)this._scopeComboBox.getSelectedItem();
        if (scopeFilter != null) {
            for (ChangeList changeList : this._changeLists) {
                changeList.setScopeFilter(scopeFilter);
            }
            Ide.getDTCache().putString(this.getScopePersistenceKey(), scopeFilter.toExternalForm());
        }
    }

    private void updateScopeComboBoxModel() {
        this._scopeComboBox.removeItemListener(this._scopeFilterListener);
        Object o = this._scopeComboBox.getSelectedItem();
        DefaultComboBoxModel<ScopeFilter> scopeComboBoxModel = new DefaultComboBoxModel<ScopeFilter>();
        scopeComboBoxModel.addElement(ACTIVE_APPLICATION_SCOPE);
        scopeComboBoxModel.addElement(ALL_APPLICATIONS_SCOPE);
        Comparator<Node> nodeComparator = new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                return node1.getShortLabel().compareTo(node2.getShortLabel());
            }
        };
        Workspace[] workspaces = VCSModelUtils.findCachedWorkspaces();
        Arrays.sort(workspaces, nodeComparator);
        Project[] projects0 = VCSModelUtils.findCachedProjects();
        Arrays.sort(projects0, nodeComparator);
        ArrayList<Project> projects = new ArrayList<Project>(Arrays.asList(projects0));
        for (Workspace workspace : workspaces) {
            scopeComboBoxModel.addElement(new ScopeFilter(workspace));
            for (Project project : projects) {
                if (!workspace.containsChild((Element)project)) continue;
                scopeComboBoxModel.addElement(new ScopeFilter(project));
            }
        }
        for (ChangeList changeList : this._changeLists) {
            ScopeFilter filter;
            Map<VCSHashURL, String> categoryCache;
            if (changeList.getCategorizer() == null || (categoryCache = changeList.getCategoryCache()) == null || categoryCache.isEmpty()) continue;
            HashSet<String> categoriesSet = new HashSet<String>(categoryCache.values());
            categoriesSet.remove(null);
            String[] categories = categoriesSet.toArray(new String[categoriesSet.size()]);
            Arrays.sort(categories, Collator.getInstance());
            for (String category : categories) {
                ScopeFilter filter2 = changeList.createCategoryScopeFilter(category);
                if (filter2 == null) continue;
                scopeComboBoxModel.addElement(filter2);
            }
            if (!categoryCache.values().contains(null) || (filter = changeList.createCategoryScopeFilter(null)) == null) continue;
            scopeComboBoxModel.addElement(filter);
        }
        this._scopeComboBox.setModel(scopeComboBoxModel);
        this._scopeComboBoxModel = scopeComboBoxModel;
        this._scopeComboBox.setSelectedItem(o);
        this._scopeComboBox.addItemListener(this._scopeFilterListener);
        this.updateScopeFilter();
    }

    boolean isMulti() {
        return this._changeLists.length > 1;
    }

    FlatTabbedWindow getTabbedWindow() {
        return this._tabbedWindow;
    }

    private ChangeList[] getChangeLists() {
        return this._changeLists;
    }

    public boolean isChangeListVisible(ChangeList changeList) {
        for (TabbedWindow.PageInfo pageInfo : this.getTabbedWindow().getPages()) {
            if (pageInfo._gui != changeList) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected ChangeList[] createChangeLists() {
        return this._changeLists;
    }

    public IdeAction createLocalAction(int cmdId) {
        return this.getLocalAction(cmdId);
    }

    public void prefsChanged() {
        this.updateEllipsisItems();
        this.preferencesChanged();
    }

    protected void updateEllipsisItems() {
    }

    protected void preferencesChanged() {
    }

    protected String getModePersistenceKey() {
        return ((Object)((Object)this)).getClass().getName() + ".Mode";
    }

    protected String getScopePersistenceKey() {
        return ((Object)((Object)this)).getClass().getName() + ".Scope";
    }

    protected String createDisplayPersistenceKey(ChangeList changeList) {
        return this.createDisplayPersistenceKey(changeList.getModeId());
    }

    protected String createDisplayPersistenceKey(Object modeId) {
        String key = ((Object)((Object)this)).getClass().getName();
        if (modeId != null) {
            key = key + "." + this.getModePersistenceValue(modeId);
        }
        key = key + ".DisplaySettings";
        return key;
    }

    protected ChangeList getChangeList(Object modeId) {
        if (!this.isMulti()) {
            return this.getChangeList();
        }
        int i = Arrays.asList(this._modeIds).indexOf(modeId);
        return i < 0 ? this.getChangeList() : this._changeLists[i];
    }

    protected String getModePersistenceValue(Object modeId) {
        return modeId.toString();
    }

    protected Object getModePersistenceObject(String value) {
        return value;
    }

    protected ChangeList createChangeList(Object modeId) {
        return new ChangeList(modeId);
    }

    protected Object getModeId() {
        return this._modeId;
    }

    protected void setModeId(Object modeId) {
        this.setModeIdInternal(modeId);
        if (modeId == null) {
            return;
        }
        this._tabbedWindow.setActive((Component)this.getChangeList(modeId));
    }

    private Object getModeIdInternal() {
        return this._modeId;
    }

    private void setModeIdInternal(Object modeId) {
        this._modeId = modeId;
    }

    private String createModeText(ChangeList changeList) {
        return MessageFormat.format("{0}: {1}", changeList.getModeLabel().replaceAll("&", ""), Integer.toString(changeList.getCount()));
    }

    private Object getPersistedMode() {
        String persistedMode = Ide.getDTCache().getString(this.getModePersistenceKey());
        return persistedMode != null ? this.getModePersistenceObject(persistedMode) : null;
    }

    private void updateControlsFromMode() {
        this._updateVisibleToolbarActions(this.getToolbar());
        this.updateVisibleChangeList();
        this.updateStatusMessage();
        this.updateBusyTickerVisible();
        this.updateRefreshEnabled();
        this.updatePersistedMode();
        this.updateEllipsisItems();
        this.updateVisibleActions();
    }

    private void updateVisibleChangeList() {
    }

    protected void updateBusyTickerVisible() {
        if (this._busyLabel != null) {
            this._busyLabel.setVisible(this.getContextChangeList().isBusy());
        }
        if (this._toolbar == null) {
            return;
        }
        this._toolbar.validate();
        this._toolbar.invalidate();
        this._toolbar.repaint();
    }

    private void updateRefreshEnabled() {
        this.getController().update(this.getLocalAction(51), this.getContext());
        boolean changeListIdle = false;
        for (ChangeList changeList : this._changeLists) {
            changeListIdle = changeListIdle || !changeList.isBusy();
        }
        this._refreshAllAction.setEnabled(changeListIdle);
    }

    private void updatePersistedMode() {
        Ide.getDTCache().putString(this.getModePersistenceKey(), this.getModePersistenceValue(this.getModeIdInternal()));
    }

    private JPanel getPanel() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this.layoutPanel(this._panel);
        }
        return this._panel;
    }

    protected void layoutPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        if (!this.isMulti()) {
            panel.add((Component)this._changeLists[0], "Center");
        } else {
            panel.add((Component)this._tabbedWindow, "Center");
        }
    }

    protected Controller createController() {
        return new ChangeListController(){

            @Override
            public boolean update(IdeAction action, Context context) {
                int cmdId = action.getCommandId();
                if (context.getView() instanceof ChangeListWindow && cmdId == 51) {
                    action.setEnabled(!((ChangeListWindow)context.getView()).getContextChangeList().isBusy());
                    return true;
                }
                return super.update(action, context);
            }

            @Override
            public boolean handleEvent(IdeAction action, Context context) {
                int cmdId = action.getCommandId();
                if (context.getView() instanceof ChangeListWindow && cmdId == 51) {
                    if (ChangeListWindow.this.authenticate()) {
                        ((ChangeListWindow)context.getView()).getContextChangeList().refresh();
                    }
                    return true;
                }
                return super.handleEvent(action, context);
            }
        };
    }

    public ChangeList getChangeList() {
        return this._changeLists[0];
    }

    public ChangeList getContextChangeList() {
        return this.getChangeList(this.getModeIdInternal());
    }

    protected void setEllipsisVisible(IdeAction localAction, boolean visible) {
        String text = (String)localAction.getValue("Name");
        boolean hasEllipsis = text.endsWith("...");
        if (hasEllipsis && !visible) {
            localAction.putValueDirectly("Name", (Object)text.substring(0, text.length() - 3));
        } else if (!hasEllipsis && visible) {
            localAction.putValueDirectly("Name", (Object)(text + "..."));
        }
    }

    protected IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    public HelpInfo getHelpInfo() {
        return F1_HELP_INFO;
    }

    public Icon getTabIcon() {
        return VCSIconArb.getIcon(14);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public String getTitleName() {
        return VCSArb.getString(78);
    }

    public final Controller getController() {
        return this._controller;
    }

    public Component getGUI() {
        return this.getPanel();
    }

    public final Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        context.setProperty("ChangeListWindow.PREEXPANSION", (Object)new Context(context));
        this.updateContext(context, false);
        return context;
    }

    private final void updateContext(Context context, boolean createNodes) {
        Element[] selection = this.getContextChangeList().getSelection();
        Project[] projects = new Project[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            if (!(selection[i] instanceof ChangeListItem)) continue;
            ChangeListItem changeListItem = (ChangeListItem)selection[i];
            projects[i] = changeListItem.getProject();
            try {
                Node n;
                Node node = n = createNodes ? changeListItem.findOrCreateNode() : changeListItem.findNode();
                if (n != null) {
                    selection[i] = n;
                }
                if (projects[i] != null || !(n instanceof Project)) continue;
                projects[i] = (Project)n;
                continue;
            }
            catch (Exception e) {
                if (!FeedbackManager.isOn()) continue;
                FeedbackManager.reportException((Throwable)e);
            }
        }
        context.setSelection(selection);
        if (selection.length == 1) {
            context.setNode(selection[0] instanceof Node ? (Node)selection[0] : null);
            Project project = projects[0] != null ? projects[0] : context.getProject();
            context.setProject(project);
            context.setWorkspace(project != null ? this.findWorkspaceForProject(project) : context.getWorkspace());
        } else {
            ArrayList<Context> contexts = new ArrayList<Context>();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] == null) continue;
                Context context2 = new Context(context);
                context2.setNode(selection[i] instanceof Node ? (Node)selection[i] : null);
                context2.setSelection(new Element[]{selection[i]});
                Project project = projects[i] != null ? projects[i] : context2.getProject();
                context2.setProject(project);
                context2.setWorkspace(project != null ? this.findWorkspaceForProject(project) : context2.getWorkspace());
                contexts.add(context2);
            }
            context.setProperty("ChangeListWindow.CONTEXTS", (Object)contexts.toArray(new Context[0]));
        }
        this.getContextChangeList().configureContext(context);
    }

    private Workspace findWorkspaceForProject(Project project) {
        for (Workspace workspace : VCSModelUtils.findCachedWorkspaces()) {
            if (!workspace.isOpen() || !workspace.projects().contains(project)) continue;
            return workspace;
        }
        return null;
    }

    public static final Context handleContext(Context context) {
        if (!(context.getView() instanceof ChangeListWindow)) {
            return context;
        }
        Context preexpansion = (Context)context.getProperty("ChangeListWindow.PREEXPANSION");
        if (preexpansion != null) {
            context = preexpansion;
            ((ChangeListWindow)context.getView()).updateContext(context, true);
        }
        return context;
    }

    protected Element[] getSelectionFromUI() {
        return this.getContextChangeList().getSelection();
    }

    public boolean isActive() {
        return this._listener != null;
    }

    public final void dockableShown(DockableEvent event) {
        super.dockableShown(event);
        this.initialize();
    }

    protected boolean authenticate() {
        return true;
    }

    public void refresh() {
        if (this._listener == null) {
            return;
        }
        for (int i = 0; i < this.getChangeLists().length; ++i) {
            this.getChangeLists()[i].refresh();
        }
    }

    protected void addToolbarToPanel(JPanel panel, Toolbar toolbar) {
        panel.add((Component)toolbar, "North");
    }

    protected void removeToolbarFromPanel(JPanel panel, Toolbar toolbar) {
        if (toolbar != null) {
            panel.remove((Component)toolbar);
        }
    }

    private void addChangeListListener(ChangeList changeList) {
        String persistenceKey;
        changeList.addSelectionListener(this._listener);
        changeList.addMouseListener(this._listener);
        if (changeList.getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            ChangeListCommentsCustomizer customizer = (ChangeListCommentsCustomizer)changeList.getOptionsCustomizer();
            customizer.addCaretListener(this._listener);
            customizer.addFocusListener(this._listener);
        }
        if ((persistenceKey = this.getPersistenceKey(changeList)) != null) {
            changeList.depersistVisualSettings(persistenceKey);
        }
    }

    protected String getPersistenceKey(ChangeList changeList) {
        if (!this.isMulti()) {
            return this._persistenceKey;
        }
        int i = Arrays.asList(this._modeIds).indexOf(changeList.getModeId());
        return i < 0 ? null : (String)this._persistenceKeys.get(i);
    }

    public void stateChange(int newState) {
        if (newState == 3) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ChangeListWindow.this.isVisible()) {
                        ChangeListWindow.this.deinitialize();
                    }
                }
            });
        }
        super.stateChange(newState);
    }

    protected void initialize() {
        int i;
        int i2;
        if (this._listener != null) {
            return;
        }
        this.addToolbarToPanel(this.getPanel(), this.getToolbar());
        this._propertyChangeListener = new PropertyListener();
        for (i2 = 0; i2 < this.getChangeLists().length; ++i2) {
            this.getChangeLists()[i2].addPropertyChangeListener(this._propertyChangeListener);
        }
        if (this.isMulti()) {
            this._multiPropertyChangeListener = new MultiPropertyListener();
            for (i2 = 0; i2 < this._modeIds.length; ++i2) {
                this.getChangeList(this._modeIds[i2]).addPropertyChangeListener(this._multiPropertyChangeListener);
            }
        }
        if (!this.isMulti()) {
            this.getChangeList().initializeChangeList(this);
        } else {
            for (i2 = 0; i2 < this._modeIds.length; ++i2) {
                this.getChangeList(this._modeIds[i2]).initializeChangeList(this);
            }
        }
        if (this.isMulti()) {
            this.updateControlsFromMode();
        }
        this.updateScopeComboBoxModel();
        String scopeExternalForm = Ide.getDTCache().getString(this.getScopePersistenceKey());
        if (scopeExternalForm == null) {
            scopeExternalForm = ACTIVE_APPLICATION_SCOPE.toExternalForm();
        }
        for (i = 0; i < this._scopeComboBox.getItemCount(); ++i) {
            ScopeFilter scopeFilter = (ScopeFilter)this._scopeComboBox.getItemAt(i);
            if (!scopeFilter.toExternalForm().equals(scopeExternalForm)) continue;
            this._scopeComboBox.setSelectedItem(scopeFilter);
            break;
        }
        if (this._scopeComboBox.getSelectedItem() == null) {
            this._scopeComboBox.setSelectedItem(ACTIVE_APPLICATION_SCOPE);
        }
        this._scopeIdeObserver.startObserving();
        this.delayedInitialization();
        for (i = 0; i < this.getChangeLists().length; ++i) {
            this.getChangeLists()[i].start();
        }
        this._listener = new Listener();
        for (i = 0; i < this.getChangeLists().length; ++i) {
            this.addChangeListListener(this.getChangeLists()[i]);
        }
        this._globalIgnoreListListener = new GlobalIgnoreListListener();
        ((ChangeEventSource)Ide.getSettings().getData("global-ignore-list")).addChangeListener(this._globalIgnoreListListener);
        this._ideListener = new MainWindowClosingListener();
        Ide.addIdeListener((IdeListener)this._ideListener);
    }

    protected void deinitialize() {
        int i;
        if (this._listener != null) {
            for (i = 0; i < this.getChangeLists().length; ++i) {
                this.removeChangeListListener(this.getChangeLists()[i]);
            }
            this._listener = null;
        }
        if (this._ideListener != null) {
            Ide.removeIdeListener((IdeListener)this._ideListener);
            this._ideListener = null;
        }
        if (this._globalIgnoreListListener != null) {
            ((ChangeEventSource)Ide.getSettings().getData("global-ignore-list")).removeChangeListener(this._globalIgnoreListListener);
            this._globalIgnoreListListener = null;
        }
        for (i = 0; i < this.getChangeLists().length; ++i) {
            this.getChangeLists()[i].stop();
        }
        if (this._propertyChangeListener != null) {
            for (i = 0; i < this.getChangeLists().length; ++i) {
                this.getChangeLists()[i].removePropertyChangeListener(this._propertyChangeListener);
            }
            this._propertyChangeListener = null;
        }
        if (this.isMulti() && this._multiPropertyChangeListener != null) {
            for (i = 0; i < this._modeIds.length; ++i) {
                this.getChangeList(this._modeIds[i]).removePropertyChangeListener(this._multiPropertyChangeListener);
            }
            this._multiPropertyChangeListener = null;
        }
        if (this._toolbar != null) {
            this._toolbar.removeAll();
            this.removeToolbarFromPanel(this.getPanel(), this._toolbar);
            this._toolbar = null;
        }
        if (this._contextMenu != null) {
            this.removeContextMenuListeners(this._contextMenu);
            this._contextMenu = null;
        }
        this._toggleToolButton = null;
        this._scopeComboBox.removeItemListener(this._scopeFilterListener);
        this._scopeComboBoxModel.removeAllElements();
        this._scopeIdeObserver.stopObserving();
        this.postDeinitialization();
    }

    protected void delayedInitialization() {
    }

    protected void postDeinitialization() {
    }

    private void removeChangeListListener(ChangeList changeList) {
        String persistenceKey = this.getPersistenceKey(changeList);
        if (persistenceKey != null) {
            changeList.persistVisualSettings(persistenceKey);
        }
        changeList.removeSelectionListener(this._listener);
        changeList.removeMouseListener(this._listener);
        if (changeList.getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            ChangeListCommentsCustomizer customizer = (ChangeListCommentsCustomizer)changeList.getOptionsCustomizer();
            customizer.removeCaretListener(this._listener);
            customizer.removeFocusListener(this._listener);
        }
    }

    public final Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.addToolbarActions(this._toolbar);
            this._toolbar.setFocusCycleRoot(true);
            this._toolbar.setFocusable(true);
            this._toolbar.setFocusTraversalPolicy((FocusTraversalPolicy)new DefaultFocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                    ChangeList changeList = ChangeListWindow.this.getContextChangeList();
                    Component c = changeList != null ? changeList.getFocusComponent() : null;
                    return c != null ? c : super.getComponentAfter(focusCycleRoot, aComponent);
                }
            });
        }
        return this._toolbar;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu(new MnemonicSolver());
            VCSMenuUtils.registerContextMenuForCompare(this._contextMenu);
            VCSMenuUtils.registerContextMenuForReplace(this._contextMenu);
            this.addContextMenuListeners(this._contextMenu);
        }
        return this._contextMenu;
    }

    protected void addContextMenuListeners(ContextMenu contextMenu) {
        if (!this.isMulti()) {
            this.getChangeList().addContextMenuListeners(contextMenu);
        } else {
            for (int i = 0; i < this._modeIds.length; ++i) {
                this.getChangeList(this._modeIds[i]).addContextMenuListeners(contextMenu);
            }
        }
    }

    protected void removeContextMenuListeners(ContextMenu contextMenu) {
        if (!this.isMulti()) {
            this.getChangeList().removeContextMenuListeners(contextMenu);
        } else {
            for (int i = 0; i < this._modeIds.length; ++i) {
                this.getChangeList(this._modeIds[i]).removeContextMenuListeners(contextMenu);
            }
        }
    }

    protected void addToolbarActions(Toolbar toolbar) {
        if (!this.isMulti()) {
            if (!Boolean.getBoolean("ide.vcs.noapplications") && !Product.isRaptor()) {
                toolbar.add((Component)this._scopeComboBox);
            }
            toolbar.add((ToggleAction)this.createLocalAction(51));
            toolbar.addSeparator();
            this.addCommentsToolbarAction(toolbar);
            if (!(toolbar.getComponentAtIndex(toolbar.getComponentCount() - 1) instanceof JToolBar.Separator)) {
                toolbar.addSeparator();
            }
            toolbar.add((Component)this._busyLabel);
            this.updateBusyTickerVisible();
            return;
        }
        this._updateVisibleToolbarActions(toolbar);
    }

    private void _updateVisibleToolbarActions(Toolbar toolbar) {
        toolbar.removeAll();
        this.updateVisibleToolbarActions(toolbar);
        if (!Boolean.getBoolean("ide.vcs.noapplications") && !Product.isRaptor()) {
            if (toolbar.getComponentCount() > 0) {
                toolbar.add((Component)toolbar.newSeparator(), 0);
            }
            toolbar.add((Component)this._scopeComboBox, 0);
        }
        if (!this.containsGlue((Container)toolbar)) {
            toolbar.add(Box.createGlue());
        }
        toolbar.add((Component)this._busyLabel);
        toolbar.validate();
        toolbar.invalidate();
        toolbar.repaint();
        this.updateBusyTickerVisible();
    }

    private boolean containsGlue(Container container) {
        for (Component c : container.getComponents()) {
            if (!(c instanceof Box.Filler)) continue;
            return true;
        }
        return false;
    }

    protected void updateVisibleToolbarActions(Toolbar toolbar) {
        this.addRefreshToolbarAction(toolbar);
        toolbar.addSeparator();
        this.getContextChangeList().addToolbarActions(this, toolbar);
    }

    protected void addCommentsToolbarAction(Toolbar toolbar) {
        if (this._toggleToolButton == null) {
            this._toggleToolButton = new ToggleToolButton((ToggleAction)this.getLocalAction(TOGGLE_COMMENTS_CMD_ID));
        }
        toolbar.add((Component)this._toggleToolButton);
    }

    protected void addRefreshToolbarAction(Toolbar toolbar) {
        ChangeList changeList = this.getContextChangeList();
        if (changeList != null) {
            changeList.addRefreshToolbarAction(this, toolbar);
        }
    }

    Action getRefreshAllAction() {
        return this._refreshAllAction;
    }

    public final void setOptionsVisible(boolean optionsVisible) {
        this.setCommentsVisible(optionsVisible);
    }

    protected void setCommentsVisible(boolean commentsVisible) {
        this.getChangeList().setOptionsVisible(commentsVisible);
    }

    public void requestFocusInChangeList() {
        this.getContextChangeList().requestFocusInChangeList();
    }

    public void requestFocusInComments() {
        this.getContextChangeList().requestFocusInOptions();
    }

    protected String getBusyStatusMessage() {
        return this.getBusyStatusMessage(null);
    }

    protected String getBusyStatusMessage(ChangeList changeList) {
        if (!this.isMulti() || changeList == null) {
            return VCSArb.getString(82);
        }
        return this.getBusyStatusMessage(changeList.getModeId());
    }

    protected String getBusyStatusMessage(Object modeId) {
        return this.getChangeList(modeId).getBusyStatusMessage();
    }

    protected void updateStatusMessage() {
        ChangeList[] changeLists = this.getChangeLists();
        for (int i = 0; i < changeLists.length; ++i) {
            if (!changeLists[i].isBusy() || !changeLists[i].isProgressTracked() || changeLists[i].getProgressTask() != null) continue;
            String message = this.getBusyStatusMessage(changeLists[i]);
            ChangeListProgressTask progressTask = new ChangeListProgressTask(changeLists[i], this.createProgressMessageText(message), this.createProgressTaskText(message));
            changeLists[i].setProgressTask(progressTask);
            Ide.getStatusBar().getProgressTracker().addTask((ProgressTrackedTask)progressTask);
        }
    }

    private String createProgressMessageText(String message) {
        return message.endsWith("...") ? message.substring(0, message.length() - 3) : message;
    }

    private String createProgressTaskText(String message) {
        return this.getTitleName() + ": " + message;
    }

    public final void doSetScope() {
        this._scopeComboBox.requestFocus();
        this._scopeComboBox.showPopup();
    }

    static {
        ChangeListWindow.createActions();
    }

    private class ChangeListProgressTask
    implements ProgressTrackedTask {
        private final ChangeList _changeList;
        private final String _message;
        private final String _task;

        ChangeListProgressTask(ChangeList changeList, String message, String task) {
            this._changeList = changeList;
            this._message = message;
            this._task = task;
        }

        public boolean isIndeterminate() {
            return true;
        }

        public void run() {
            ChangeListEventQueue changeListEventQueue = this._changeList.getEventQueue();
            while (this._changeList.isStarted() && changeListEventQueue != null && changeListEventQueue.isAlive() && this._changeList.isBusy() && this._changeList.getProgressTask() != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this._changeList.setProgressTask(null);
        }

        public int getCurrentValue() {
            return 0;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return 0;
        }

        public String getCurrentText() {
            return this._message;
        }

        public String getTaskDescription() {
            return this._task;
        }
    }

    private class GlobalIgnoreListListener
    implements ChangeListener {
        private GlobalIgnoreListListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ChangeListWindow.this.refresh();
        }
    }

    private class MainWindowClosingListener
    extends IdeAdapter {
        private MainWindowClosingListener() {
        }

        public void mainWindowClosing(IdeEvent e) {
            for (int i = 0; i < ChangeListWindow.this.getChangeLists().length; ++i) {
                String persistenceKey = ChangeListWindow.this.getPersistenceKey(ChangeListWindow.this.getChangeLists()[i]);
                if (persistenceKey == null) continue;
                ChangeListWindow.this.getChangeLists()[i].persistVisualSettings(persistenceKey);
            }
        }
    }

    private class Listener
    extends PopupMenuListener
    implements ChangeListener,
    CaretListener,
    FocusListener {
        private Listener() {
            super((View)ChangeListWindow.this);
        }

        private void fireViewSelectionChanged() {
            ChangeListWindow.this.updateSelection();
        }

        @Override
        protected boolean isDefaultAction(MouseEvent me) {
            if (super.isDefaultAction(me)) {
                return ChangeListWindow.this.getContextChangeList().isItemAtPosition(me.getPoint());
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.fireViewSelectionChanged();
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            this.fireViewSelectionChanged();
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.fireViewSelectionChanged();
        }

        @Override
        public void focusGained(FocusEvent fe) {
            this.fireViewSelectionChanged();
        }
    }

    private class MultiPropertyListener
    implements PropertyChangeListener {
        private MultiPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("changeListCount")) {
                this.propertyChangeListCountChange(pce);
            }
            if (propertyName.equals("busy")) {
                this.propertyBusyChange(pce);
            }
        }

        private void propertyChangeListCountChange(PropertyChangeEvent pce) {
            ChangeList changeList = (ChangeList)pce.getSource();
            if (ChangeListWindow.this._tabbedWindow.getTabPageForComponent((Component)changeList) == null) {
                return;
            }
            String tabLabel = ChangeListWindow.this.createModeText(changeList);
            ChangeListWindow.this._tabbedWindow.setTabName((Component)changeList, tabLabel);
            ChangeListWindow.this._tabbedWindow.setTabTooltip((Component)changeList, tabLabel);
            if (pce.getOldValue() != null && ((Integer)pce.getOldValue()).compareTo((Integer)pce.getNewValue()) < 0 && ChangeListWindow.this.getContextChangeList() != changeList) {
                ChangeListWindow.this._tabbedWindow.highlightPage((Component)changeList);
            }
        }

        private void propertyBusyChange(PropertyChangeEvent pce) {
            ChangeListWindow.this.updateBusyTickerVisible();
            ChangeListWindow.this.updateRefreshEnabled();
        }
    }

    private class PropertyListener
    implements PropertyChangeListener {
        private PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if ("busy".equals(pce.getPropertyName())) {
                ChangeListWindow.this.updateStatusMessage();
                View.updateToolbarActions((Toolbar)ChangeListWindow.this.getToolbar());
            }
            if ("optionsVisible".equals(pce.getPropertyName())) {
                IdeAction.find((int)TOGGLE_COMMENTS_CMD_ID).setState(ChangeListWindow.this.getChangeList().isOptionsVisible());
                View.updateToolbarActions((Toolbar)ChangeListWindow.this.getToolbar());
            }
        }
    }

    private class RefreshAllAction
    extends AbstractAction {
        RefreshAllAction() {
            super(StringUtils.stripMnemonic((String)VCSArb.getString(266)));
            this.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)VCSArb.getString(266)));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ChangeListWindow.this.refresh();
        }
    }

    private class ModeTabbedWindowListener
    implements TabbedWindowListener {
        private ModeTabbedWindowListener() {
        }

        public void activeChanged(TabbedWindowEvent twe) {
            ChangeListWindow.this.setModeIdInternal(((JComponent)twe.getData()).getClientProperty(ChangeListWindow.this.getModePersistenceKey()));
            ChangeListWindow.this.updateControlsFromMode();
        }
    }

    public static class ScopeFilter
    implements URLFilter {
        private Workspace _workspace;
        private Project _project;
        private final Map _projectContentCache = Collections.synchronizedMap(new WeakHashMap());

        protected ScopeFilter() {
            this(null, null);
        }

        ScopeFilter(Project project) {
            this(null, project);
        }

        ScopeFilter(Workspace workspace) {
            this(workspace, null);
        }

        private ScopeFilter(Workspace workspace, Project project) {
            this._workspace = workspace;
            this._project = project;
        }

        Workspace getWorkspace() {
            return this._workspace;
        }

        void setWorkspace(Workspace workspace) {
            this._workspace = workspace;
            if (this._workspace != null) {
                System.out.println("** Set " + this._workspace.hashCode());
            }
        }

        public String getShortLabel() {
            return this._workspace != null ? this._workspace.getShortLabel() : (this._project != null ? this._project.getShortLabel() : null);
        }

        public Icon getIcon() {
            return this._workspace != null ? this._workspace.getIcon() : (this._project != null ? this._project.getIcon() : null);
        }

        public boolean accept(URL url) {
            try {
                if (this._project != null) {
                    return VCSApplicationSystem.getApplicationSystem().canProjectHaveMember(this._project, this.getProjectContent(this._project), url);
                }
                if (this._workspace != null) {
                    return VCSApplicationSystem.getApplicationSystem().canWorkspaceHaveMember(this._workspace, new VCSApplicationSystem.ContentSetProxy(){

                        @Override
                        public ContentSet getContentSet(Project project) {
                            return ScopeFilter.this.getProjectContent(project).getContentSet(project);
                        }
                    }, url);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return !GlobalIgnoreList.isGloballyIgnored((URL)url);
        }

        private synchronized ChangeListProjectContent getProjectContent(Project project) {
            ChangeListProjectContent content = (ChangeListProjectContent)this._projectContentCache.get(project);
            if (content != null) {
                return content;
            }
            content = new ChangeListProjectContent(project);
            this._projectContentCache.put(project, content);
            return content;
        }

        public String toExternalForm() {
            if (this == ALL_APPLICATIONS_SCOPE) {
                return "ALL_APPLICATIONS";
            }
            if (this == ACTIVE_APPLICATION_SCOPE) {
                return "ACTIVE_APPLICATION";
            }
            if (this._workspace != null) {
                return "APPLICATION=" + this._workspace.getURL().toExternalForm();
            }
            if (this._project != null) {
                return "PROJECT=" + this._project.getURL().toExternalForm();
            }
            throw new IllegalStateException();
        }

        synchronized void clearCache() {
            this._projectContentCache.clear();
        }

        public final boolean equals(Object o) {
            return o instanceof ScopeFilter && this.toExternalForm().equals(((ScopeFilter)o).toExternalForm());
        }

        public final int hashCode() {
            return this.toExternalForm().hashCode();
        }
    }
}

