/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCategorizer;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventListener;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.DisplayableComparator;

public class ChangeListEventQueue {
    private final ChangeList _changeList;
    private final List<ChangeListEvent> _queue = new LinkedList<ChangeListEvent>();
    private boolean _alive = true;
    private int _updateDelay;
    private Thread _thread;
    private VCSCancellable _cancellable;
    private Collection<ChangeListEventListener> _eventListeners = new ArrayList<ChangeListEventListener>();
    private final Map<VCSHashURL, Collection<Project>> _urlToProjectCache = new WeakHashMap<VCSHashURL, Collection<Project>>();
    private static final boolean DEBUG = true;
    private static final Log LOG = new Log("vcs");

    public ChangeListEventQueue(ChangeList changeList) {
        this(changeList, 500);
    }

    public ChangeListEventQueue(ChangeList changeList, int updateDelay) {
        this._updateDelay = updateDelay;
        this._changeList = changeList;
    }

    protected ChangeList getChangeList() {
        return this._changeList;
    }

    public synchronized void addEventListener(ChangeListEventListener eventListener) {
        this._eventListeners.add(eventListener);
    }

    public synchronized void removeEventListener(ChangeListEventListener eventListener) {
        this._eventListeners.remove(eventListener);
    }

    public synchronized void setUpdateDelay(int updateDelay) {
        this._updateDelay = updateDelay;
    }

    public synchronized int getUpdateDelay() {
        return this._updateDelay;
    }

    public synchronized boolean isAlive() {
        return this._alive;
    }

    public synchronized void enqueue(ChangeListEvent event) {
        this._queue.add(event);
        this.notifyAll();
    }

    synchronized void curtail() {
        for (ChangeListEvent cle : this._queue) {
            if (cle.getKind() != 0) continue;
            cle.curtail();
        }
    }

    protected ChangeListItem[] createChangeListItems(URL[] urls) {
        return this.createChangeListItems(urls, true);
    }

    protected ChangeListItem[] createChangeListItems(URL[] urls, boolean bOverlay) {
        ChangeListItem[] items = new ChangeListItem[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            items[i] = this.createChangeListItem(urls[i], bOverlay);
        }
        return items;
    }

    protected ChangeListItem createChangeListItem(URL url) {
        VCSOverlayItemProducer overlayItemProducer = this._changeList.getOverlayItemProducer();
        VCSOverlayItem overlayItem = null;
        try {
            overlayItem = overlayItemProducer != null ? overlayItemProducer.getOverlayItems(new URL[]{url})[0] : null;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return new ChangeListItem(url, this._urlToProjectCache.get(new VCSHashURL(url)), overlayItem != null ? overlayItem.getOverlay() : null);
    }

    protected ChangeListItem createChangeListItem(URL url, boolean bOverlay) {
        if (bOverlay) {
            return this.createChangeListItem(url);
        }
        return new ChangeListItem(url, this._urlToProjectCache.get(new VCSHashURL(url)), null);
    }

    protected void setChangeListBusy(final boolean isBusy) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeListEventQueue.this._changeList.setBusy(isBusy);
            }
        });
    }

    protected void processEvent(ChangeListEvent cle) throws Exception {
        if (cle.getKind() == 0) {
            this.processRequeryEvent(cle);
        }
        if (cle.getKind() == 1) {
            this.processOverlayChange(cle.getURLs());
        }
        if (cle.getKind() == 2) {
            cle.getRunnable().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void processRequeryEvent(final ChangeListEvent cle) throws Exception {
        void var7_28;
        Map<VCSHashURL, String> categoryCache;
        void var6_19;
        URL[] urls0;
        int len$;
        Workspace[] arr$;
        ChangeListCategorizer categorizer;
        if (cle.isReplace()) {
            this._urlToProjectCache.clear();
        }
        if ((categorizer = this._changeList.getCategorizer()) != null) {
            Object object = categorizer.getRequeryMutex();
            synchronized (object) {
                if (!categorizer.canRequery()) {
                    categorizer.getRequeryMutex().wait();
                }
            }
        }
        LinkedHashSet<VCSHashURL> urls = new LinkedHashSet<VCSHashURL>();
        if (cle.getWorkspaces() != null) {
            void var6_11;
            arr$ = cle.getWorkspaces();
            len$ = arr$.length;
            boolean bl = false;
            while (var6_11 < len$) {
                Workspace workspace = arr$[var6_11];
                Iterator<URL> itr = VCSApplicationSystem.getApplicationSystem().createWorkspaceOnlyIterator(workspace, VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES);
                while (itr.hasNext()) {
                    urls.add(new VCSHashURL(itr.next()));
                }
                ++var6_11;
            }
        }
        if (cle.getProjects() != null) {
            void var6_13;
            arr$ = cle.getProjects();
            len$ = arr$.length;
            boolean bl = false;
            while (var6_13 < len$) {
                Workspace workspace = arr$[var6_13];
                Collection<VCSHashURL> projectUrls = this.listProjectURLs((Project)workspace);
                for (VCSHashURL url : projectUrls) {
                    Collection<Project> projects = this._urlToProjectCache.get(url);
                    if (projects == null) {
                        projects = new ArrayList<Project>(1);
                        this._urlToProjectCache.put(url, projects);
                    }
                    projects.add((Project)workspace);
                }
                urls.addAll(projectUrls);
                ++var6_13;
            }
        }
        if (cle.getURLs() != null) {
            urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(cle.getURLs())));
        }
        if (cle.getObjects() != null) {
            urls0 = VCSModelUtils.convertNodesToURLs(VCSModelUtils.getValidLocatables(cle.getObjects(), null));
            urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(urls0)));
            if (!this._changeList.isExcludeDirectories()) {
                URLPath projectUrlPath = new URLPath();
                Project[] projectArray = VCSModelUtils.findCachedProjects();
                int n = projectArray.length;
                for (int i$ = 0; i$ < n; ++i$) {
                    Project project = projectArray[i$];
                    projectUrlPath.add(new ChangeListProjectContent(project).getBaseURLPath());
                }
                for (URL uRL : VCSFileSystemUtils.getParentURLs(urls0)) {
                    if (projectUrlPath.getLongestMatchingEntry(uRL) == null) continue;
                    urls.add(new VCSHashURL(uRL));
                }
            }
        }
        urls0 = new ArrayList(urls);
        this.filterByProtocol((Collection<VCSHashURL>)urls0);
        for (int i = 0; i < urls0.size(); ++i) {
            VCSHashURL vCSHashURL = (VCSHashURL)urls0.get(i);
            String string = URLFileSystem.getSuffix((URL)vCSHashURL.getURL());
            if (!string.equals(".jws") && !string.equals(".jpr")) continue;
            urls0.set(i, new VCSHashURL(URLFileSystem.canonicalize((URL)vCSHashURL.getURL())));
        }
        ArrayList<VCSHashURL> urls1 = new ArrayList<VCSHashURL>((Collection<VCSHashURL>)urls0);
        Object var6_17 = null;
        Object var7_26 = null;
        if (categorizer != null) {
            ArrayList arrayList = new ArrayList(urls0);
            ArrayList arrayList2 = new ArrayList(urls0);
        }
        this.filterByStatus((Collection<VCSHashURL>)urls0);
        if (!this.isAlive()) {
            return;
        }
        urls1.removeAll((Collection<?>)urls0);
        final ArrayList<ChangeListItem> validItems = new ArrayList<ChangeListItem>(Arrays.asList(this.createChangeListItems(VCSHashURL.convertToURLs((Collection<VCSHashURL>)urls0).toArray(new URL[0]))));
        List<ChangeListItem> list = cle.isReplace() ? null : Arrays.asList(this.createChangeListItems(VCSHashURL.convertToURLs(urls1).toArray(new URL[0]), false));
        Collections.sort(validItems, new DisplayableComparator());
        if (categorizer != null) {
            this.filterByStatus((Collection<VCSHashURL>)var6_19, false);
        }
        Map<VCSHashURL, String> map = categoryCache = categorizer != null ? categorizer.mapURLsToCategory(VCSHashURL.convertToURLs((Collection<VCSHashURL>)var6_19)) : null;
        if (categorizer != null) {
            var7_28.removeAll((Collection<?>)var6_19);
        }
        void final_urls3 = var7_28;
        EventQueue.invokeLater(new Runnable((Collection)final_urls3, list){
            final /* synthetic */ Collection val$final_urls3;
            final /* synthetic */ Collection val$invalidItems;
            {
                this.val$final_urls3 = collection;
                this.val$invalidItems = collection2;
            }

            @Override
            public void run() {
                if (cle.isReplace()) {
                    if (categorizer != null) {
                        ChangeListEventQueue.this._changeList.setCategoryCache(categoryCache);
                    }
                    ChangeListEventQueue.this._changeList.getModel().replace(validItems);
                    return;
                }
                if (categorizer != null) {
                    HashMap<VCSHashURL, String> currentCache = new HashMap<VCSHashURL, String>(ChangeListEventQueue.this._changeList.getCategoryCache());
                    currentCache.keySet().removeAll(this.val$final_urls3);
                    currentCache.putAll(categoryCache);
                    ChangeListEventQueue.this._changeList.setCategoryCache(currentCache);
                }
                ChangeListEventQueue.this._changeList.getModel().remove(this.val$invalidItems);
                ChangeListEventQueue.this._changeList.getModel().add(validItems);
                if (cle.isUpdate()) {
                    ChangeListEventQueue.this._changeList.getModel().update(validItems);
                }
            }
        });
    }

    private Collection<VCSHashURL> listProjectURLs(Project project) throws Exception {
        this._cancellable = new VCSCancellable();
        Collection<VCSHashURL> urls = this.listProjectURLs(project, new ChangeListProjectContent(project), this._cancellable);
        this._cancellable = null;
        return urls;
    }

    protected Collection<VCSHashURL> listProjectURLs(Project project, ChangeListProjectContent projectContent, VCSCancellable cancellable) throws Exception {
        Collection<VCSHashURL> urls = VCSHashURL.convertFromURLs(Arrays.asList(projectContent.listURLs(!this._changeList.isExcludeDirectories(), cancellable)));
        if (!this.supportsRemovedEntries()) {
            return urls;
        }
        urls = new HashSet<VCSHashURL>(urls);
        if (project.isOpen() && this.isAlive()) {
            this.addRemovedEntryURLs(urls, URLFileSystem.getParent((URL)project.getURL()), cancellable);
        }
        Iterator<URL> itr = VCSApplicationSystem.getApplicationSystem().createProjectIterator(project, VCSApplicationSystem.ListMode.DIRECTORIES_ONLY);
        while (itr.hasNext() && (cancellable == null || !cancellable.isCancelled()) && this.isAlive()) {
            this.addRemovedEntryURLs(urls, itr.next(), cancellable);
        }
        return new ArrayList<VCSHashURL>(urls);
    }

    protected boolean supportsRemovedEntries() {
        return false;
    }

    protected void addRemovedEntryURLs(Collection<VCSHashURL> urls, URL directoryUrl, VCSCancellable cancellable) throws Exception {
    }

    private void filterByProtocol(Collection<VCSHashURL> urls) throws Exception {
        Iterator<VCSHashURL> itr = urls.iterator();
        while (itr.hasNext() && this.isAlive()) {
            VCSHashURL url = itr.next();
            if (this._changeList.getItemURLFilter().accept(url.getURL())) continue;
            LOG.trace("ChangeList: Ignoring URL: " + url);
            itr.remove();
        }
    }

    protected void filterByStatus(Collection<VCSHashURL> urls) throws Exception {
        this.filterByStatus(urls, true);
    }

    private final void filterByStatus(Collection<VCSHashURL> urls, boolean applyScope) throws Exception {
        ChangeListWindow.ScopeFilter scopeFilter;
        if (this._changeList.isExcludeDirectories()) {
            Iterator<VCSHashURL> itr = urls.iterator();
            while (itr.hasNext()) {
                if (!URLFileSystem.isDirectoryPath((URL)itr.next().getURL())) continue;
                itr.remove();
            }
        }
        if (applyScope && (scopeFilter = (ChangeListWindow.ScopeFilter)this._changeList.getScopeFilter()) != null) {
            scopeFilter.clearCache();
            Iterator<VCSHashURL> itr = urls.iterator();
            while (itr.hasNext()) {
                if (scopeFilter.accept(itr.next().getURL())) continue;
                itr.remove();
            }
        }
        LinkedList<VCSHashURL> urls0 = new LinkedList<VCSHashURL>(urls);
        ArrayList<VCSHashURL> urls1 = new ArrayList<VCSHashURL>();
        ArrayList<Object> urlStatuses = new ArrayList<Object>();
        int batchCount = this.getBatchCount();
        while (!urls0.isEmpty() && this.isAlive()) {
            for (int i = 0; i < batchCount && !urls0.isEmpty(); ++i) {
                urls1.add(urls0.removeFirst());
            }
            urlStatuses.addAll(Arrays.asList(this._changeList.getStatusCache().getValues(VCSHashURL.convertToURLs(urls1).toArray(new URL[0]))));
            urls1.clear();
        }
        if (!this.isAlive()) {
            return;
        }
        List<Object> displayStatuses = this._changeList.getVisibleStatuses() != null ? Arrays.asList(this._changeList.getVisibleStatuses()) : null;
        List<Object> filterStatuses = this._changeList.getFilterStatuses() != null ? Arrays.asList(this._changeList.getFilterStatuses()) : null;
        int i = 0;
        Iterator<VCSHashURL> itr = urls.iterator();
        while (itr.hasNext()) {
            VCSHashURL url = itr.next();
            if (url != null) {
                if (!displayStatuses.contains(urlStatuses.get(i))) {
                    itr.remove();
                } else if (filterStatuses != null && !filterStatuses.contains(urlStatuses.get(i))) {
                    itr.remove();
                }
            }
            ++i;
        }
    }

    protected int getBatchCount() {
        return 10;
    }

    protected void processOverlayChange(final URL[] urls) throws Exception {
        VCSOverlayItemProducer overlayItemProducer = this._changeList.getOverlayItemProducer();
        if (overlayItemProducer == null) {
            return;
        }
        final VCSOverlayItem[] overlayItems = overlayItemProducer.getOverlayItems(urls);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ChangeListEventQueue.this._changeList.getModel().getCount(); ++i) {
                    ChangeListItem changeListItem = (ChangeListItem)ChangeListEventQueue.this._changeList.getModel().getItem(i);
                    int j = Arrays.asList(urls).indexOf(changeListItem.getURL());
                    if (j < 0) continue;
                    changeListItem.setOverlay(overlayItems[j].getOverlay());
                    ChangeListEventQueue.this._changeList.getModel().update(Collections.singleton(changeListItem));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ChangeListEventQueue.this.eventLoop();
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
                ChangeListEventQueue.this._alive = false;
                ChangeListEventQueue.this.cancelListProjects();
            }
        };
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this._thread = new Thread(r, "ChangeListEventQueue " + this._changeList.getWindowId());
            this._thread.setPriority(1);
            this._alive = true;
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this.setAlive(false);
            this.cancelListProjects();
            this._thread = null;
        }
    }

    private synchronized void setAlive(boolean isAlive) {
        this._alive = isAlive;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelListProjects() {
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            if (this._cancellable != null) {
                this._cancellable.cancel();
            }
            this._cancellable = null;
        }
    }

    private void processEvents() throws InterruptedException {
        while (!this.isEmpty()) {
            if (!this.isAlive()) {
                return;
            }
            ChangeListEvent cle = this.dequeue();
            if (cle.isCurtailed()) continue;
            LOG.trace("ChangeList: Processing " + cle);
            try {
                this.fireEventDispatched(cle);
                this.processEvent(cle);
                this.fireEventProcessed(cle);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void fireEventDispatched(ChangeListEvent cle) {
        if (this._eventListeners.size() <= 0) {
            return;
        }
        ChangeListEventListener[] l = this._eventListeners.toArray(new ChangeListEventListener[0]);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].eventDispatched(cle);
        }
    }

    private synchronized void fireEventProcessed(ChangeListEvent cle) {
        if (this._eventListeners.size() <= 0) {
            return;
        }
        ChangeListEventListener[] l = this._eventListeners.toArray(new ChangeListEventListener[0]);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].eventProcessed(cle);
        }
    }

    private synchronized ChangeListEvent peekMajorEvent() {
        for (ChangeListEvent cle : this._queue) {
            if (cle.getKind() != 0) continue;
            return cle;
        }
        return null;
    }

    private synchronized ChangeListEvent dequeue() {
        ChangeListEvent event = this._queue.remove(0);
        this.notifyAll();
        return event;
    }

    private synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    private synchronized void awaitEvents() throws InterruptedException {
        while (this.isEmpty() && this.isAlive()) {
            this.wait();
        }
    }

    private void eventLoop() throws InterruptedException {
        while (true) {
            this.setChangeListBusy(false);
            this.awaitEvents();
            if (!this.isAlive()) {
                return;
            }
            Thread.sleep(this._updateDelay);
            if (this.peekMajorEvent() != null) {
                this.setChangeListBusy(true);
            }
            this.processEvents();
        }
    }
}

