/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import oracle.ide.config.ClientSetting;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;

public class ChangeListCommentsCustomizer
extends VCSCommentsCustomizer {
    public static final String KEY_SETTING_COMMENTS = "setting_comments";
    Map m_optionsMap;
    private ChangeListener _templatesChangeListener;

    public ChangeListCommentsCustomizer() {
        this.setFlatLook(true);
        this.setDefaultVisibleRows(1);
        this.setTemplatesAndCommentsOrientation(2);
    }

    @Override
    public void setRecentCommentsModel(VCSRecentCommentsModel commentsModel) {
        super.setRecentCommentsModel(commentsModel);
        commentsModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChangeListCommentsCustomizer.this.updateTemplatesAndComments();
            }
        });
    }

    @Override
    public void setClientSetting(ClientSetting clientSetting) {
        super.setClientSetting(clientSetting);
        this.maybeAttachToSettings();
    }

    @Override
    public void setTemplatesDataKey(String templatesDataKey) {
        super.setTemplatesDataKey(templatesDataKey);
        this.maybeAttachToSettings();
    }

    private final void maybeAttachToSettings() {
        if (this._templatesChangeListener != null) {
            return;
        }
        if (this.getClientSetting() != null && this.getTemplatesDataKey() != null) {
            VCSPropertyMap templatesPropertyMap = (VCSPropertyMap)this.getClientSetting().getData(this.getTemplatesDataKey());
            if (templatesPropertyMap == null) {
                return;
            }
            this._templatesChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    ChangeListCommentsCustomizer.this.updateTemplatesAndComments();
                    if (ChangeListCommentsCustomizer.this.isCommentTextChanged()) {
                        return;
                    }
                    String defaultTemplate = ChangeListCommentsCustomizer.this.getDefaultTemplate();
                    if (defaultTemplate != null && !defaultTemplate.equals("")) {
                        ChangeListCommentsCustomizer.this.getTextComponent().setText(defaultTemplate);
                    }
                }
            };
            templatesPropertyMap.addChangeListener(this._templatesChangeListener);
        }
    }

    public final String getDefaultTemplate() {
        if (this.getClientSetting() != null && this.getTemplatesDataKey() != null) {
            VCSPropertyMap templatesPropertyMap = (VCSPropertyMap)this.getClientSetting().getData(this.getTemplatesDataKey());
            String[] templatesValue = (String[])templatesPropertyMap.getMap().get("templates");
            Integer defaultTemplateIndex = (Integer)templatesPropertyMap.getMap().get("defaultTemplateIndex");
            if (templatesValue == null || defaultTemplateIndex == null) {
                return null;
            }
            if (defaultTemplateIndex < 0) {
                return null;
            }
            return templatesValue[defaultTemplateIndex];
        }
        return null;
    }

    public void addMouseListener(MouseListener ml) {
        this.getTextComponent().addMouseListener(ml);
    }

    public void removeMouseListener(MouseListener ml) {
        this.getTextComponent().removeMouseListener(ml);
    }

    public void setOptions(Map optionsMap) {
        this.m_optionsMap = optionsMap;
    }

    public Map getOptions() {
        this.getComponent();
        if (this.m_optionsMap == null) {
            this.m_optionsMap = new HashMap();
        }
        this.m_optionsMap.put(KEY_SETTING_COMMENTS, this.getTextComponent().getText());
        return new HashMap(this.m_optionsMap);
    }

    boolean hasFocus() {
        return this.getTextComponent().hasFocus();
    }

    void requestFocus() {
        this.getTextComponent().requestFocus();
    }

    void addFocusListener(FocusListener fl) {
        this.getTextComponent().addFocusListener(fl);
    }

    void removeFocusListener(FocusListener fl) {
        this.getTextComponent().removeFocusListener(fl);
    }

    void addCaretListener(CaretListener cl) {
        this.getTextComponent().addCaretListener(cl);
    }

    void removeCaretListener(CaretListener cl) {
        this.getTextComponent().removeCaretListener(cl);
    }

    boolean isEmpty() {
        return this.getTextComponent().getDocument().getLength() == 0;
    }

    boolean isTextSelected() {
        int start = this.getTextComponent().getSelectionStart();
        int end = this.getTextComponent().getSelectionEnd();
        return end - start > 0;
    }

    void delete() throws BadLocationException {
        int start = this.getTextComponent().getSelectionStart();
        int end = this.getTextComponent().getSelectionEnd();
        if (end - start > 0) {
            this.getTextComponent().getDocument().remove(start, end - start);
        }
    }

    public void clear() {
        String template = this.getDefaultTemplate();
        this.getTextComponent().setText(template != null ? template : "");
    }

    public void setCommentText(String text) {
        this.getTextComponent().setText(text);
    }

    public String getCommentText() {
        return this.getTextComponent().getText();
    }

    void cut() {
        this.getTextComponent().cut();
    }

    void copy() {
        this.getTextComponent().copy();
    }

    void paste() {
        this.getTextComponent().paste();
    }

    void selectAll() {
        this.getTextComponent().selectAll();
    }
}

