/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.EventObject;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.controller.Controller;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.AbstractFoldingMargin;
import oracle.jdeveloper.vcs.annotations.AnnotationComponent;
import oracle.jdeveloper.vcs.annotations.AnnotationController;
import oracle.jdeveloper.vcs.annotations.Annotations;

abstract class AnnotationView
extends AbstractFoldingMargin {
    public static int PLUGINWIDTH = 10;
    private AnnotationComponent _component;
    private AnnotationController _controller;
    private Color _bg;
    private MouseListener _popupTriggerListener;
    private final Context _ideContext;

    public AnnotationView(Context ideContext) {
        this._ideContext = ideContext;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
    }

    final Controller getController() {
        if (this._controller == null) {
            this._controller = new AnnotationController(this._component){

                @Override
                protected Annotations getAnnotations() {
                    return AnnotationView.this.getAnnotations();
                }

                @Override
                protected DateFormat getDateFormat() {
                    return AnnotationView.this.getDateFormat();
                }
            };
        }
        return this._controller;
    }

    protected abstract Annotations getAnnotations();

    protected abstract DateFormat getDateFormat();

    protected final void installImpl(BasicEditorPane editor) {
        this._editor = editor;
        this._bg = this._editor.getBackground();
        this.setBackground(this._bg);
        this._component = new AnnotationComponent(PLUGINWIDTH, this._bg, this._editor){

            @Override
            protected int getVirtualLineForReal(int line) {
                return AnnotationView.this.getVirtualLineForReal(line);
            }
        };
        this.add(this._component, "Center");
        this._popupTriggerListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            private void maybeTriggerPopup(MouseEvent me) {
                if (!me.isPopupTrigger()) {
                    return;
                }
                Context context = new Context(AnnotationView.this._ideContext);
                context.setEvent((EventObject)me);
                CodeEditorGutter.getGutterContextMenu().show(context);
            }
        };
        this._component.addMouseListener(this._popupTriggerListener);
    }

    protected final Observer getCodeFoldingObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (AnnotationView.this._component != null) {
                    AnnotationView.this._component.updateFromCodeFolding();
                }
            }
        };
    }

    protected void deinstallImpl(BasicEditorPane editor) {
        if (this._component != null) {
            if (this._popupTriggerListener != null) {
                this._component.removeMouseListener(this._popupTriggerListener);
            }
            this._popupTriggerListener = null;
            this.remove(this._component);
            this._component.dispose();
        }
        this._component = null;
    }

    protected final void repaintComponent() {
        if (this._component != null) {
            this._component.repaint();
        }
    }

    final void invalidateState() {
        if (this._component != null) {
            this._component.invalidateState();
        }
    }

    final void validateState() {
        if (this._component != null) {
            this._component.validateState();
        }
    }

    final boolean isStateValid() {
        return this._component != null && this._component.isStateValid();
    }
}

