/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.annotations.AnnotationMark;
import oracle.jdeveloper.vcs.annotations.Annotations;

class AnnotationComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int UNAVAILABLE_BLOCK_HEIGHT = 10;
    private BasicEditorPane _pane;
    private Font _font;
    private int _fontHeight;
    private Annotations _annotations;
    private Collection _annotationMarkSet;
    private AnnotationMark _mouseOverMark;
    private AnnotationMark _preClickedMark;
    private HighlightRegistry _hlRegistry;
    private HighlightStyle _hlStyle;
    private HighlightLayer _hlLayer;
    private boolean _stateValid = true;
    private BitSet _conflictingMarksBitSet = new BitSet();

    AnnotationComponent(int width, Color bg, BasicEditorPane pane) {
        this._pane = pane;
        this.setPreferredSize(new Dimension(width, 0));
        this.setMinimumSize(new Dimension(width, 0));
        this.setOpaque(true);
        this.setBackground(bg);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        toolTipManager.setInitialDelay(0);
        toolTipManager.setDismissDelay(10000);
        toolTipManager.setReshowDelay(0);
        this.registerMouseListener();
        this._hlRegistry = this._pane.getHighlightRegistry();
        this._hlStyle = this._hlRegistry.createStyle("annotation-highlight", "ANNOTATION-HIGHLIGHT", 100, Color.BLACK, AnnotationMark.BASECOLOR);
        this._hlLayer = this._pane.createHighlightLayer();
        this.updateLineHeight();
    }

    final void updateFromCodeFolding() {
        this.recalculateVirtualScope();
        this.repaint();
    }

    private final void recalculateVirtualScope() {
        Collection annotationMarkSet = this.getAnnotationMarkSet();
        if (annotationMarkSet == null) {
            return;
        }
        BitSet markOneBitSet = new BitSet();
        this._conflictingMarksBitSet.clear();
        for (AnnotationMark mark : annotationMarkSet) {
            Collection<int[]> scopePairSet = mark.getScopePairSet();
            ArrayList<int[]> virtualScopePairSet = new ArrayList<int[]>();
            for (int[] block : scopePairSet) {
                int start = this.getVirtualLineForReal(block[0]);
                int end = this.getVirtualLineForReal(block[1]);
                virtualScopePairSet.add(new int[]{start, end});
                for (int i = start; i <= end; ++i) {
                    if (!markOneBitSet.get(i)) {
                        markOneBitSet.set(i);
                        continue;
                    }
                    this._conflictingMarksBitSet.set(i);
                }
            }
            mark.setVirtualScopePairSet(virtualScopePairSet);
        }
    }

    protected int getVirtualLineForReal(int line) {
        return line;
    }

    private Collection getAnnotationMarkSet() {
        return this._annotationMarkSet;
    }

    private void registerMouseListener() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void deregisterMouseListener() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    final void setAnnotations(Annotations annotations, Collection annotationMarkSet) {
        this._annotations = annotations;
        this._annotationMarkSet = annotationMarkSet;
        this.updateFromCodeFolding();
        this.validateState();
    }

    final void invalidateState() {
        this._stateValid = false;
        this._mouseOverMark = null;
        this.removeAllHighlights();
        this.repaint();
    }

    final void validateState() {
        this._stateValid = true;
        this.repaint();
    }

    final boolean isStateValid() {
        return this._stateValid;
    }

    void dispose() {
        this.removeAllHighlights();
        this.deregisterMouseListener();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this._stateValid) {
            g.setColor(Color.RED);
            g.fillRect(0, 0, this.getWidth(), 10);
            g.setColor(AnnotationMark.SEPERATORCOLOR);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.drawLine(0, 10, this.getWidth(), 10);
            return;
        }
        this.updateLineHeight();
        this.drawAnnotations(g);
        this.drawHoveredAnnotation(g);
    }

    private void updateLineHeight() {
        Font currentFont = this._pane.getFont();
        if (this._font == null || currentFont != this._font) {
            this._font = currentFont;
            FontMetrics metrics = this.getFontMetrics(currentFont);
            this._fontHeight = metrics.getHeight();
        }
    }

    @Override
    public final String getToolTipText(MouseEvent event) {
        if (!this._stateValid && event.getPoint().y <= 10) {
            return VCSArb.getString(292);
        }
        if (this._mouseOverMark == null) {
            return null;
        }
        return this._mouseOverMark.getLabel();
    }

    private void drawAnnotations(Graphics g) {
        if (!this._stateValid) {
            return;
        }
        Collection annotationMarkSet = this.getAnnotationMarkSet();
        if (annotationMarkSet == null) {
            return;
        }
        for (AnnotationMark mark : annotationMarkSet) {
            this.drawAnnotationMark(g, mark);
        }
    }

    private void drawAnnotationMark(final Graphics g, final AnnotationMark mark) {
        this.visitMarkScope(mark, new MarkScopeVisitor(){

            @Override
            protected void visitImpl(int[] block) {
                AnnotationComponent.this.drawBlock(g, block[0], block[1], mark.getColor());
                AnnotationComponent.this.drawSeperator(g, block[0], block[1], AnnotationMark.SEPERATORCOLOR);
            }
        });
    }

    private void visitMarkScope(AnnotationMark mark, MarkScopeVisitor visitor) {
        Collection<int[]> scopePairSet = mark.getVirtualScopePairSet();
        for (int[] block : scopePairSet != null ? scopePairSet : mark.getScopePairSet()) {
            visitor.visit(block);
        }
    }

    protected void drawBlock(Graphics g, int blockBeginLine, int blockEndLine, Color color) {
        g.setColor(color);
        int topX = 0;
        int topY = blockBeginLine * this._fontHeight;
        int width = this.getWidth() + 1;
        int height = this._fontHeight * (blockEndLine - blockBeginLine + 1);
        g.fillRect(topX, topY, width, height);
    }

    protected void drawSeperator(Graphics g, int blockBeginLine, int blockEndLine, Color color) {
        g.setColor(color);
        int width = this.getWidth();
        int topX = 0;
        int topY = blockBeginLine * this._fontHeight;
        g.drawLine(topX, topY, topX + width, topY);
        int bottomX = 0;
        int bottomY = (blockEndLine + 1) * this._fontHeight;
        g.drawLine(bottomX, bottomY, topX + width, bottomY);
    }

    private void drawHoveredAnnotation(Graphics g) {
        if (this._mouseOverMark == null) {
            return;
        }
        this.drawAnnotationBorders(g, this._mouseOverMark);
    }

    private void drawAnnotationBorders(final Graphics g, AnnotationMark mark) {
        this.visitMarkScope(mark, new MarkScopeVisitor(){

            @Override
            protected void visitImpl(int[] block) {
                AnnotationComponent.this.drawBorder(g, block[0], block[1], AnnotationMark.BORDERCOLOR);
            }
        });
    }

    protected void drawBorder(Graphics g, int blockBeginLine, int blockEndLine, Color color) {
        g.setColor(color);
        int topX = 0;
        int topY = blockBeginLine * this._fontHeight;
        int width = this.getWidth();
        int height = this._fontHeight * (blockEndLine - blockBeginLine + 1);
        g.drawRect(topX, topY, width, height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.hightlightCodeInEditor();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateMouseInMark(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.updateMouseInMark(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateMouseInMark(e);
    }

    protected void updateMouseInMark(MouseEvent event) {
        if (event != null) {
            int x = event.getX();
            int y = event.getY();
            int id = event.getID();
            switch (id) {
                case 505: {
                    this._mouseOverMark = null;
                    break;
                }
                case 503: 
                case 504: {
                    this._mouseOverMark = this.getMarkUnderMouse(x, y);
                }
            }
            this.getToolTipText(event);
        } else {
            this._mouseOverMark = null;
        }
        this.repaint();
    }

    private void hightlightCodeInEditor() {
        if (!this._stateValid) {
            return;
        }
        this.removeAllHighlights();
        if (this._mouseOverMark == null || this._preClickedMark == this._mouseOverMark) {
            this._preClickedMark = null;
            return;
        }
        Set<Integer> scope = this._mouseOverMark.getScopeSet();
        for (Integer line : scope) {
            this._hlLayer.addLineHighlight(this._hlStyle, line.intValue());
        }
        this._preClickedMark = this._mouseOverMark;
    }

    void removeAllHighlights() {
        this._hlLayer.removeAllHighlights();
    }

    protected AnnotationMark getMarkUnderMouse(int x, int y) {
        if (!this._stateValid) {
            return null;
        }
        if (this._annotations == null) {
            return null;
        }
        final int line = (int)Math.floor(y / this._fontHeight);
        if (line < 0 || line > this._annotations.getLineCount()) {
            return null;
        }
        Collection annotationMarkSet = this.getAnnotationMarkSet();
        if (annotationMarkSet == null) {
            return null;
        }
        for (AnnotationMark mark : annotationMarkSet) {
            final boolean[] accepted = new boolean[1];
            this.visitMarkScope(mark, new MarkScopeVisitor(){

                @Override
                protected void visitImpl(int[] block) {
                    if (line >= block[0] && line <= block[1]) {
                        accepted[0] = true;
                    }
                }
            });
            if (!accepted[0]) continue;
            return mark;
        }
        return null;
    }

    private abstract class MarkScopeVisitor {
        private MarkScopeVisitor() {
        }

        void visit(int[] block) {
            if (block[0] < 0 || block[1] < 0) {
                return;
            }
            int i = block[0];
            while (i <= block[1]) {
                if (AnnotationComponent.this._conflictingMarksBitSet.get(i)) {
                    ++i;
                    continue;
                }
                int j = AnnotationComponent.this._conflictingMarksBitSet.nextSetBit(i + 1);
                j = j < 0 ? block[1] : Math.min(block[1], j - 1);
                int[] nArray = new int[]{i, j++};
                this.visitImpl(nArray);
                i = j;
            }
        }

        protected abstract void visitImpl(int[] var1);
    }
}

