/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.merge.RestartMergeCommand;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.resource.CompareArb;

public class MergeController
extends CompareController {
    private static MergeController _singleton;
    static final String GO_FIRST_CONFLICT_CMD = "merge.navigateFirstConflict";
    static final int GO_FIRST_CONFLICT_CMD_ID;
    static final String GO_PREVIOUS_CONFLICT_CMD = "merge.navigatePreviousConflict";
    static final int GO_PREVIOUS_CONFLICT_CMD_ID;
    static final String GO_NEXT_CONFLICT_CMD = "merge.navigateNextConflict";
    static final int GO_NEXT_CONFLICT_CMD_ID;
    static final String GO_LAST_CONFLICT_CMD = "merge.navigateLastConflict";
    static final int GO_LAST_CONFLICT_CMD_ID;

    public static final MergeController getDefaultMergeController() {
        if (_singleton == null) {
            _singleton = new MergeController();
        }
        return _singleton;
    }

    public boolean update(IdeAction action, Context context) {
        if (this._update(action, context)) {
            if (context.getView() instanceof AbstractMergeEditor && ((AbstractMergeEditor)context.getView()).isCompleteState()) {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (super.handleEvent(action, context)) {
            return true;
        }
        CompareView compareView = this.getCompareView(context);
        if (compareView != null && compareView instanceof BaseCompareView) {
            BaseCompareView navigableView = (BaseCompareView)compareView;
            if (action.getCommandId() == GO_FIRST_CONFLICT_CMD_ID) {
                navigableView.goToFirstConflict();
                return true;
            }
            if (action.getCommandId() == GO_NEXT_CONFLICT_CMD_ID) {
                if (!navigableView.hasNextConflict()) {
                    return true;
                }
                boolean gotNext = navigableView.goToNextConflict();
                if (!gotNext && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.getString((int)39), (String)CompareArb.getString((int)38), null)) {
                    navigableView.goToFirstConflict();
                }
                return true;
            }
            if (action.getCommandId() == GO_PREVIOUS_CONFLICT_CMD_ID) {
                if (!navigableView.hasPreviousConflict()) {
                    return true;
                }
                boolean gotPrev = navigableView.goToPreviousConflict();
                if (!gotPrev && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.getString((int)37), (String)CompareArb.getString((int)36), null)) {
                    navigableView.goToLastConflict();
                }
                return true;
            }
            if (action.getCommandId() == GO_LAST_CONFLICT_CMD_ID) {
                navigableView.goToLastConflict();
                return true;
            }
        }
        return false;
    }

    private boolean _update(IdeAction action, Context context) {
        if (super.update(action, context)) {
            return true;
        }
        CompareView compareView = this.getCompareView(context);
        if (compareView != null) {
            if (action.getCommandId() == GO_FIRST_CONFLICT_CMD_ID || action.getCommandId() == GO_LAST_CONFLICT_CMD_ID) {
                if (compareView.getModel() == null) {
                    return false;
                }
                action.setEnabled(compareView instanceof BaseCompareView && ((BaseCompareView)compareView).hasNavigableConflicts());
                return true;
            }
            if (action.getCommandId() == GO_NEXT_CONFLICT_CMD_ID) {
                action.setEnabled(compareView instanceof BaseCompareView && ((BaseCompareView)compareView).hasNextConflict());
                return true;
            }
            if (action.getCommandId() == GO_PREVIOUS_CONFLICT_CMD_ID) {
                action.setEnabled(compareView instanceof BaseCompareView && ((BaseCompareView)compareView).hasPreviousConflict());
                return true;
            }
        }
        if (action.getCommandId() == SaveMergeCommand.SAVE_MERGE_CMD_ID) {
            if (!(context.getView() instanceof AbstractMergeEditor)) {
                action.setEnabled(false);
                return true;
            }
            action.setEnabled(((AbstractMergeEditor)context.getView()).isSaveEnabled());
            return true;
        }
        if (action.getCommandId() == RestartMergeCommand.RESTART_MERGE_CMD_ID) {
            if (!(context.getView() instanceof AbstractMergeEditor)) {
                action.setEnabled(false);
                return true;
            }
            action.setEnabled(((AbstractMergeEditor)context.getView()).isRestartEnabled());
            return true;
        }
        if (action.getCommandId() == 51) {
            if (!(context.getView() instanceof AbstractMergeEditor)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }
        return false;
    }

    static {
        GO_FIRST_CONFLICT_CMD_ID = Ide.findOrCreateCmdID((String)GO_FIRST_CONFLICT_CMD);
        GO_PREVIOUS_CONFLICT_CMD_ID = Ide.findOrCreateCmdID((String)GO_PREVIOUS_CONFLICT_CMD);
        GO_NEXT_CONFLICT_CMD_ID = Ide.findOrCreateCmdID((String)GO_NEXT_CONFLICT_CMD);
        GO_LAST_CONFLICT_CMD_ID = Ide.findOrCreateCmdID((String)GO_LAST_CONFLICT_CMD);
    }
}

