/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xmlschema;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ElementAttributes;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.SectionView;

public class XmlSchemaNode
extends DatabaseSourceNode {
    public boolean isReadOnly() {
        return true;
    }

    protected void saveImpl() throws IOException {
        boolean bl = this.isDirty();
        if (bl) {
            if (!DBURLFormatHelper.isDBURL((URL)this.getURL())) {
                super.saveImpl();
            } else {
                Component component;
                String string = (String)this.getProperty("ConnectionName");
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("URL", this.getProperty("NAME"));
                TextBuffer textBuffer = this.getTextBufferDirectly();
                hashMap.put("DOC", textBuffer.getString(0, textBuffer.getLength()));
                hashMap.put("OWNER", this.getProperty("SCHEMA"));
                QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/navigator/xmlschema/XmlSchemaSQL.xml");
                Query query = queryXMLSupport.getQuery("RegisterXMLSchema", string);
                if (query == null) {
                    throw new IOException("RDBMS version mismatch - XMLSchema not supported");
                }
                if (!DBUtil.getInstance((String)string).execute(query.getSql(), hashMap)) {
                    throw new IOException("Error saving XML schema");
                }
                this.markDirty(false);
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor.getContext().getNode() == this && editor instanceof CodeEditor && (component = ((CodeEditor)editor).getGUI()) instanceof SectionView && ((SectionView)component).getWrappedComponent() instanceof BasicEditorPane) {
                    ((BasicEditorPane)((SectionView)component).getWrappedComponent()).setProtected(true);
                }
                this.setReadOnly(true);
                this.getAttributes().set(ElementAttributes.READ_ONLY);
                this.getAttributes().set(ElementAttributes.NON_EDITABLE);
                textBuffer.setReadOnly(true);
            }
        }
    }

    protected Reader createReader(URL uRL) throws IOException {
        StringReader stringReader = null;
        String string = (String)this.getProperty("ConnectionName");
        try {
            Database database = Connections.getInstance().getDatabase(string, false);
            XMLSchema xMLSchema = (XMLSchema)database.getObject((String)this.getProperty("TYPE"), database.getSchema((String)this.getProperty("SCHEMA")), (String)this.getProperty("NAME"));
            if (xMLSchema != null) {
                this.setReadOnly(true);
                this.getAttributes().set(ElementAttributes.READ_ONLY);
                this.getAttributes().set(ElementAttributes.NON_EDITABLE);
                Map map = xMLSchema.getProperties();
                String string2 = xMLSchema.getSchemaText();
                stringReader = string2 != null ? new StringReader(string2) : new StringReader("");
            }
        }
        catch (DBException dBException) {
            throw new IOException(dBException.getMessage());
        }
        return stringReader;
    }
}

