/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.jar.Manifest;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.JarDirectoryStorage;
import oracle.ojc.storage.JarFileStorage;

public final class JarStorage
extends DirectoryStorage {
    RandomAccessFile r;
    private JarFileStorage manifestFile;
    private static int openJarCounter = 0;

    public JarStorage(AbstractStorage storage, String name) {
        super(storage, name);
        this.readJarDirectory();
        if (this.r != null) {
            ++openJarCounter;
        }
    }

    public JarStorage(File file) {
        super(file);
        this.readJarDirectory();
        if (this.r != null) {
            ++openJarCounter;
        }
    }

    public boolean isOpen() {
        return this.r != null;
    }

    public Manifest getManifest() {
        if (this.manifestFile == null) {
            return null;
        }
        try {
            byte[] bytes = this.manifestFile.read();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
            return new Manifest(bytesIn);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getOpenJarCount() {
        return openJarCounter;
    }

    private void readJarDirectory() {
        try {
            this.r = new RandomAccessFile(this.file, "r");
            byte[] dirvec = this.findDir();
            int entryCount = JarStorage.get2LE(dirvec, 0);
            int pos = 2;
            for (int i = 0; i < entryCount; ++i) {
                pos = this.readEntry(dirvec, pos);
            }
        }
        catch (IOException e) {
            this.r = null;
        }
    }

    private byte[] findDir() throws IOException {
        byte[] endbuf = new byte[1024];
        int endbufLen = endbuf.length;
        long endbufEnd = this.r.length();
        while (endbufEnd >= 22L) {
            int i;
            if (endbufEnd < (long)endbufLen) {
                endbufLen = (int)endbufEnd;
            }
            long endbufPos = endbufEnd - (long)endbufLen;
            this.r.seek(endbufPos);
            if (this.r.read(endbuf, 0, endbufLen) != endbufLen) {
                throw new IOException("read error");
            }
            for (i = endbufLen - 22; i >= 0 && (endbuf[i] != 80 || endbuf[i + 1] != 75 || endbuf[i + 2] != 5 || endbuf[i + 3] != 6 || endbufPos + (long)i + 22L + (long)JarStorage.get2LE(endbuf, i + 20) > this.r.length()); --i) {
            }
            if (i >= 0) {
                byte[] dirvec = new byte[JarStorage.get4LE(endbuf, i + 12) + 2];
                dirvec[0] = endbuf[i + 10];
                dirvec[1] = endbuf[i + 11];
                this.r.seek(JarStorage.get4LE(endbuf, i + 16));
                if (this.r.read(dirvec, 2, dirvec.length - 2) != dirvec.length - 2) {
                    throw new IOException("read error");
                }
                return dirvec;
            }
            endbufEnd = endbufPos + 21L;
        }
        throw new IOException("bad zip file");
    }

    private int readEntry(byte[] dirbuf, int pos) throws IOException {
        String name;
        if (JarStorage.get4LE(dirbuf, pos) != 33639248) {
            throw new IOException("bad dir entry");
        }
        int dosTime = JarStorage.get4LE(dirbuf, pos + 12);
        int csize = JarStorage.get4LE(dirbuf, pos + 20);
        int size = JarStorage.get4LE(dirbuf, pos + 24);
        int offset = JarStorage.get4LE(dirbuf, pos + 42);
        int len = JarStorage.get2LE(dirbuf, pos + 28);
        char[] cbuf = new char[len];
        int clen = 0;
        DirectoryStorage curDir = this;
        int nameBase = pos + 46;
        int lastDirLen = 0;
        boolean utf8 = false;
        block3: for (int i = 0; i < len; ++i) {
            byte b = dirbuf[nameBase++];
            switch (b) {
                default: {
                    if ((b & 0x80) != 0) {
                        utf8 = true;
                    }
                    cbuf[clen++] = (char)(b & 0xFF);
                    continue block3;
                }
                case 47: 
                case 92: {
                    name = utf8 ? this.makeUTF8Name(cbuf, clen) : new String(cbuf, 0, clen);
                    utf8 = false;
                    lastDirLen = clen;
                    clen = 0;
                    DirectoryStorage d = (DirectoryStorage)curDir.find(name);
                    if (d != null) {
                        curDir = d;
                        continue block3;
                    }
                    JarDirectoryStorage dir = new JarDirectoryStorage(curDir, name);
                    curDir.entries.put(name, dir);
                    curDir = dir;
                }
            }
        }
        name = utf8 ? this.makeUTF8Name(cbuf, clen) : new String(cbuf, 0, clen);
        JarFileStorage jarFile = new JarFileStorage(this, curDir, name, offset, size, csize, dosTime);
        if (clen == 11 && lastDirLen == 8 && name.equalsIgnoreCase("manifest.mf") && curDir.getName().equalsIgnoreCase("meta-inf")) {
            this.manifestFile = jarFile;
        }
        curDir.entries.put(name, jarFile);
        return pos + 46 + len + JarStorage.get2LE(dirbuf, pos + 30) + JarStorage.get2LE(dirbuf, pos + 32);
    }

    private String makeUTF8Name(char[] cbuf, int len) throws IOException {
        byte[] bbuf = new byte[len];
        for (int x = 0; x < len; ++x) {
            bbuf[x] = (byte)cbuf[x];
        }
        return new String(bbuf, 0, len, "UTF-8");
    }

    static int get2LE(byte[] buf, int pos) {
        return ((buf[pos + 1] & 0xFF) << 8) + (buf[pos] & 0xFF);
    }

    static int get4LE(byte[] buf, int pos) {
        return ((buf[pos + 3] & 0xFF) << 24) + ((buf[pos + 2] & 0xFF) << 16) + ((buf[pos + 1] & 0xFF) << 8) + (buf[pos] & 0xFF);
    }

    @Override
    public void close() {
        try {
            if (this.r != null) {
                --openJarCounter;
                this.r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.r = null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    @Override
    public Storage create(String name) throws IOException {
        throw new IOException("read only");
    }

    @Override
    public Storage createDir(String name) throws IOException {
        throw new IOException("read only");
    }
}

