/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.resource;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class BundleHelper {
    private ResourceBundle resources;
    public static final String RESOURCE_NOT_FOUND = "<MISSING RESOURCE>";

    public BundleHelper(String bundleName) throws MissingResourceException {
        this(ResourceBundle.getBundle(bundleName));
    }

    public BundleHelper(String bundleName, Locale locale) throws MissingResourceException {
        this(ResourceBundle.getBundle(bundleName, locale));
    }

    public BundleHelper(ResourceBundle bundle) {
        this.resources = bundle;
    }

    public Enumeration getKeys() {
        return this.resources.getKeys();
    }

    public String getString(String key) {
        String str;
        try {
            str = this.resources.getString(key);
        }
        catch (MissingResourceException e) {
            str = RESOURCE_NOT_FOUND;
        }
        return str;
    }
}

