/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.properties;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.properties.PropertiesTokens;

public class PropertiesLexer
extends AbstractLexer
implements PropertiesTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipComments = false;

    public PropertiesLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    @Override
    public int lex(LexerToken lexedToken) {
        block7: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                block8: {
                    while (true) {
                        char c = this.textBuffer.getChar(this.currentPos++);
                        this.startOffset = this.currentPos - 1;
                        if (c == '\n') continue;
                        if (c == '#' || c == '!') {
                            this.lastToken = 12;
                            this.skipComment();
                            if (this.skipComments) {
                                this.lastToken = 0;
                                continue;
                            }
                            break block7;
                        }
                        if (!Character.isWhitespace(c)) break block8;
                        boolean hitEOL = this.skipWhitespaceUntilEOL();
                        if (!hitEOL) break;
                    }
                    this.startOffset = this.currentPos;
                }
                this.lastToken = 11;
                this.skipDefinition();
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                }
                if (!this.skipComments || this.lastToken != 12) break block7;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    @Override
    public void backup() {
        this.useLastToken = true;
    }

    @Override
    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    private void skipComment() {
        while (true) {
            char c;
            if ((c = this.textBuffer.getChar(this.currentPos++)) != '\n') {
                continue;
            }
            c = this.textBuffer.getChar(this.currentPos);
            if (c != '#' && c != '!') break;
            ++this.currentPos;
        }
    }

    private void skipDefinition() {
        block4: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                    continue block4;
                }
            }
        }
    }

    private boolean skipWhitespaceUntilEOL() {
        char c;
        do {
            if ((c = this.textBuffer.getChar(this.currentPos++)) != '\n') continue;
            return true;
        } while (Character.isWhitespace(c));
        --this.currentPos;
        return false;
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 11: {
                return "TK_DEFINITION";
            }
            case 12: {
                return "TK_COMMENT";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 11: {
                return "Property Definition";
            }
            case 12: {
                return "Comment";
            }
        }
        return "**UNKNOWN**";
    }
}

