/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.syntax;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.SqlKeywords;
import oracle.javatools.parser.plsql.syntax.BaseSqlLexer;
import oracle.javatools.parser.util.KeywordTable;

public class SqlPlsqlLexer
extends BaseSqlLexer {
    public static final int KW_base = 1024;
    private static KeywordTable keywordTable;

    public SqlPlsqlLexer() {
        super(keywordTable);
    }

    static {
        String word;
        int i;
        int sqlKeywordCount = SqlKeywords.KW_words.length;
        int sqlDupwordCount = SqlKeywords.DW_words.length;
        int plSqlKeywordCount = PlsqlTokens.KW_words.length;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(sqlKeywordCount + sqlDupwordCount + plSqlKeywordCount);
        for (i = 0; i < SqlKeywords.KW_words.length; ++i) {
            word = SqlKeywords.KW_words[i];
            hashMap.put(word, new Integer(i));
        }
        for (i = 0; i < SqlKeywords.DW_words.length; ++i) {
            word = SqlKeywords.DW_words[i];
            hashMap.put(word, new Integer(i + sqlKeywordCount));
        }
        for (i = 0; i < PlsqlTokens.KW_words.length; ++i) {
            word = PlsqlTokens.KW_words[i];
            hashMap.put(word, new Integer(i + sqlKeywordCount + sqlDupwordCount));
        }
        Set entries = hashMap.entrySet();
        int numKeywords = entries.size();
        keywordTable = new KeywordTable(numKeywords);
        keywordTable.setCaseSensitivity(false);
        for (Map.Entry entry : entries) {
            String word2 = (String)entry.getKey();
            int token = (Integer)entry.getValue();
            keywordTable.addKeyword(word2, token + 1024);
        }
    }
}

