/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.javatools.parser.util.SimpleStack;

public class ExpressionWrapper
extends ExpressionSymbol
implements ErrorReporter {
    ExpressionStack estack = new ExpressionStack();
    private ErrorSymbol[] errorArray = null;

    ExpressionWrapper(int code, PlsqlSymbolFactory factory) {
        super(code, factory);
    }

    void refurbish(int code) {
        if (ExpressionWrapper.verboseOutput(16)) {
            System.out.println("Refurbishing...");
        }
        this.code = code;
        this.firstOperand = null;
        this.secondOperand = null;
        this.thirdOperand = null;
        this.setName(null);
        this.estack.refurbish();
    }

    @Override
    void addOperand(ExpressionSymbol e) {
        this.estack.add(e);
    }

    @Override
    void doneParsing() {
        this.estack.process();
        this.firstOperand = this.estack.generate();
        if (this.parent instanceof ExpressionSymbol) {
            ((ExpressionSymbol)this.parent).addOperand(this);
        } else if (this.parent instanceof Statement) {
            ((Statement)this.parent).setExpression(this.firstOperand);
            this.recycleExpression(this);
        } else if (this.parent.code == 10) {
            ((CommonRoot)this.parent).setRoot(this);
        }
    }

    @Override
    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    @Override
    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    @Override
    public void setErrors(CommonRoot root) {
        this.errorArray = root.getErrors();
    }

    static void verbosePrintln(String msg, ExpressionSymbol e) {
        if (ExpressionWrapper.verboseOutput(2)) {
            System.out.print(msg);
            System.out.println(e.verbose());
        }
    }

    static /* synthetic */ ArrayList access$500() {
        return ExpressionWrapper.allocArrayList();
    }

    private static class ExpressionStack {
        private ArrayList expressions = ExpressionWrapper.access$500();
        private SimpleStack stack = new SimpleStack();
        private int pos;

        private ExpressionStack() {
        }

        private void refurbish() {
            if (this.expressions != null) {
                throw new RuntimeException("Non-null array list!");
            }
            this.expressions = ExpressionWrapper.allocArrayList();
            this.stack.clear();
        }

        private void add(ExpressionSymbol e) {
            this.expressions.add(e);
        }

        private void process() {
            if (this.expressions.size() == 1) {
                this.stack.push(this.expressions.get(0));
            } else {
                this.pos = 0;
                while (this.pos < this.expressions.size()) {
                    this.processOperand(1000);
                }
            }
            ExpressionWrapper.freeArrayList(this.expressions);
            this.expressions = null;
        }

        private ExpressionSymbol generate() {
            return (ExpressionSymbol)this.stack.pop();
        }

        private ExpressionSymbol current() {
            return (ExpressionSymbol)this.expressions.get(this.pos);
        }

        private void advance() {
            ++this.pos;
        }

        private boolean eof() {
            return this.expressions.size() <= this.pos;
        }

        private boolean isSuffixOperator(ExpressionSymbol e) {
            int category = e.getCategory();
            switch (category) {
                default: {
                    break;
                }
                case 714: {
                    return true;
                }
                case 713: {
                    switch (e.getExactCode()) {
                        case -1074: 
                        case -1011: 
                        case 1011: 
                        case 1074: {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private void pushOperand(ExpressionSymbol e) {
            ExpressionWrapper.verbosePrintln("Pushing operand: ", e);
            this.stack.push(e);
        }

        private ExpressionSymbol popOperand() {
            ExpressionSymbol e = (ExpressionSymbol)this.stack.pop();
            ExpressionWrapper.verbosePrintln("Popping operand: ", e);
            return e;
        }

        private void processOperator(ExpressionSymbol e) {
            if (this.isSuffixOperator(e)) {
                this.advance();
                ExpressionWrapper.verbosePrintln("Processing suffix operator: ", e);
                e.addOperand(this.popOperand());
                e.adjustOffsets();
                this.pushOperand(e);
            } else {
                this.advance();
                this.processOperand(ExpressionStack.getPrecedence(e));
                if (e.getCategory() == 711) {
                    ExpressionWrapper.verbosePrintln("Processing prefix operator: ", e);
                    e.addOperand(this.popOperand());
                } else {
                    ExpressionWrapper.verbosePrintln("Processing infix operator: ", e);
                    ExpressionSymbol secondOp = this.popOperand();
                    e.addOperand(this.popOperand());
                    e.addOperand(secondOp);
                }
                e.adjustOffsets();
                this.pushOperand(e);
            }
        }

        private void processOperand(int precedence) {
            ExpressionSymbol e = this.current();
            switch (e.getCategory()) {
                case 711: 
                case 712: 
                case 713: {
                    this.processOperator(e);
                    break;
                }
                case 610: 
                case 750: 
                case 760: {
                    ExpressionSymbol n;
                    this.pushOperand(e);
                    this.advance();
                    while (!this.eof() && (n = this.current()).getCategory() != 750 && ExpressionStack.getPrecedence(n) < precedence) {
                        this.processOperator(n);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("processOperand: bad category" + e.getCategory());
                }
            }
        }

        public static int getPrecedence(ExpressionSymbol e) {
            boolean prefix = e.getCategory() == 711;
            int operator = e.getExactCode();
            if (operator < 0) {
                operator = -operator;
            }
            switch (operator) {
                case 115: {
                    return 1;
                }
                case 125: 
                case 1096: {
                    return 2;
                }
                case 100: 
                case 111: {
                    return prefix ? 3 : 5;
                }
                case 103: 
                case 108: {
                    return 4;
                }
                case 114: {
                    return 5;
                }
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 1011: 
                case 1065: 
                case 1074: 
                case 1078: {
                    return 6;
                }
                case 1002: {
                    return 7;
                }
                case 1108: {
                    return 8;
                }
                case 112: 
                case 113: {
                    return 10;
                }
            }
            throw new RuntimeException("getPrecedence: Unknown operator " + operator + " category " + e.getCategory());
        }
    }
}

