/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

public class AnnotationFilter
implements JavaFilter,
JavaConstants {
    private final SourceHasModifiers decl;
    private final byte declKind;
    private final HashSet hits = new HashSet(10);
    private final HashSet misses = new HashSet();

    @Override
    public final boolean accepts(JavaElement element) {
        if (!(element instanceof JavaType)) {
            return false;
        }
        JavaType subject = (JavaType)element;
        if (subject == null) {
            return false;
        }
        if (!subject.isAnnotation()) {
            return false;
        }
        if (this.declKind == 0) {
            return true;
        }
        if (this.hits.contains(subject)) {
            return true;
        }
        if (this.misses.contains(subject)) {
            return false;
        }
        boolean accepted = this.acceptsImpl(subject);
        if (accepted) {
            this.hits.add(subject);
        } else {
            this.misses.add(subject);
        }
        return accepted;
    }

    private boolean acceptsImpl(JavaType subject) {
        Collection annotations = subject.getDeclaredAnnotations();
        if (!annotations.isEmpty()) {
            for (JavaAnnotation a : annotations) {
                Object o;
                JavaType aType = a.getAnnotationType();
                if (aType == null || !"java/lang/annotation/Target".equals(aType.getVMName()) || (o = a.getComponents().get("value")) == null) continue;
                try {
                    String targetName;
                    switch (this.declKind) {
                        case 9: 
                        case 10: {
                            targetName = "FIELD";
                            break;
                        }
                        case 6: {
                            targetName = "CONSTRUCTOR";
                            break;
                        }
                        case 19: {
                            targetName = "METHOD";
                            break;
                        }
                        case 17: 
                        case 18: {
                            targetName = "LOCAL_VARIABLE";
                            break;
                        }
                        case 12: 
                        case 13: {
                            targetName = "PARAMETER";
                            break;
                        }
                        case 21: {
                            targetName = "PACKAGE";
                            break;
                        }
                        default: {
                            targetName = null;
                        }
                    }
                    Object[] array = (Object[])o;
                    int count = array.length;
                    for (int i = 0; i < count; ++i) {
                        SourceClass c;
                        JavaField field = (JavaField)array[i];
                        String fieldName = field.getName();
                        if (targetName != null) {
                            if (!targetName.equals(fieldName)) continue;
                            return true;
                        }
                        if (this.declKind != 3) continue;
                        if ("TYPE".equals(fieldName)) {
                            return true;
                        }
                        if (!"ANNOTATION_TYPE".equals(fieldName) || this.decl == null || !(c = (SourceClass)this.decl).isAnnotation()) continue;
                        return true;
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public AnnotationFilter() {
        this.decl = null;
        this.declKind = 0;
    }

    public AnnotationFilter(SourceHasModifiers decl) {
        this.decl = decl;
        this.declKind = (byte)decl.getSymbolKind();
    }

    public AnnotationFilter(int declKind) {
        this.decl = null;
        this.declKind = (byte)declKind;
    }
}

