/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.util.ArrayListHeap;

public class Conversions
extends ArrayListHeap
implements JavaConstants {
    public static boolean applyWideningConversion(PrimitiveType subject, PrimitiveType target) {
        return PrimitiveType.applyWideningConversion(subject, target);
    }

    public static boolean applyNarrowingConversion(PrimitiveType subject, PrimitiveType target) {
        return PrimitiveType.applyNarrowingConversion(subject, target);
    }

    public static JavaType applyBoxingConversion(PrimitiveType input, JavaProvider provider) {
        if (input == null) {
            return null;
        }
        byte primCode = input.primCode;
        String autobox = PRIMITIVE_autoboxes[primCode];
        if (autobox != null && provider != null) {
            return provider.getClassByVMName(autobox);
        }
        return null;
    }

    public static PrimitiveType applyUnboxingConversion(JavaType input) {
        if (input == null) {
            return null;
        }
        if (input.isPrimitive()) {
            return (PrimitiveType)input;
        }
        return PrimitiveType.applyUnboxingConversion(input);
    }

    public static boolean applyAssignmentConversion(JavaType subject, JavaType target, boolean isConstantValue, JavaProvider provider) {
        JavaElement owner;
        if (subject == null || target == null) {
            return true;
        }
        if (Conversions.applyMethodConversion(subject, target, true, provider)) {
            return true;
        }
        if (isConstantValue && subject.isPrimitive()) {
            PrimitiveType primitiveSubject = (PrimitiveType)subject;
            if (target.isPrimitive()) {
                return Conversions.applyNarrowingConversion(primitiveSubject, (PrimitiveType)target);
            }
            PrimitiveType primitiveTarget = Conversions.applyUnboxingConversion(target);
            if (primitiveTarget != null) {
                return Conversions.applyNarrowingConversion(primitiveSubject, primitiveTarget);
            }
        }
        return subject.getElementKind() != 3 && (owner = subject.getOwner()) != null && owner.getElementKind() == 8 && Conversions.getUpperBounds(subject).isEmpty() && Conversions.getLowerBounds(subject).isEmpty();
    }

    public static boolean applyMethodConversion(JavaType subject, JavaType target, boolean allowBoxing, JavaProvider provider) {
        if (subject == null || target == null) {
            return false;
        }
        if (Conversions.isSubtypeOf(subject, target)) {
            return true;
        }
        if (subject.isPrimitive()) {
            if (!allowBoxing) {
                return false;
            }
            JavaType boxed = Conversions.applyBoxingConversion((PrimitiveType)subject, provider);
            if (boxed != null) {
                return Conversions.applyMethodConversion(boxed, target, false, provider);
            }
            return false;
        }
        if (target.isPrimitive()) {
            if (!allowBoxing) {
                return false;
            }
            PrimitiveType unboxed = Conversions.applyUnboxingConversion(subject);
            if (unboxed != null) {
                return Conversions.applyMethodConversion(unboxed, target, false, provider);
            }
            JavaType boxedTarget = Conversions.applyBoxingConversion((PrimitiveType)target, provider);
            if (boxedTarget != null) {
                return Conversions.applyMethodConversion(subject, boxedTarget, false, provider);
            }
            return false;
        }
        if (subject.isArray() || target.isArray()) {
            return false;
        }
        return false;
    }

    public static boolean applyCastingConversion(JavaType subject, JavaType target, JavaProvider provider) {
        if (subject == null || target == null) {
            return true;
        }
        boolean assignable = Conversions.applyAssignmentConversion(subject, target, true, provider);
        if (assignable) {
            return true;
        }
        if (subject.isPrimitive() && target.isPrimitive()) {
            PrimitiveType subjectPrimitive = (PrimitiveType)subject;
            PrimitiveType targetPrimitive = (PrimitiveType)target;
            return subjectPrimitive.primCode == 1 && targetPrimitive.primCode == 2;
        }
        while (subject.isArray() && target.isArray()) {
            subject = subject.getComponentType();
            target = target.getComponentType();
        }
        if (subject.isInterface()) {
            if (!target.isFinal()) {
                return true;
            }
            return Conversions.isSubtypeOf(target, subject);
        }
        if (target.isInterface() && !subject.isFinal()) {
            return true;
        }
        return Conversions.isSubtypeOf(target, subject);
    }

    public static boolean inheritsFrom(JavaType subject, JavaType target) {
        if (subject == null || target == null) {
            return false;
        }
        String targetDescriptor = target.getDescriptor();
        if ("Ljava/lang/Object;".equals(target.getTypeSignature())) {
            return true;
        }
        if (targetDescriptor.equals(subject.getDescriptor())) {
            return Conversions.isSameClassAssignable(subject, target);
        }
        for (JavaType subjectBaseType : subject.getHierarchy()) {
            if (!targetDescriptor.equals(subjectBaseType.getDescriptor())) continue;
            return Conversions.isSameClassAssignable(subjectBaseType, target);
        }
        return false;
    }

    private static boolean isSameClassAssignable(JavaType subject, JavaType target) {
        if (!subject.hasActualTypeArguments() || !target.hasActualTypeArguments()) {
            return true;
        }
        Collection subjectTypeArgs = subject.getActualTypeArguments();
        Collection targetTypeArgs = target.getActualTypeArguments();
        if (subjectTypeArgs.size() != targetTypeArgs.size()) {
            return false;
        }
        Iterator subjectTypeArgIter = subjectTypeArgs.iterator();
        Iterator targetTypeArgIter = targetTypeArgs.iterator();
        while (subjectTypeArgIter.hasNext()) {
            JavaType subjectTypeArg = (JavaType)subjectTypeArgIter.next();
            JavaType targetTypeArg = (JavaType)targetTypeArgIter.next();
            if (subjectTypeArg == null || targetTypeArg == null || targetTypeArg.getElementKind() != 3) continue;
            if (subjectTypeArg.getElementKind() == 3) {
                if (!subjectTypeArg.getDescriptor().equals(targetTypeArg.getDescriptor())) {
                    return false;
                }
                if (Conversions.isSameClassAssignable(subjectTypeArg, targetTypeArg)) continue;
                return false;
            }
            if (subjectTypeArg.getElementKind() != 11) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubtypeOf(JavaType subject, JavaType target) {
        if (subject == null || target == null) {
            return false;
        }
        if (((Object)subject).equals(target)) {
            return true;
        }
        if (subject.isPrimitive()) {
            PrimitiveType primitiveSubject = (PrimitiveType)subject;
            if (target.isPrimitive()) {
                return PrimitiveType.applyWideningConversion(primitiveSubject, (PrimitiveType)target);
            }
            return primitiveSubject.primCode == 8;
        }
        if (target.isPrimitive()) {
            return false;
        }
        if (subject.isArray() && target.isArray()) {
            JavaType subjectComponent = subject.getComponentType();
            if (subjectComponent == null) {
                return false;
            }
            if (!subjectComponent.isPrimitive()) {
                return Conversions.isSubtypeOf(subjectComponent, target.getComponentType());
            }
            PrimitiveType p = (PrimitiveType)subjectComponent;
            return p.primCode == 8;
        }
        return Conversions.isSubtypeOfImpl(subject, target);
    }

    public static boolean isSubtypeOfImpl(JavaType subject, JavaType target) {
        if (subject == null || target == null) {
            return false;
        }
        if (((Object)subject).equals(target)) {
            return true;
        }
        if ("*".equals(target.getTypeSignature()) || "Ljava/lang/Object;".equals(target.getTypeSignature())) {
            return true;
        }
        int subjectKind = subject.getElementKind();
        int targetKind = target.getElementKind();
        if (targetKind == 3) {
            if (subjectKind == 3) {
                return Conversions.inheritsFrom(subject, target);
            }
            Collection subjectUpperBounds = Conversions.getUpperBounds(subject);
            for (JavaType bound : subjectUpperBounds) {
                if (((Object)bound).equals(subject)) {
                    return false;
                }
                if (!Conversions.isSubtypeOfImpl(bound, target)) continue;
                return true;
            }
            return false;
        }
        Collection targetUpperBounds = Conversions.getUpperBounds(target);
        if (!Conversions.satisfiesBounds(subject, target, targetUpperBounds, true)) {
            return false;
        }
        Collection targetLowerBounds = Conversions.getLowerBounds(target);
        return Conversions.satisfiesBounds(subject, target, targetLowerBounds, false);
    }

    private static Collection getUpperBounds(JavaType type) {
        if (type.getElementKind() == 10) {
            JavaTypeVariable variable = (JavaTypeVariable)type;
            return variable.getBounds();
        }
        JavaWildcardType wildcard = (JavaWildcardType)type;
        return wildcard.getUpperBounds();
    }

    private static Collection getLowerBounds(JavaType type) {
        if (type.getElementKind() == 10) {
            return kEmptyCollection;
        }
        JavaWildcardType wildcard = (JavaWildcardType)type;
        return wildcard.getLowerBounds();
    }

    private static boolean satisfiesBounds(JavaType subject, JavaType target, Collection bounds, boolean upper) {
        if (bounds == kEmptyCollection) {
            return true;
        }
        if (bounds.isEmpty()) {
            return true;
        }
        for (JavaType bound : bounds) {
            if (((Object)bound).equals(target)) {
                return false;
            }
            if (!(upper ? !Conversions.satisfiesUpperBound(subject, bound) : !Conversions.satisfiesLowerBound(subject, bound))) continue;
            return false;
        }
        return true;
    }

    private static boolean satisfiesUpperBound(JavaType subject, JavaType bound) {
        if (subject.getElementKind() == 3) {
            return Conversions.isSubtypeOfImpl(subject, bound);
        }
        Collection subjectBounds = Conversions.getUpperBounds(subject);
        if (subjectBounds.isEmpty()) {
            return true;
        }
        for (JavaType subjectBound : subjectBounds) {
            if (!Conversions.isSubtypeOf(subjectBound, bound)) continue;
            return true;
        }
        return false;
    }

    private static boolean satisfiesLowerBound(JavaType subject, JavaType bound) {
        int subjectKind = subject.getElementKind();
        if (subjectKind == 3) {
            return Conversions.isSubtypeOfImpl(bound, subject);
        }
        Collection subjectBounds = Conversions.getLowerBounds(subject);
        if (subjectBounds.isEmpty()) {
            return true;
        }
        for (JavaType subjectBound : subjectBounds) {
            if (!Conversions.isSubtypeOf(bound, subjectBound)) continue;
            return true;
        }
        return false;
    }

    protected static JavaType applyUnaryPromotion(JavaType subject) {
        if (subject == null) {
            return null;
        }
        if (!subject.isPrimitive()) {
            subject = Conversions.applyUnboxingConversion(subject);
        }
        if (subject == null) {
            return null;
        }
        PrimitiveType primitive = (PrimitiveType)subject;
        byte target = PRIMITIVE_unary[primitive.primCode];
        return PrimitiveType.PRIMITIVE_objects[target];
    }

    protected static JavaType applyBinaryPromotion(JavaType lhs, JavaType rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (!lhs.isPrimitive()) {
            lhs = Conversions.applyUnboxingConversion(lhs);
        }
        if (lhs == null) {
            return null;
        }
        if (!rhs.isPrimitive()) {
            rhs = Conversions.applyUnboxingConversion(rhs);
        }
        if (rhs == null) {
            return null;
        }
        PrimitiveType lhsPrimitive = (PrimitiveType)lhs;
        PrimitiveType rhsPrimitive = (PrimitiveType)rhs;
        byte prim = PRIMITIVE_binary[lhsPrimitive.primCode][rhsPrimitive.primCode];
        if (prim != -1) {
            return PrimitiveType.PRIMITIVE_objects[prim];
        }
        return null;
    }

    public static boolean hasSubsignatureOf(JavaMethod subject, JavaMethod target) {
        if (subject == null || target == null) {
            return false;
        }
        if (!target.getName().equals(subject.getName())) {
            return false;
        }
        Collection subjectParams = subject.getParameters();
        Collection targetParams = target.getParameters();
        if (subjectParams.size() != targetParams.size()) {
            return false;
        }
        Iterator subjectIterator = subjectParams.iterator();
        Iterator targetIterator = targetParams.iterator();
        while (subjectIterator.hasNext()) {
            JavaType targetVarType;
            JavaVariable subjectVar = (JavaVariable)subjectIterator.next();
            JavaVariable targetVar = (JavaVariable)targetIterator.next();
            JavaType subjectVarType = subjectVar.getResolvedType();
            if (Conversions.typesOverrideEqual(subjectVarType, targetVarType = targetVar.getResolvedType())) continue;
            return false;
        }
        return true;
    }

    private static boolean typesOverrideEqual(JavaType subjectVarType, JavaType targetVarType) {
        JavaClass targetErasedType;
        if (subjectVarType == null && targetVarType == null) {
            return true;
        }
        if (subjectVarType == null || targetVarType == null) {
            return false;
        }
        if (subjectVarType.isArray() || targetVarType.isArray()) {
            if (!subjectVarType.isArray() || !targetVarType.isArray()) {
                return false;
            }
            if (subjectVarType.getArrayDimensions() != targetVarType.getArrayDimensions()) {
                return false;
            }
            return Conversions.typesOverrideEqual(subjectVarType.getBaseComponentType(), targetVarType.getBaseComponentType());
        }
        while (subjectVarType.getElementKind() == 10 && targetVarType.getElementKind() == 10) {
            subjectVarType = subjectVarType.getTypeErasure();
            targetVarType = targetVarType.getTypeErasure();
            if (subjectVarType == null && targetVarType == null) {
                return true;
            }
            if (subjectVarType != null && targetVarType != null) continue;
            return false;
        }
        if (subjectVarType.getElementKind() == 3 && targetVarType.getElementKind() == 3) {
            if (!targetVarType.hasActualTypeArguments() && !subjectVarType.hasActualTypeArguments()) {
                return targetVarType.getName().equals(subjectVarType.getName());
            }
            if (targetVarType.hasActualTypeArguments() && subjectVarType.hasActualTypeArguments()) {
                if (!targetVarType.getName().equals(subjectVarType.getName())) {
                    return false;
                }
                Collection targetTypeParams = targetVarType.getTypeParameters();
                Collection subjectTypeParams = subjectVarType.getTypeParameters();
                if (targetTypeParams.size() != subjectTypeParams.size()) {
                    return false;
                }
                Iterator targetTypeParamIter = targetTypeParams.iterator();
                Iterator subjectTypeParamIter = subjectTypeParams.iterator();
                while (subjectTypeParamIter.hasNext()) {
                    JavaType targetTypeParam = (JavaType)targetTypeParamIter.next();
                    JavaType subjectTypeParam = (JavaType)subjectTypeParamIter.next();
                    if (Conversions.typesOverrideEqual(subjectTypeParam, targetTypeParam)) continue;
                    return false;
                }
                return true;
            }
        }
        if ((targetErasedType = targetVarType.getTypeErasure()) == null) {
            return false;
        }
        if (targetVarType != targetErasedType) {
            return Conversions.typesOverrideEqual(subjectVarType, targetErasedType);
        }
        return false;
    }
}

