/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import java.util.Arrays;
import oracle.javatools.parser.java.v2.scanner.FastLexer;

public final class TokenArray {
    public final int tokenCount;
    public final short[] tokenValues;
    public final int[] tokenStarts;
    public final int[] tokenEnds;

    public TokenArray(FastLexer lexer) {
        short token;
        int count = 0;
        short[] values = new short[1];
        int[] starts = new int[1];
        int[] ends = new int[1];
        do {
            token = (short)lexer.lex();
            int startOffset = lexer.getStartOffset();
            int endOffset = lexer.getEndOffset();
            if (count == values.length) {
                int newCount = count << 3;
                short[] newValues = new short[newCount];
                int[] newStarts = new int[newCount];
                int[] newEnds = new int[newCount];
                System.arraycopy(values, 0, newValues, 0, count);
                System.arraycopy(starts, 0, newStarts, 0, count);
                System.arraycopy(ends, 0, newEnds, 0, count);
                values = newValues;
                starts = newStarts;
                ends = newEnds;
            }
            values[count] = token;
            starts[count] = startOffset;
            ends[count] = endOffset;
            ++count;
        } while (token != 0);
        if (count == 0) {
            throw new RuntimeException("No tokens");
        }
        int allocated = values.length;
        if (allocated != count) {
            short[] newValues = new short[count];
            int[] newStarts = new int[count];
            int[] newEnds = new int[count];
            System.arraycopy(values, 0, newValues, 0, count);
            System.arraycopy(starts, 0, newStarts, 0, count);
            System.arraycopy(ends, 0, newEnds, 0, count);
            values = newValues;
            starts = newStarts;
            ends = newEnds;
        }
        this.tokenCount = count;
        this.tokenValues = values;
        this.tokenStarts = starts;
        this.tokenEnds = ends;
        if (this.tokenValues.length != count) {
            throw new IllegalStateException();
        }
        if (this.tokenStarts.length != count) {
            throw new IllegalStateException();
        }
        if (this.tokenEnds.length != count) {
            throw new IllegalStateException();
        }
        if (this.tokenValues[this.tokenCount - 1] != 0) {
            throw new RuntimeException("Not terminated by an EOF");
        }
    }

    public void adjust(int offset) {
        int count = this.tokenCount;
        int i = 0;
        while (i < count) {
            int n = i;
            this.tokenStarts[n] = this.tokenStarts[n] + offset;
            int n2 = i++;
            this.tokenEnds[n2] = this.tokenEnds[n2] + offset;
        }
    }

    public int search(int query) {
        int found = Arrays.binarySearch(this.tokenStarts, query);
        if (found >= 0) {
            return found;
        }
        int insertion = -found;
        if (insertion == this.tokenCount) {
            return this.tokenCount - 1;
        }
        if (insertion == -1) {
            return 0;
        }
        int index = insertion - 1;
        int endOffset = this.tokenEnds[index];
        if (endOffset < query) {
            return index + 1;
        }
        return -index;
    }

    public int offset2index(int query, boolean biasAfter) {
        int found = Arrays.binarySearch(this.tokenStarts, query);
        if (found >= 0) {
            if (biasAfter) {
                return found;
            }
            if (found == 0) {
                return found;
            }
            int previousEnd = this.tokenEnds[found - 1];
            if (previousEnd == query) {
                return found - 1;
            }
            return found;
        }
        int ip = -found - 1;
        if (ip == 0) {
            return -1;
        }
        if (query <= this.tokenEnds[ip - 1]) {
            return ip - 1;
        }
        return -(ip + 1);
    }
}

