/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.ArrayList;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;

public class DocCommentHelper
implements InternalConstants {
    private final FileSym fileSym;
    private ArrayList<CommentSym> possibleDocComments = new ArrayList();

    public DocCommentHelper(FileSym fileSym) {
        this.fileSym = fileSym;
    }

    public void process() {
        FindPossibleDocComments st = new FindPossibleDocComments();
        this.fileSym.traverseSelf(st);
        if (this.possibleDocComments.isEmpty()) {
            return;
        }
        SymFactory factory = this.fileSym.getSymFactory();
        int count = this.possibleDocComments.size();
        for (int i = count - 1; i >= 0; --i) {
            SourceMember member;
            Sym siblingAfter;
            CommentSym commentSym = this.possibleDocComments.get(i);
            for (siblingAfter = commentSym.getSiblingSymAfter(); siblingAfter != null && siblingAfter.symKind == 70; siblingAfter = siblingAfter.getSiblingSymAfter()) {
            }
            if (siblingAfter == null || !(siblingAfter instanceof SourceMember) || (member = (SourceMember)((Object)siblingAfter)).getDocComment() != null) continue;
            String text = commentSym.getText();
            SourceDocComment docCommentSym = factory.createDocCommentFromText(text);
            member.setDocComment(docCommentSym);
            commentSym.removeSelf();
        }
        this.possibleDocComments.clear();
    }

    private class FindPossibleDocComments
    extends Sym.SymTraversal {
        private FindPossibleDocComments() {
        }

        @Override
        protected boolean enter(Sym sym) {
            if (sym.symKind == 69) {
                CommentSym commentSym = (CommentSym)sym;
                if (commentSym.tokenValue == 26) {
                    DocCommentHelper.this.possibleDocComments.add(commentSym);
                }
            }
            return true;
        }
    }
}

