/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class SimpleNameExpr
extends Expr
implements SourceSimpleNameExpression {
    @Override
    public Object getConstantValue() {
        JavaHasType result = this.getResolvedObject();
        if (result == null || result.getElementKind() != 5) {
            return null;
        }
        JavaField thing = (JavaField)result;
        return thing.getConstantValue();
    }

    @Override
    public JavaHasType getResolvedLhs() {
        return null;
    }

    @Override
    public Sym getScope() {
        Sym sym;
        for (sym = this.getParentSym(); sym != null && sym.symKind == 49; sym = sym.getParentSym()) {
        }
        if (sym != null && sym.symKind == 23) {
            SwitchLabelSym switchLabel = (SwitchLabelSym)sym;
            return switchLabel.getOwningSwitchSym();
        }
        return super.getScope();
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected boolean isValidChild(Sym child, byte filter) {
        switch (child.symKind) {
            case 20: {
                return true;
            }
        }
        return super.isValidChild(child, filter);
    }

    private String qualifySelfImpl() {
        JavaType resolvedType;
        JavaHasType resolvedObject = this.getResolvedObject();
        if (resolvedObject instanceof JavaType && (resolvedType = (JavaType)resolvedObject) != null && !resolvedType.isPrimitive() && resolvedType instanceof JavaClass && resolvedType.isExported()) {
            JavaClass javaClass = (JavaClass)resolvedType;
            return javaClass.getQualifiedName();
        }
        return null;
    }

    @Override
    public final void qualifySelf() {
        String qualifiedName = this.qualifySelfImpl();
        if (qualifiedName == null) {
            return;
        }
        SourceFactory factory = this.symFile.getFactory();
        Sym sym = (Sym)((Object)factory.createExpressionFromText(qualifiedName));
        sym.symFormat = (char)(sym.symFormat | 0x20);
        this.replaceSelf(sym);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        String qualifiedName;
        SourcePreferences preferences = this.symFile.getPreferences();
        if (preferences.getBoolean(67) && (qualifiedName = this.qualifySelfImpl()) != null) {
            SourceFactory factory = targetFile.getFactory();
            return (Sym)((Object)factory.createExpressionFromText(qualifiedName));
        }
        return super.cloneSelf(targetFile);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

