/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

public class DocReferenceSym
extends DocSym
implements SourceDocReference {
    protected static final JavaHasType kEmptyResult = CompilerDriver.kEmptyResult;
    public static final DocReferenceSym[] EMPTY_ARRAY = new DocReferenceSym[0];
    public String refClassName;
    public String refMemberName;
    public List refMethodParameters;
    public String refParameterName;
    public JavaHasType refObject;

    @Override
    public SourceDocTag getOwningTag() {
        return (SourceDocTag)((Object)this.getParentSym());
    }

    @Override
    public String getNormalizedText() {
        if (this.refParameterName != null) {
            return this.refParameterName;
        }
        if (this.refMemberName == null || this.refMemberName.length() == 0) {
            return this.refClassName;
        }
        StringBuilder buffer = new StringBuilder();
        if (this.refClassName != null) {
            buffer.append(this.refClassName);
        }
        buffer.append("#");
        buffer.append(this.refMemberName);
        if (this.refMethodParameters != null) {
            buffer.append('(');
            for (int i = 0; i < this.refMethodParameters.size(); ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append((String)this.refMethodParameters.get(i));
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public String getClassName() {
        return this.refClassName;
    }

    @Override
    public String getMemberName() {
        return this.refMemberName;
    }

    @Override
    public Collection getMethodParameterTypeNames() {
        if (this.refMethodParameters == null) {
            return kEmptyList;
        }
        return Collections.unmodifiableList(this.refMethodParameters);
    }

    @Override
    public String getParameterName() {
        return this.refParameterName;
    }

    @Override
    public JavaHasType getResolvedObject() {
        return (JavaHasType)this.getCompiledObject();
    }

    @Override
    public SourceFormalParameter getResolvedParameter() {
        if (this.refParameterName == null) {
            return null;
        }
        JavaElement object = this.getCompiledObject();
        if (object instanceof SourceFormalParameter) {
            return (SourceFormalParameter)object;
        }
        return null;
    }

    @Override
    public JavaMember getResolvedMember() {
        if (this.refParameterName != null) {
            return null;
        }
        JavaElement object = this.getCompiledObject();
        if (object instanceof JavaMember) {
            return (JavaMember)object;
        }
        return null;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        DocReferenceSym sym = (DocReferenceSym)super.cloneSelf(targetFile);
        sym.refClassName = this.refClassName;
        sym.refMemberName = this.refMemberName;
        if (this.refMethodParameters != null) {
            sym.refMethodParameters = DocReferenceSym.mutableCopy(this.refMethodParameters);
        }
        sym.refParameterName = this.refParameterName;
        return sym;
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 68: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public JavaElement getCompiledObject() {
        if (this.refObject == null) {
            this.resolve();
        }
        if (this.refObject != kEmptyResult) {
            return this.refObject;
        }
        return null;
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.refObject = null;
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        if (this.refObject == null) {
            try {
                this.refObject = (JavaHasType)compiler.resolve(this);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        return this.refObject;
    }

    @Override
    void appendDocText(StringBuilder buffer) {
        int bufferLength = buffer.length();
        if (bufferLength > 0 && buffer.charAt(bufferLength - 1) != ' ') {
            buffer.append(' ');
        }
        super.appendDocText(buffer);
    }
}

