/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocInlineTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;

public class DocDescriptionSym
extends DocSym
implements SourceDocDescription {
    static final DocDescriptionSym[] EMPTY_ARRAY = new DocDescriptionSym[0];

    @Override
    public boolean isBlank() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            if (((SourceDocElement)i.next()).isBlank()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection findTags(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name null or empty");
        }
        ArrayList<DocInlineTagSym> list = new ArrayList<DocInlineTagSym>();
        for (DocInlineTagSym tag : this.getInlineTags()) {
            if (!name.equals(tag.getName())) continue;
            list.add(tag);
        }
        return list;
    }

    @Override
    public Collection findReferenceTags() {
        ArrayList<DocInlineTagSym> list = new ArrayList<DocInlineTagSym>();
        for (DocInlineTagSym tag : this.getInlineTags()) {
            if (!tag.isReference()) continue;
            list.add(tag);
        }
        return list;
    }

    @Override
    public Collection findReferenceTags(String referenceName) {
        if (referenceName == null || referenceName.length() == 0) {
            throw new IllegalArgumentException("referenceName null or empty");
        }
        ArrayList<DocInlineTagSym> list = new ArrayList<DocInlineTagSym>();
        for (DocInlineTagSym tag : this.getInlineTags()) {
            if (!tag.isReference(referenceName)) continue;
            list.add(tag);
        }
        return list;
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 65: 
            case 68: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    void appendDocText(StringBuilder buffer) {
        int bufferLength = buffer.length();
        if (bufferLength > 0 && buffer.charAt(bufferLength - 1) != ' ') {
            buffer.append(' ');
        }
        super.appendDocText(buffer);
    }
}

