/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;

public abstract class SymUtilities
extends InternalUtilities
implements InternalConstants {
    protected static void errorHasParent() {
        SymUtilities.unsupported("Already has parent. Try SourceElement.removeSelf().");
    }

    protected static void errorNoParent() {
        SymUtilities.unsupported("Does not have a parent. Cannot be removed.");
    }

    protected static void errorInvalidParent() {
        SymUtilities.panic("Child is not a member of the parent's child array.");
    }

    protected static void errorCannotLink(Sym child, TreeSym parent) {
        String childString = SymUtilities.symkind2string(child.symKind);
        String parentString = SymUtilities.symkind2string(parent.symKind);
        String message = "Illegal child " + childString + " (" + child.symKind + ") " + "on this parent " + parentString + " (" + parent.symKind + ").";
        throw new IllegalArgumentException(message);
    }

    protected static void errorCycle(Sym child) {
        SymUtilities.unsupported("Detected a cycle");
    }

    protected static void errorInvalidRange(int index) {
        throw new ArrayIndexOutOfBoundsException("" + index);
    }

    protected static void errorSynthetic() {
        SymUtilities.unsupported("Is synthetic. Cannot link or unlink.");
    }

    protected static void errorSkeleton() {
        SymUtilities.unsupported("Required. You can replace it but not remove it.");
    }

    protected static void errorOpenTransaction() {
        SymUtilities.unsupported("Transaction already in progress. Try abort().");
    }

    protected static void errorNoTransaction() {
        SymUtilities.unsupported("No open transaction. Try SourceFile.beginTransaction().");
    }

    protected static void errorNoTextBuffer() {
        SymUtilities.unsupported("No TextBuffer. Try SourceFile.setTextBuffer().");
    }

    protected static void errorNoTokenArray() {
        SymUtilities.panic("No token array.");
    }

    protected static void errorDifferentFile() {
        SymUtilities.unsupported("Belongs to a different FileSym. Try cloneSelf(S).");
    }

    private static String symkind2string(byte symkind) {
        try {
            return SRC_words[symkind - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "<unknown>";
        }
    }
}

