/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.MethodObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.util.Conversions;

public class MethodSym
extends MemberSym
implements SourceMethod {
    public short methodXDimension = 0;

    @Override
    public int getElementKind() {
        return 8;
    }

    @Override
    public boolean isConstructor() {
        return this.symKind == 6;
    }

    @Override
    public List getSourceParameters() {
        FormalsSym formals = this.getFormalsSym();
        if (formals != null) {
            return formals.getSourceParameters();
        }
        return kEmptyList;
    }

    @Override
    public List getSourceExceptions() {
        ThrowsClauseSym throwsSym = this.getThrowsSym();
        if (throwsSym != null) {
            return throwsSym.getSourceExceptions();
        }
        return kEmptyList;
    }

    @Override
    public SourceTypeReference getSourceReturnType() {
        return this.getTypeSym();
    }

    @Override
    public void setSourceReturnType(SourceTypeReference type) {
        if (this.isConstructor()) {
            MethodSym.unsupported("Constructor has no return type");
        }
        this.setTypeSym((TypeSym)type);
    }

    @Override
    public String getName() {
        if (this.isConstructor()) {
            return "<init>";
        }
        return super.getName();
    }

    @Override
    public SourceFormalParameterList getFormalParameterList() {
        return this.getFormalsSym();
    }

    @Override
    public SourceThrowsClause getThrowsClause() {
        return this.getThrowsSym();
    }

    public FormalsSym getFormalsSym() {
        return (FormalsSym)this.getChildOrCreateSkeleton((byte)12);
    }

    public ThrowsClauseSym getThrowsSym() {
        return (ThrowsClauseSym)this.getChildOrCreateSkeleton((byte)24);
    }

    public Expr getDefaultValueSym() {
        return (Expr)this.getChild((byte)83);
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public final JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public JavaMethod getMethodErasure() {
        return this;
    }

    @Override
    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    @Override
    public Collection getParameters() {
        JavaType grandClass;
        ClassSym owningClass;
        FormalsSym formalsSym = this.getFormalsSym();
        if (formalsSym == null) {
            return kEmptyList;
        }
        List parameters = formalsSym.getParameters();
        if (this.isConstructor() && (owningClass = this.getOwningClassSym()) != null && (grandClass = MethodSym.getOuterClassOfNonstaticInner(owningClass)) != null) {
            ArrayList<QuickLocalVariable> adjustedParameters = new ArrayList<QuickLocalVariable>();
            QuickLocalVariable thisDollarZero = QuickLocalVariable.createLocalVariable(grandClass, "this$0");
            thisDollarZero.setOwner(this);
            adjustedParameters.add(thisDollarZero);
            adjustedParameters.addAll(parameters);
            return adjustedParameters;
        }
        return parameters;
    }

    @Override
    public JavaType[] getParameterTypes() {
        return CommonUtilities.getParameterTypes(this);
    }

    @Override
    public Collection getExceptions() {
        ThrowsClauseSym throwsSym = this.getThrowsSym();
        if (throwsSym != null) {
            return throwsSym.getExceptions();
        }
        return kEmptyList;
    }

    @Override
    public boolean hasSubsignatureOf(JavaMethod other) {
        return Conversions.hasSubsignatureOf(this, other);
    }

    @Override
    public Collection getOverriddenMethods() {
        return this.getMethodObj().getOverriddenMethods();
    }

    @Override
    public Object getDefaultValue() {
        Expr e = this.getDefaultValueSym();
        if (e != null) {
            return e.getConstantValue();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JavaMethod) {
            return CommonUtilities.equals(this, (JavaMethod)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 27: {
                return !this.isConstructor();
            }
            case 2: 
            case 12: 
            case 20: 
            case 24: 
            case 26: {
                return true;
            }
        }
        if (target.is((byte)83)) {
            return true;
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected boolean isValidAccess(char access) {
        ClassSym classSym;
        int allowed = this.isConstructor() ? 135 : ((classSym = this.getOwningClassSym()) != null && classSym.isInterface() ? 1153 : 3583);
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
        if (!this.isConstructor()) {
            return;
        }
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null) {
            String className = classSym.getName();
            String thisName = this.getName();
            if (!thisName.equals(className)) {
                this.setName(className);
            }
        }
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 26: {
                int typeIndex = this.indexOf((byte)27);
                if (typeIndex != -1) {
                    return typeIndex;
                }
            }
            case 27: {
                int nameIndex = this.indexOf((byte)20);
                if (nameIndex != -1) {
                    return nameIndex;
                }
            }
            case 20: {
                int formalsIndex = this.indexOf((byte)12);
                if (formalsIndex != -1) {
                    return formalsIndex;
                }
            }
            case 12: {
                int throwsIndex = this.indexOf((byte)24);
                if (throwsIndex != -1) {
                    return throwsIndex;
                }
            }
            case 24: {
                int blockIndex = this.indexOf((byte)2);
                if (blockIndex == -1) break;
                return blockIndex;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    public void buildSelf() {
        super.buildSelf();
        if (this.isVarargs()) {
            this.makeVarArgsParameter();
        }
        if (this.methodXDimension > 0) {
            TypeSym typeSym = this.getTypeSym();
            typeSym.typeXtraDimension = this.methodXDimension;
        }
    }

    private void makeVarArgsParameter() {
        VariableSym variableSym = (VariableSym)this.getFormalsSym().getLastChild((byte)13);
        if (variableSym != null) {
            variableSym.symAccess = (char)(variableSym.symAccess | 0x80);
            TypeSym typeSym = variableSym.getTypeSym();
            if (typeSym != null) {
                typeSym.symAccess = (char)(typeSym.symAccess | 0x80);
            }
        }
    }

    private void removeVarArgsParameter() {
        VariableSym variableSym = (VariableSym)this.getFormalsSym().getLastChild((byte)13);
        if (variableSym != null) {
            variableSym.symAccess = (char)(variableSym.symAccess & 0xFFFFFF7F);
            TypeSym typeSym = variableSym.getTypeSym();
            if (typeSym != null) {
                typeSym.symAccess = (char)(typeSym.symAccess & 0xFFFFFF7F);
            }
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        MethodSym sym = (MethodSym)super.cloneSelf(targetFile);
        sym.methodXDimension = this.methodXDimension;
        return sym;
    }

    @Override
    protected void add(Sym child, byte filter) {
        FormalsSym formals;
        if (!this.isValidChild(child, filter) && (formals = this.getFormalsSym()).isValidChild(child, filter)) {
            formals.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    @Override
    protected Sym createSkeleton(byte symKind) {
        Sym sym = super.createSkeleton(symKind);
        if (symKind == 12) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    @Override
    protected void setupSkeleton() {
        this.getFormalsSym();
        this.getThrowsSym();
    }

    @Override
    protected void setModifiersImpl(char access) {
        boolean hasVarargs;
        boolean hadVarargs = (this.symAccess & 0x80) != 0;
        super.setModifiersImpl(access);
        boolean bl = hasVarargs = (this.symAccess & 0x80) != 0;
        if (hadVarargs != hasVarargs) {
            if (hadVarargs) {
                this.removeVarArgsParameter();
            } else {
                this.makeVarArgsParameter();
            }
        }
    }

    public MethodObj getMethodObj() {
        if (this.hasObjData()) {
            return (MethodObj)this.symData;
        }
        MethodObj methodObj = new MethodObj();
        methodObj.objSym = this;
        this.symData = methodObj;
        return methodObj;
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        compiler.resolve(this);
        return this;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print_javadoc(out);
                this.print_annotations(out);
                this.print_modifiers(out);
                this.print_ty_parameters(out);
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), out, argument);
                    out.print(' ');
                }
                MethodSym.print(this.getNameSym(), out, argument);
                this.getFormalsSym().print_signature(out, true);
                MethodSym.print(this.getThrowsSym(), out);
                SourceBlock block = this.getBlock();
                if (block != null) {
                    block.print(out, argument);
                    break;
                }
                out.println(';');
                break;
            }
            case 1: {
                MethodSym.print(this.getNameSym(), out, argument);
                this.getFormalsSym().print_signature(out, false);
                break;
            }
            case 2: {
                this.print_modifiers(out);
                this.print_ty_parameters(out);
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), out, argument);
                    out.print(' ');
                }
                MethodSym.print(this.getNameSym(), out, argument);
                this.getFormalsSym().print_signature(out, true);
                MethodSym.print(this.getThrowsSym(), out);
            }
        }
    }
}

