/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.model.JavaClass;

public abstract class MemberSym
extends ObjectSym {
    public MemberSym() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    public final JavaClass getOwningClass() {
        return this.getOwningClassSym();
    }

    public final List getSourceTypeParameters() {
        return this.getChildren((byte)26);
    }

    public final boolean hasTypeParameters() {
        return this.getChild((byte)26) != null;
    }

    public final Collection getTypeParameters() {
        return this.getObjects((byte)26);
    }

    public final boolean hasActualTypeArguments() {
        return false;
    }

    public final Collection getActualTypeArguments() {
        return kEmptyList;
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 1: 
            case 63: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 63: {
                return 0;
            }
            case 1: {
                int lastAnnotation = this.lastIndexOf((byte)1);
                if (lastAnnotation != -1) {
                    return lastAnnotation + 1;
                }
                if (this.indexOf((byte)63) != -1) {
                    return 1;
                }
                return 0;
            }
            case 27: {
                int lastAnnotation = this.lastIndexOf((byte)1);
                if (lastAnnotation != -1) {
                    return lastAnnotation + 1;
                }
                if (this.indexOf((byte)63) != -1) {
                    return 1;
                }
                return 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    public boolean checkSafeToInsert() {
        return true;
    }

    @Override
    public boolean checkSafeToDelete(TreeSym parent) {
        return true;
    }

    @Override
    public void buildSelf() {
        ClassSym owningClass;
        super.buildSelf();
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 4 && (owningClass = this.getOwningClassSym()) != null) {
            this.objectXaccess = (char)(this.objectXaccess | owningClass.objectXaccess & 0x2001);
        }
    }

    @Override
    public String printCompiledInfo() {
        String out = "";
        if (this.isDeprecated()) {
            out = out + "@deprecated ";
        }
        if (this.isHidden()) {
            out = out + "@hidden ";
        }
        return out;
    }

    public final void print_javadoc(PrintWriter out) {
        DocCommentSym javadoc = this.getJavadocSym();
        if (javadoc == null) {
            return;
        }
        MemberSym.print(javadoc, out);
        out.println();
    }

    public final void print_ty_parameters(PrintWriter out, int argument) {
        List things = this.getSourceTypeParameters();
        int count = things.size();
        if (count > 0) {
            out.print('<');
            Iterator iterator = things.iterator();
            boolean needComma = false;
            while (iterator.hasNext()) {
                if (needComma) {
                    out.print(", ");
                }
                Sym thing = (Sym)iterator.next();
                MemberSym.print(thing, out, argument);
                needComma = true;
            }
            out.print('>');
            out.print(' ');
        }
    }

    public final void print_ty_parameters(PrintWriter out) {
        this.print_ty_parameters(out, 0);
    }
}

