/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.FileObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymIndex;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.UsageHook;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourceFileListener;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public final class FileSym
extends ObjectSym
implements SourceFile {
    public URL url = null;
    private JavaProvider provider = null;
    private SourcePreferences preferences;
    private SourceFileListener[] listeners = SourceFileListener.EMPTY_ARRAY;
    private TextBuffer tmpBuffer = null;
    private TextBuffer pinnedBuffer = null;
    public int bufferChangeId = -1;
    private CompilerDriver pinnedCompiler = null;
    private WeakReference compilerReference = null;
    private volatile Object compilerLock;
    private FileObj fileObj;
    private SymTransaction transaction = null;
    protected final SymFactory factory = new SymFactory(this);
    public final TreeSym parseErrors;
    public final TreeSym compileErrors;
    public TokenArray tokens;
    public byte j2se;
    public SymIndex pinnedIndex = null;
    private SoftReference indexReference = null;
    public List possibleTypes = kEmptyList;
    private volatile boolean isExpired;

    public FileSym() {
        this.symFile = this;
        this.parseErrors = (TreeSym)SymFactory.createNode(this, 74);
        this.parseErrors.symParent = this;
        this.compileErrors = (TreeSym)SymFactory.createNode(this, 74);
        this.compileErrors.symParent = this;
    }

    @Override
    public int getElementKind() {
        return 6;
    }

    public final boolean flag_noAutoSavepoint() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public int getLanguageVersion() {
        return this.j2se;
    }

    @Override
    public SourcePackage getSourcePackage() {
        return this.getRoot().getSourcePackage();
    }

    @Override
    public String getPackageName() {
        SourcePackage packageSym = this.getSourcePackage();
        if (packageSym == null) {
            return "";
        }
        return packageSym.getName();
    }

    @Override
    public void setSourcePackage(SourcePackage packageD) {
        this.getRoot().setSourcePackage(packageD);
    }

    @Override
    public void setPackageName(String name) {
        if (name.length() > 0) {
            this.getRoot().setPackageName(name);
        } else {
            RootSym root = this.getRoot();
            PackageSym packageSym = root.getPackageSym();
            if (packageSym != null) {
                packageSym.removeSelf();
            }
        }
    }

    @Override
    public List getSourceImports() {
        return this.getRoot().getSourceImports();
    }

    @Override
    public Set getSourceImportNames() {
        return this.getRoot().getSourceImportNames();
    }

    @Override
    public List getSourceClasses() {
        return this.getRoot().getSourceClasses();
    }

    @Override
    public SourceClass getSourceClass(String name) {
        return this.getRoot().getSourceClass(name);
    }

    public SourceName getSqlContext() {
        return this.getRoot().getSqlContext();
    }

    public final RootSym getRoot() {
        return (RootSym)this.getChild((byte)73);
    }

    @Override
    public SourceClass getSourcePrimaryClass() {
        return this.getPrimaryClassSym();
    }

    public ClassSym getPrimaryClassSym() {
        RootSym rootSym = this.getRoot();
        if (this.url != null) {
            String path = this.url.getPath();
            int lastSlash = path.lastIndexOf(47);
            int lastDot = path.lastIndexOf(46);
            if (lastDot != -1) {
                String target = path.substring(lastSlash + 1, lastDot);
                for (ClassSym classSym : rootSym.getSourceClasses()) {
                    if (!target.equals(classSym.getName())) continue;
                    return classSym;
                }
            }
        }
        return (ClassSym)rootSym.getChild((byte)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaPackage getPackage() {
        JavaProvider provider;
        String packageName = this.getPackageName();
        FileSym fileSym = this;
        synchronized (fileSym) {
            provider = this.provider;
            if (provider == null) {
                return null;
            }
        }
        return provider.getPackage(packageName);
    }

    @Override
    public Collection getClasses() {
        return this.getRoot().getClasses();
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public JavaClass getPrimaryClass() {
        return this.getPrimaryClassSym();
    }

    @Override
    public List getPossibleTypes() {
        return this.possibleTypes;
    }

    @Override
    public boolean hasParseErrors() {
        return this.parseErrors.treeChildren.length > 0;
    }

    @Override
    public List getParseErrors() {
        return this.parseErrors.getChildren();
    }

    @Override
    public boolean hasCompileErrors() {
        return this.compileErrors.treeChildren.length > 0;
    }

    @Override
    public List getCompileErrors() {
        return this.compileErrors.getChildren();
    }

    @Override
    public boolean hasErrors(int severity, int errorCategory) {
        if ((errorCategory & 2) != 0 && this.hasParseErrors()) {
            for (ErrorSym error : this.getParseErrors()) {
                if (severity > error.getErrorSeverity()) continue;
                return true;
            }
        }
        if ((errorCategory & 4) != 0) {
            if (!this.isCompiled()) {
                this.compile();
            }
            if (this.hasCompileErrors()) {
                for (ErrorSym error : this.getCompileErrors()) {
                    if (severity > error.getErrorSeverity()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Collection getErrors(int severity, int errorCategory) {
        if (!this.hasParseErrors() && !this.hasCompileErrors()) {
            return kEmptyCollection;
        }
        ArrayList list = new ArrayList();
        if (this.hasParseErrors()) {
            list.addAll(this.getParseErrors());
        }
        if (this.hasCompileErrors()) {
            if (!this.isCompiled()) {
                this.compile();
            }
            list.addAll(this.getCompileErrors());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ErrorSym error = (ErrorSym)iterator.next();
            if (error.getErrorSeverity() >= severity) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public final SourceElement getElementAt(int offset) {
        return this.getSymAt(offset);
    }

    @Override
    public final SourceElement getElementContaining(int startOffset, int endOffset) {
        return this.getSymContaining(startOffset, endOffset);
    }

    public Sym getSymAt(int offset) {
        Sym child;
        boolean withinFile;
        this.ensureSavepoint();
        try {
            SymIndex symIndex = this.getIndex();
            Sym found = symIndex.getSymAt(offset);
            if (found != null) {
                return found;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        boolean bl = withinFile = this.getStartOffset() <= offset && offset <= this.getEndOffset();
        if (!withinFile) {
            return null;
        }
        Sym search = this.getRoot();
        if (search == null) {
            return null;
        }
        while ((child = ((Sym)search).getChildAt(offset)) != null) {
            boolean contained;
            if (child == search) {
                FileSym.panic();
            }
            boolean bl2 = contained = child.getStartOffset() <= offset && offset <= child.getEndOffset();
            if (!contained) {
                FileSym.panic();
            }
            search = child;
        }
        return search;
    }

    public Sym getSymContaining(int startOffset, int endOffset) {
        Sym sym;
        Sym search;
        for (search = sym = this.getSymAt(startOffset); search != null; search = search.getParentSym()) {
            boolean containsEnd;
            boolean bl = containsEnd = search.getStartOffset() <= endOffset && endOffset <= search.getEndOffset();
            if (containsEnd) break;
        }
        return search;
    }

    @Override
    public SourceElement getElementAt(int offset, int mask) {
        return this.getElementAt(offset);
    }

    @Override
    protected void checkCloneable() {
        FileSym.unsupported("Use cloneSelf(TextBuffer)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceFile cloneSelf(TextBuffer cloneTextBuffer) {
        FileSym sym;
        TextBuffer thisTextBuffer = this.getTextBuffer();
        if (thisTextBuffer == null) {
            FileSym.unsupported("No underlying text buffer");
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            SymTransaction transaction = this.getTransactionSym();
            if (transaction != null && transaction.hasOutstandingChanges()) {
                FileSym.unsupported("Open transaction with outstanding changes");
            }
            if (cloneTextBuffer == null) {
                cloneTextBuffer = TextBufferFactory.createArrayTextBuffer();
            }
            char[] thisChars = thisTextBuffer.getChars(0, thisTextBuffer.getLength());
            cloneTextBuffer.insert(0, thisChars);
            sym = SymFactory.createFile();
            sym.pinTextBuffer(cloneTextBuffer);
            sym.buildSelf();
            sym.j2se = this.j2se;
            Sym out = this.cloneSelf(sym);
            if (out != sym) {
                FileSym.panic("FileSym mismatch");
            }
            sym.adjustSelf((Sym)this);
            sym.clearFormatInfo();
        }
        return sym;
    }

    @Override
    public Sym cloneSelfImpl(FileSym alreadyCreated) {
        return alreadyCreated;
    }

    @Override
    public Sym cloneSelf(FileSym alreadyCreated) {
        FileSym sym = (FileSym)super.cloneSelf(alreadyCreated);
        if (sym != alreadyCreated) {
            FileSym.panic("FileSym mismatch");
        }
        sym.url = this.url;
        sym.provider = this.provider;
        sym.preferences = this.preferences;
        sym.possibleTypes = this.possibleTypes;
        return sym;
    }

    @Override
    public SourceFactory getFactory() {
        return this.factory;
    }

    public SymFactory getSymFactory() {
        return this.factory;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public void setURL(URL url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaProvider getProvider() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            return this.provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvider(JavaProvider provider) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.provider = provider;
            this.pinnedCompiler = null;
            if (this.compilerReference != null) {
                this.compilerReference.clear();
            }
            this.compilerReference = null;
        }
    }

    @Override
    public SourcePreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new SourcePreferences();
        }
        return this.preferences;
    }

    @Override
    public void setPreferences(SourcePreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    protected void add(Sym child, byte filter) {
        this.getRoot().add(child, filter);
    }

    @Override
    public List getChildren() {
        return this.getRoot().getChildren();
    }

    @Override
    public List getChildren(int mask) {
        return this.getRoot().getChildren(mask);
    }

    @Override
    public void cancelCompile() {
        CompilerDriver currentCompiler = this.pinnedCompiler;
        if (currentCompiler != null) {
            currentCompiler.cancel();
        }
    }

    @Override
    public boolean isCompiled() {
        return this.isProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            return this.isExpired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (!this.isExpired) {
                this.isExpired = true;
                if (this.transaction != null) {
                    throw new RuntimeException("Transaction in progress");
                }
                this.cancelCompile();
                int count = this.listeners.length;
                for (int i = count - 1; i >= 0; --i) {
                    this.listeners[i].expiredUpdate(this);
                }
                this.listeners = SourceFileListener.EMPTY_ARRAY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSelf() {
        super.buildSelf();
        this.parseErrors.buildSelf();
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer = this.getTextBuffer();
            if (textBuffer != null) {
                int newBufferChangeId = textBuffer.getChangeId();
                if (this.tokens == null || newBufferChangeId != this.bufferChangeId) {
                    this.clearIndex();
                    JavaLexer lexer = new JavaLexer(this.j2se);
                    lexer.setTextBuffer(textBuffer);
                    this.tokens = new TokenArray(lexer);
                }
                this.bufferChangeId = newBufferChangeId;
            }
            this.symEnd = this.tokens.tokenCount - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compileLock() {
        Object foundLock = null;
        FileSym fileSym = this;
        synchronized (fileSym) {
            foundLock = this.compilerLock;
            if (foundLock == null) {
                this.compilerLock = new String("Compile in progress");
            }
        }
        return foundLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileWait(Object foundLock) {
        Object object = foundLock;
        synchronized (object) {
            int attempts = 2;
            boolean firstAttempt = true;
            while (this.compilerLock != null && this.compilerLock == foundLock) {
                if (firstAttempt && this.pinnedCompiler != null) {
                    FileSym.unsupported("Re-entered compile()");
                }
                firstAttempt = false;
                try {
                    foundLock.wait(30000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (--attempts != 0) continue;
                FileSym.panic("Starved while waiting for the compile to finish");
            }
        }
    }

    @Override
    public void clearCompiledInfo() {
        if (this.pinnedCompiler != null && !this.isExpired()) {
            Logger logger = JavaParser.getLogger();
            String message = "Attempting to clear compiled info while compile is in progress";
            logger.log(Level.FINE, "Attempting to clear compiled info while compile is in progress");
            this.cancelCompile();
        }
        this.compileErrors.treeChildren = Sym.EMPTY_ARRAY;
        super.clearCompiledInfo();
    }

    CompilerDriver createCompiler() {
        if (this.provider == null) {
            return null;
        }
        CompilerDriver compiler = new CompilerDriver(this.provider, this.j2se);
        compiler.setCompilationUnit(this);
        return compiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompilerDriver getCompiler() {
        CompilerDriver compiler;
        if (this.pinnedCompiler != null && Thread.currentThread() == this.pinnedCompiler.getThread()) {
            return this.pinnedCompiler;
        }
        if (this.compilerReference != null && (compiler = (CompilerDriver)this.compilerReference.get()) != null && Thread.currentThread() == compiler.getThread()) {
            return compiler;
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.provider == null) {
                return null;
            }
            CompilerDriver compiler2 = this.createCompiler();
            this.compilerReference = new WeakReference<CompilerDriver>(compiler2);
            return compiler2;
        }
    }

    protected CompilerDriver getForgivingCompiler() {
        JavaProvider provider = this.getProvider();
        if (provider == null) {
            return null;
        }
        CompilerDriver compiler = new CompilerDriver(provider, this.j2se);
        compiler.flag_forgiving = true;
        return compiler;
    }

    public JavaElement processUsages(UsageHook hook) {
        CompilerDriver compiler = this.createCompiler();
        if (compiler == null) {
            return null;
        }
        compiler.setUsageHook(hook);
        return this.compile(compiler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        Object foundLock = this.compileLock();
        if (foundLock != null) {
            this.compileWait(foundLock);
            return this.getCompiledObject();
        }
        Object object = this.compilerLock;
        synchronized (object) {
            JavaElement javaElement;
            try {
                JavaElement out;
                SyntaxData errorData;
                this.pinnedCompiler = compiler;
                compiler.clearCancel();
                super.clearCompiledInfo();
                this.symData = null;
                FileObj fileObj = this.getFileObj();
                fileObj.errorData = errorData = new SyntaxData();
                try {
                    out = super.compileImpl(compiler);
                }
                catch (CancellationException e) {
                    super.clearCompiledInfo();
                    this.symData = null;
                    fileObj.errorData = new SyntaxData();
                    throw e;
                }
                this.compileErrors.symData = errorData;
                this.compileErrors.buildSelf();
                FileSym.removeDuplicateErrors(this.compileErrors);
                this.setProcessed();
                javaElement = out;
                this.pinnedCompiler = null;
                Object lock = this.compilerLock;
                this.compilerLock = null;
                lock.notifyAll();
            }
            catch (Throwable throwable) {
                this.pinnedCompiler = null;
                Object lock = this.compilerLock;
                this.compilerLock = null;
                lock.notifyAll();
                throw throwable;
            }
            return javaElement;
        }
    }

    private static void removeDuplicateErrors(TreeSym errors) {
        Sym[] array = errors.treeChildren;
        int count = array.length;
        if (count < 2) {
            return;
        }
        errors.sortSelf();
        ArrayList<Sym> list = new ArrayList<Sym>();
        list.add(array[0]);
        for (int i = 1; i < count; ++i) {
            Sym sym = array[i];
            Sym previousSym = array[i - 1];
            if (sym.equals(previousSym)) continue;
            list.add(sym);
        }
        int size = list.size();
        errors.treeChildren = list.toArray(new Sym[size]);
    }

    @Override
    protected boolean hasObjData() {
        return this.fileObj != null;
    }

    public FileObj getFileObj() {
        if (this.fileObj == null) {
            FileObj obj = new FileObj();
            obj.objSym = this;
            this.fileObj = obj;
        }
        return this.fileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormatRegion reformatRegion(int startOffset, int endOffset) {
        SymTransaction transaction;
        SymTransaction symTransaction = transaction = this.verifyTransaction();
        synchronized (symTransaction) {
            if (transaction.hasOutstandingChanges()) {
                FileSym.unsupported("Cannot format region with outstanding changes");
            }
            if (transaction.savepointInProgress()) {
                FileSym.unsupported("Command invalid during savepoint");
            }
            FileSym fileSym = this;
            synchronized (fileSym) {
                FormatRegion region = FormatRegion.create_fromOffsets(startOffset, endOffset, this.tokens);
                SymOperation op = transaction.newOperation((byte)7);
                op.opTarget = this;
                op.setBinding(region);
                op.buildSelf();
                transaction.savepoint();
                return region;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reformatSubtree(Sym sym, int formatMask) {
        SymTransaction transaction;
        SymTransaction symTransaction = transaction = this.verifyTransaction();
        synchronized (symTransaction) {
            if (transaction.savepointInProgress()) {
                FileSym.unsupported("Command invalid during savepoint");
            }
            transaction.savepoint();
            FileSym fileSym = this;
            synchronized (fileSym) {
                int opKind = 6;
                SymOperation op = transaction.newOperation((byte)6);
                op.opTarget = sym;
                op.buildSelf();
                transaction.savepoint();
            }
        }
    }

    protected void adjustOffsets() {
        TextBuffer textBuffer = this.getTextBuffer();
        FileSym otherSym = (FileSym)JavaParser.parse(textBuffer, this.j2se);
        if (otherSym == null) {
            FileSym.panic();
        }
        this.adjustSelf(otherSym);
    }

    protected void adjustSelf(FileSym sym) {
        RootSym thisRoot = this.getRoot();
        RootSym otherRoot = sym.getRoot();
        thisRoot.clearOffsets();
        thisRoot.adjustSelf(otherRoot);
        this.tokens = sym.tokens;
        this.bufferChangeId = sym.bufferChangeId;
        this.possibleTypes = sym.possibleTypes;
        this.clearIndex();
        this.parseErrors.treeChildren = Sym.EMPTY_ARRAY;
        SyntaxData parseErrorData = new SyntaxData();
        this.parseErrors.symData = parseErrorData;
        for (Sym otherError : sym.parseErrors.treeChildren) {
            try {
                Sym clonedError = otherError.cloneSelf(this);
                if (clonedError == null) continue;
                parseErrorData.addKid(clonedError);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.buildSelf();
    }

    public void mapSelf(FileSym otherFile) {
        this.mapSelfImpl(otherFile);
        RootSym thisRoot = this.getRoot();
        RootSym otherRoot = otherFile.getRoot();
        thisRoot.mapSelf(otherRoot);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        RootSym rootSym = this.getRoot();
        if (rootSym != null) {
            rootSym.print(out);
        }
    }

    @Override
    protected boolean isValidChild(Sym child, byte filter) {
        switch (child.symKind) {
            case 73: {
                return true;
            }
        }
        return super.isValidChild(child, filter);
    }

    public LineMap getLineMap() {
        TextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer != null) {
            return textBuffer.getLineMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextBuffer getTextBuffer() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer transTextBuffer;
            if (this.isExpired) {
                throw new ExpiredTextBufferException();
            }
            if (this.tmpBuffer != null) {
                return this.tmpBuffer;
            }
            SymTransaction transaction = this.getTransactionSym();
            if (transaction != null && (transTextBuffer = transaction.getTextBuffer()) != null) {
                return transTextBuffer;
            }
            if (this.pinnedBuffer != null) {
                return this.pinnedBuffer;
            }
        }
        if (this.provider == null || this.url == null) {
            return null;
        }
        TextBuffer backupBuffer = this.provider.getTextBuffer(this.url);
        return backupBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextBuffer(TextBuffer textBuffer) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedBuffer == null) {
                this.pinnedBuffer = textBuffer;
                this.bufferChangeId = textBuffer.getChangeId();
                BufferTracker bufferTracker = new BufferTracker(this, textBuffer);
            } else if (this.pinnedBuffer != textBuffer) {
                FileSym.unsupported("Different pinned buffer");
            }
        }
    }

    @Override
    public void pinTextBuffer(TextBuffer textBuffer) {
        this.setTextBuffer(textBuffer);
    }

    @Override
    public void unpinTextBuffer() {
        this.pinnedBuffer = null;
    }

    private int findSourceFileListener(SourceFileListener listener) {
        int count = this.listeners.length;
        for (int i = 0; i < count; ++i) {
            if (this.listeners[i] != listener) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceFileListener(SourceFileListener listener) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int index = this.findSourceFileListener(listener);
            if (index != -1) {
                return;
            }
            int count = this.listeners.length;
            SourceFileListener[] newArray = new SourceFileListener[count + 1];
            if (count > 0) {
                System.arraycopy(this.listeners, 0, newArray, 0, count);
            }
            newArray[count] = listener;
            this.listeners = newArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceFileListener(SourceFileListener listener) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int index = this.findSourceFileListener(listener);
            if (index == -1) {
                return;
            }
            int count = this.listeners.length;
            if (count == 1) {
                this.listeners = SourceFileListener.EMPTY_ARRAY;
            } else {
                SourceFileListener[] newArray = new SourceFileListener[count - 1];
                if (index != 0) {
                    System.arraycopy(this.listeners, 0, newArray, 0, index);
                }
                if (index != count - 1) {
                    System.arraycopy(this.listeners, index + 1, newArray, index, count - 1 - index);
                }
                this.listeners = newArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(SymTransaction transaction) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int count = this.listeners.length;
            for (int i = count - 1; i >= 0; --i) {
                this.listeners[i].changeUpdate(this, transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceTransaction beginTransaction() {
        SymTransaction t;
        if (this.isExpired) {
            throw new ExpiredTextBufferException();
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer;
            if (this.transaction != null) {
                FileSym.errorOpenTransaction();
            }
            if ((textBuffer = this.getTextBuffer()) == null) {
                FileSym.errorNoTextBuffer();
            }
            this.transaction = t = new SymTransaction(this, textBuffer);
        }
        t.begin();
        return t;
    }

    @Override
    public SourceTransaction getTransaction() {
        return this.getTransactionSym();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymTransaction getTransactionSym() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            return this.transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SymTransaction closeTransaction() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.transaction == null) {
                FileSym.errorNoTransaction();
            }
            SymTransaction out = this.transaction;
            this.transaction = null;
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymIndex getIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedIndex != null) {
                return this.pinnedIndex;
            }
            SymIndex index = null;
            if (this.indexReference != null) {
                index = (SymIndex)this.indexReference.get();
            }
            if (index == null) {
                index = this.buildIndex();
            }
            this.indexReference = new SoftReference<SymIndex>(index);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymIndex pinIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedIndex != null) {
                return this.pinnedIndex;
            }
            SymIndex index = null;
            if (this.indexReference != null) {
                index = (SymIndex)this.indexReference.get();
            }
            if (index == null) {
                index = this.buildIndex();
            }
            this.pinnedIndex = index;
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpinIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedIndex != null) {
                this.indexReference = new SoftReference<SymIndex>(this.pinnedIndex);
                this.pinnedIndex = null;
            }
        }
    }

    private SymIndex buildIndex() {
        return new SymIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.indexReference = null;
            this.pinnedIndex = null;
        }
    }

    @Override
    protected int indexSelf(Sym[] index, int pos, TokenArray tokens) {
        RootSym rootSym = this.getRoot();
        pos = rootSym.indexSelf(index, pos, tokens);
        int tokenCount = tokens.tokenCount;
        while (pos < tokenCount) {
            index[pos++] = this;
        }
        return pos;
    }

    @Override
    protected void verboseSelf(StringBuilder stringBuffer) {
        stringBuffer.append(" url ");
        stringBuffer.append(this.getURL());
        stringBuffer.append(" id ");
        stringBuffer.append(System.identityHashCode(this));
    }

    private static class BufferTracker
    implements TextBufferListener {
        private WeakReference _sourceFileRef;
        private WeakReference _textBufferRef;

        private BufferTracker(SourceFile sourceFile, TextBuffer textBuffer) {
            this._sourceFileRef = new WeakReference<SourceFile>(sourceFile);
            this._textBufferRef = new WeakReference<TextBuffer>(textBuffer);
            textBuffer.addTextBufferListener(this);
        }

        @Override
        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            this.bufferChanged();
        }

        @Override
        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            this.bufferChanged();
        }

        @Override
        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private void bufferChanged() {
            if (this._sourceFileRef != null) {
                boolean detach = false;
                SourceFile sourceFile = (SourceFile)this._sourceFileRef.get();
                if (sourceFile == null) {
                    detach = true;
                } else if (sourceFile.getTransaction() == null) {
                    detach = true;
                    sourceFile.expire();
                }
                if (detach) {
                    TextBuffer textBuffer = (TextBuffer)this._textBufferRef.get();
                    if (textBuffer != null) {
                        textBuffer.removeTextBufferListener(this);
                    }
                    this._textBufferRef = null;
                    this._sourceFileRef = null;
                }
            }
        }
    }
}

