/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;

public class EnumConstantSym
extends MemberSym
implements SourceEnumConstant {
    JavaMethod resolvedConstructor;

    public EnumConstantSym() {
        this.objectImplicit = (char)16409;
    }

    @Override
    public int getElementKind() {
        return 5;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public JavaType getResolvedType() {
        for (JavaElement owner = this.getOwner(); owner != null; owner = owner.getOwner()) {
            if (!(owner instanceof ClassSym)) continue;
            return ((ClassSym)owner).getResolvedType();
        }
        return super.getResolvedType();
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.resolvedConstructor = null;
    }

    @Override
    public SourceExpression getInitializer() {
        return null;
    }

    @Override
    public void setInitializer(SourceExpression expr) {
        throw new UnsupportedOperationException("Not allowed on enum constant");
    }

    @Override
    public SourceVariableDeclaration getOwningDeclaration() {
        return null;
    }

    @Override
    public SourceListExpression getArguments() {
        return this.getArgumentsSym();
    }

    @Override
    public void setArguments(SourceListExpression arguments) {
        this.setSym((byte)51, (Sym)((Object)arguments));
    }

    @Override
    public SourceClass getAnonymousClass() {
        return (SourceClass)((Object)this.getChild((byte)3));
    }

    @Override
    public void setAnonymousClass(SourceClass thing) {
        this.setSym((byte)3, (Sym)((Object)thing));
    }

    public ListExpr getArgumentsSym() {
        return (ListExpr)this.getChild((byte)51);
    }

    @Override
    public boolean isEnumConstant() {
        return true;
    }

    @Override
    public Object getConstantValue() {
        return this;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "FieldSignature " + resolvedType.getTypeSignature();
        }
        return "FieldSignature <unknown>";
    }

    @Override
    public void separateSelf() {
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 1: 
            case 3: 
            case 20: 
            case 51: 
            case 63: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        compiler.resolve(this);
        return this;
    }

    public void setResolvedConstructor(JavaMethod resolvedConstructor) {
        this.resolvedConstructor = resolvedConstructor;
    }

    @Override
    public JavaElement getCompiledObject() {
        if (this.resolvedConstructor == null) {
            this.resolve();
        }
        return this.resolvedConstructor;
    }
}

