/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatLayer5j;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.InitializerSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;

abstract class FormatLayer5
extends FormatLayer5j {
    protected boolean flag_firstchild = false;

    FormatLayer5() {
    }

    @Override
    public void init(Sym s) {
        super.init(s);
        this.flag_firstchild = false;
    }

    public final void print(FileSym sym) {
        FormatLayer5.unsupported("Cannot print a FileSym directly");
    }

    public final void print(RootSym sym) {
        boolean importGroupImports = this.preferences.getBoolean(62);
        int importGroupPackageDepth = this.preferences.getInt(63);
        String previousImport = null;
        boolean sawClass = false;
        boolean sawNonClass = false;
        for (Sym child : sym.treeChildren) {
            int blanklinesImportAfter;
            boolean justSawImport;
            byte symKind = child.symKind;
            boolean bl = justSawImport = previousImport != null;
            if (justSawImport && symKind != 14 && (blanklinesImportAfter = this.preferences.getInt(9)) > 0) {
                this.ensureNewlines(blanklinesImportAfter + 1);
            }
            String currentImport = null;
            switch (symKind) {
                case 21: {
                    this.handle(child);
                    int blanklinesPackageAfter = this.preferences.getInt(8);
                    if (blanklinesPackageAfter > 0) {
                        this.ensureNewlines(blanklinesPackageAfter + 1);
                    }
                    sawNonClass = true;
                    break;
                }
                case 14: {
                    ImportSym importSym = (ImportSym)child;
                    currentImport = importSym.getName();
                    if (this.newlines() < 2 && importGroupImports && justSawImport && currentImport.length() > 0) {
                        boolean blankline = true;
                        if (importGroupPackageDepth > 0) {
                            boolean samePackage = FormatLayer5.samePackage(previousImport, currentImport);
                            if (samePackage) {
                                blankline = false;
                            } else {
                                int sharedDepth = FormatLayer5.getSharedDotDepth(previousImport, currentImport);
                                if (sharedDepth >= importGroupPackageDepth) {
                                    blankline = false;
                                }
                            }
                        }
                        if (blankline) {
                            this.ensureNewlines(2);
                        }
                    }
                    this.handle(child);
                    sawNonClass = true;
                    break;
                }
                case 3: {
                    if (!sawClass && sawNonClass) {
                        int blanklinesBeforeFirstClass = this.preferences.getInt(10);
                        if (blanklinesBeforeFirstClass > 0) {
                            this.ensureNewlines(blanklinesBeforeFirstClass + 1);
                        }
                        sawClass = true;
                    }
                    this.handle(child);
                    break;
                }
                default: {
                    this.handle(child);
                }
            }
            previousImport = currentImport;
        }
    }

    public final void print(PackageSym sym) {
        this.handleJavadoc(sym);
        NameSym name = sym.getNameSym();
        if (name != null) {
            this.handleComment(name);
            this.handleAnnotations(sym);
            this.print((short)125, ' ');
            this.handle(name);
            this.println((short)75);
        }
    }

    public final void print(ImportSym sym) {
        NameSym name = sym.getNameSym();
        if (name != null) {
            this.print((short)118, ' ');
            if (sym.isStatic()) {
                this.print((short)131, ' ');
            }
            this.handle(name);
            this.println((short)75);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(ClassSym sym) {
        int saved;
        Sym parentSym;
        boolean checkBlanklines = false;
        if (!this.flag_firstchild && (parentSym = sym.getParentSym()) != null && parentSym.symKind == 4) {
            checkBlanklines = true;
        }
        if (checkBlanklines) {
            this.ensureNewlines(this.preferences.getInt(16) + 1);
        }
        this.handleJavadoc(sym, checkBlanklines);
        this.handleAnnotations(sym);
        NameSym nameSym = sym.getNameSym();
        if (nameSym != null) {
            saved = this.push();
            try {
                this.enter(nameSym);
                this.handleModifiers(sym);
                this.print(TY_words[sym.getTypeKind()]);
                this.print(' ');
            }
            finally {
                this.leave(nameSym);
                this.pop(saved);
            }
        } else {
            this.handleModifiers(sym);
            this.print(TY_words[sym.getTypeKind()]);
            this.print(' ');
        }
        this.handle(sym.getNameSym());
        this.handleTypeParameters(sym);
        saved = this.push();
        try {
            this.indent(1);
            this.handle(sym.getSuperclassSym());
            this.handle(sym.getInterfacesSym());
        }
        finally {
            this.pop(saved);
        }
        if (this.preferences.getBoolean(21)) {
            this.ensureNewlines(1);
        }
        this.handle(sym.getBodySym());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(MethodSym sym) {
        if (!this.flag_firstchild) {
            this.ensureNewlines(this.preferences.getInt(15) + 1);
        }
        this.handleJavadoc(sym, !this.flag_firstchild);
        boolean constructor = sym.isConstructor();
        TypeSym typeSym = sym.getTypeSym();
        NameSym nameSym = sym.getNameSym();
        if (constructor) {
            this.handleComment(nameSym);
        } else {
            this.handleComment(typeSym);
        }
        this.handleAnnotations(sym);
        this.handleModifiers(sym);
        this.handleTypeParameters(sym);
        if (!constructor) {
            this.handle(typeSym);
            this.print(' ');
        }
        this.handle(nameSym);
        if (this.preferences.getBoolean(43)) {
            this.print(' ');
        }
        this.handle(sym.getFormalsSym());
        int saved = this.push();
        try {
            this.indent(1);
            this.handle(sym.getThrowsSym());
        }
        finally {
            this.pop(saved);
        }
        BlockSym block = sym.getBlockSym();
        if (block != null) {
            if (this.preferences.getBoolean(22)) {
                this.ensureNewlines(1);
            }
            this.handle(block);
            this.ensureNewlines(1);
        } else {
            Expr e = sym.getExpressionSym();
            if (e != null) {
                this.print(' ');
                this.print((short)106, ' ');
                this.handle(e);
            }
            this.println((short)75);
        }
    }

    public final void print(FieldDeclSym sym) {
        if (!this.flag_firstchild) {
            this.ensureNewlines(this.preferences.getInt(14) + 1);
        }
        this.handleJavadoc(sym, !this.flag_firstchild);
        this.print((VardeclSym)sym);
    }

    public final void print(EnumConstantSym sym) {
        ClassSym classSym;
        if (!this.flag_firstchild) {
            this.ensureNewlines(this.preferences.getInt(14) + 1);
        }
        this.handleJavadoc(sym, !this.flag_firstchild);
        this.handleAnnotations(sym);
        this.handle(sym.getNameSym());
        ListExpr listExpr = sym.getArgumentsSym();
        if (listExpr != null) {
            this.handleArguments(listExpr);
        }
        if ((classSym = (ClassSym)sym.getAnonymousClass()) != null) {
            this.enter(classSym);
            if (this.preferences.getBoolean(21)) {
                this.ensureNewlines(1);
            }
            this.handle(classSym.getBodySym());
            this.leave(classSym);
        }
    }

    public final void print(InitializerSym sym) {
        this.handleJavadoc(sym);
        DocCommentSym javadocSym = sym.getJavadocSym();
        if (javadocSym != null) {
            javadocSym.removeSelf();
        }
        this.handleModifiers(sym);
        if (this.preferences.getBoolean(21)) {
            this.ensureNewlines(1);
        }
        this.print((TreeSym)sym);
    }

    public final void print(SuperclassSym sym) {
        TypeSym superclass = sym.getTypeSym();
        if (superclass != null) {
            this.print(' ');
            if (this.preferences.getBoolean(26)) {
                this.println();
            }
            this.print((short)110, ' ');
            this.indent(1);
            this.handle(superclass);
        }
    }

    public final void print(InterfacesSym sym) {
        List things = sym.getSourceInterfaces();
        if (!things.isEmpty()) {
            ClassSym classSym;
            boolean isInterface = false;
            Sym parent = sym.getParentSym();
            if (parent != null && parent.symKind == 3 && (classSym = (ClassSym)parent).isInterface()) {
                isInterface = true;
            }
            this.print(' ');
            if (isInterface) {
                if (this.preferences.getBoolean(26)) {
                    this.println();
                }
                this.print((short)110, ' ');
            } else {
                if (this.preferences.getBoolean(27)) {
                    this.println();
                }
                this.print((short)117, ' ');
            }
            this.indent(1);
            this.markWrapAlignment();
            Iterator iterator = things.iterator();
            boolean needComma = false;
            while (iterator.hasNext()) {
                if (needComma) {
                    this.print((short)39);
                    this.markWrapBoundary(53);
                }
                this.handle((Sym)iterator.next());
                needComma = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(ClassBodySym sym) {
        boolean isAnonymous;
        int childCount = sym.treeChildren.length;
        if (childCount == 0) {
            ClassSym classSym = sym.getOwningClassSym();
            int blanklinesEmpty = classSym != null && classSym.isAnonymous() ? this.preferences.getInt(18) : this.preferences.getInt(17);
            this.print((short)49);
            this.ensureNewlines(blanklinesEmpty + 1);
        } else {
            this.println((short)49);
            int id = this.push();
            try {
                if (this.preferences.getBoolean(3)) {
                    this.indent(1);
                }
                this.ensureNewlines(this.preferences.getInt(11) + 1);
                Sym firstChild = sym.treeChildren[0];
                this.flag_firstchild = true;
                this.handle(firstChild);
                this.flag_firstchild = false;
                if (firstChild.symKind == 7) {
                    int nextEnum = sym.indexOf((byte)7, 1);
                    if (nextEnum == -1) {
                        this.println((short)75);
                    } else {
                        this.println((short)39);
                    }
                }
                for (int i = 1; i < childCount; ++i) {
                    Sym child = sym.treeChildren[i];
                    this.handle(child);
                    if (child.symKind != 7) continue;
                    int nextEnum = sym.indexOf((byte)7, i + 1);
                    if (nextEnum == -1) {
                        this.println((short)75);
                        continue;
                    }
                    this.println((short)39);
                }
                this.ensureNewlines(this.preferences.getInt(12) + 1);
            }
            finally {
                this.pop(id);
            }
        }
        this.print((short)70);
        ClassSym classSym = sym.getOwningClassSym();
        boolean bl = isAnonymous = classSym != null && classSym.isAnonymous();
        if (!isAnonymous) {
            this.ensureNewlines(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(FormalsSym sym) {
        this.print((short)55);
        int id = this.push();
        try {
            this.indent(1);
            List things = sym.getSourceParameters();
            if (!things.isEmpty()) {
                this.markWrapAlignment();
                Iterator iterator = things.iterator();
                boolean needComma = false;
                while (iterator.hasNext()) {
                    if (needComma) {
                        this.print((short)39);
                        this.markWrapBoundary(55);
                    }
                    this.handle((Sym)iterator.next());
                    needComma = true;
                }
            }
        }
        finally {
            this.pop(id);
        }
        this.print((short)72);
    }

    public final void print(ThrowsClauseSym sym) {
        List things = sym.getSourceExceptions();
        if (!things.isEmpty()) {
            if (this.preferences.getBoolean(28)) {
                this.println();
            } else {
                this.print(' ');
            }
            this.print((short)138, ' ');
            this.indent(1);
            this.markWrapAlignment();
            boolean needComma = false;
            Iterator iterator = things.iterator();
            while (iterator.hasNext()) {
                if (needComma) {
                    this.print((short)39);
                    this.markWrapBoundary(54);
                }
                this.handle((Sym)iterator.next());
                needComma = true;
            }
        }
    }

    public final void print(TypeParameterSym sym) {
        this.handle(sym.getNameSym());
        List things = sym.getSourceBounds();
        if (!things.isEmpty()) {
            this.print(' ');
            this.print((short)110, ' ');
            Iterator iterator = things.iterator();
            boolean needAnd = false;
            while (iterator.hasNext()) {
                if (needAnd) {
                    this.print(' ');
                    this.print((short)34, ' ');
                }
                this.handle((Sym)iterator.next());
                needAnd = true;
            }
        }
    }

    private void handleJavadoc(TreeSym sym) {
        this.handleJavadoc(sym, false);
    }

    private void handleJavadoc(TreeSym sym, boolean checkBlankline) {
        int blanklinesBeforeDocComment;
        DocCommentSym javadoc = sym.getJavadocSym();
        if (javadoc == null) {
            return;
        }
        if (checkBlankline && (blanklinesBeforeDocComment = this.preferences.getInt(13)) > 0) {
            this.ensureNewlines(blanklinesBeforeDocComment + 1);
        }
        this.checkIndent();
        this.handle(javadoc);
    }

    private void handleTypeParameters(MemberSym sym) {
        List things = sym.getSourceTypeParameters();
        if (!things.isEmpty()) {
            this.print((short)58);
            Iterator iterator = things.iterator();
            boolean needComma = false;
            while (iterator.hasNext()) {
                if (needComma) {
                    this.print((short)39);
                }
                this.handle((Sym)iterator.next());
                needComma = true;
            }
            this.print((short)46, ' ');
        }
    }

    private static boolean samePackage(String one, String two) {
        int lastDot1 = one.lastIndexOf(46);
        int lastDot2 = two.lastIndexOf(46);
        if (lastDot1 < 0 && lastDot2 < 0) {
            return true;
        }
        if (lastDot1 != lastDot2) {
            return false;
        }
        return one.regionMatches(0, two, 0, lastDot1);
    }

    private static int getSharedDotDepth(String one, String two) {
        int end2;
        int lastDot1 = one.lastIndexOf(46);
        int lastDot2 = two.lastIndexOf(46);
        int start1 = 0;
        int start2 = 0;
        int end1 = lastDot1;
        if (end1 < 0) {
            end1 = 0;
        }
        if ((end2 = lastDot2) < 0) {
            end2 = 0;
        }
        int depth = 0;
        while (start1 < end1 && start2 < end2) {
            int length2;
            int subend2;
            int subend1;
            int dot1 = one.indexOf(46, start1);
            if (end1 <= dot1) {
                dot1 = -1;
            }
            if ((subend1 = dot1) == -1) {
                subend1 = end1;
            }
            int length1 = subend1 - start1;
            int dot2 = two.indexOf(46, start2);
            if (end2 <= dot2) {
                dot2 = -1;
            }
            if ((subend2 = dot2) == -1) {
                subend2 = end2;
            }
            if (length1 != (length2 = subend2 - start2) || !one.regionMatches(start1, two, start2, length1)) break;
            ++depth;
            start1 = dot1 != -1 ? dot1 + 1 : end1;
            start2 = dot2 != -1 ? dot2 + 1 : end2;
        }
        return depth;
    }
}

