/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageC;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;

abstract class ContextImageD
extends ContextImageC
implements CallerContext.Constants {
    ContextImageD(CompilerDriver compiler, JavaClass caller) {
        super(compiler, caller);
    }

    ContextImageD(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    ContextImageD(CompilerContext other) {
        super(other);
    }

    protected final void listMembers(JavaType targetClass, InputImpl options, OutputImpl output) {
        if (targetClass == null) {
            return;
        }
        if ("<init>".equals(options.name)) {
            this.listMembersDeclared(targetClass, options, output);
            return;
        }
        output.processed().clear();
        this.listMembersRecursive(targetClass, options, output);
    }

    protected final void listNames(JavaPackage lhs, InputImpl options, OutputImpl output) {
        boolean addTypes = options.input((byte)4);
        boolean addPackages = options.input((byte)2);
        if (addTypes) {
            for (JavaHasName thing : lhs.getDeclaredClasses()) {
                this.processElement((JavaMember)thing, options, output);
            }
        }
        if (addPackages) {
            for (JavaHasName thing : lhs.getPackages()) {
                this.processElement(thing, options, output);
            }
        }
    }

    protected final void listNames(Sym scope, InputImpl options, OutputImpl output) {
        boolean addVariables = options.input((byte)8);
        boolean addTypes = options.input((byte)4);
        boolean addLabels = options.input((byte)16);
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 6: 
            case 19: {
                MethodSym methodSym = (MethodSym)scope;
                if (!addVariables) break;
                for (TreeSym thing : methodSym.getSourceParameters()) {
                    this.processElement((JavaHasName)((Object)thing), options, output);
                }
                break;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)scope;
                if (addVariables) {
                    for (TreeSym thing : blockSym.getLocalVariables()) {
                        this.processElement((JavaHasName)((Object)thing), options, output);
                    }
                }
                if (!addTypes) break;
                for (TreeSym thing : blockSym.getLocalClasses()) {
                    this.processElement((JavaHasName)((Object)thing), options, output);
                }
                break;
            }
            case 38: {
                ForStmt forStmt = (ForStmt)scope;
                if (!addVariables) break;
                for (TreeSym thing : forStmt.getForVariables()) {
                    this.processElement((JavaHasName)((Object)thing), options, output);
                }
                break;
            }
            case 31: {
                CatchStmt catchClause = (CatchStmt)scope;
                if (!addVariables) break;
                FormalParameterSym thing = catchClause.getCatchVariableSym();
                this.processElement(thing, options, output);
                break;
            }
            case 73: {
                PrimitiveType[] primitiveTypes;
                if (!addTypes) break;
                RootSym rootSym = (RootSym)scope;
                for (TreeSym thing : rootSym.getSourceClasses()) {
                    this.processElement((JavaHasName)((Object)thing), options, output);
                }
                this.listImports(options, output);
                for (PrimitiveType primitiveType : primitiveTypes = PrimitiveType.PRIMITIVE_objects) {
                    this.processElement(primitiveType, options, output);
                }
                break;
            }
            case 1: {
                Collection methods;
                boolean addAnnotations = options.input((byte)32);
                if (!addVariables || !addAnnotations || !this.flag_collect_annotation_element_names) break;
                this.flag_collect_annotation_element_names = false;
                AnnotateSym annotateSym = (AnnotateSym)scope;
                Map components = annotateSym.getComponents();
                JavaType javaType = annotateSym.getAnnotationType();
                if (javaType == null || (methods = javaType.getMethods()) == null) break;
                for (JavaMethod javaMethod : methods) {
                    if (!components.containsKey(javaMethod.getName())) continue;
                    QuickComponent annotationElement = QuickComponent.createComponent(javaMethod);
                    annotationElement.setOwner(annotateSym);
                    this.processElement(annotationElement, options, output);
                }
                break;
            }
        }
        if (addLabels) {
            if (28 <= scopeType && scopeType < 46) {
                List things = scope.getChildren(16);
                if (!things.isEmpty()) {
                    for (TreeSym thing : things) {
                        this.processElement((JavaHasName)((Object)thing), options, output);
                    }
                }
            } else if (scope.is((byte)79)) {
                options.input = (byte)(options.input & 0xFFFFFFEF);
            }
        }
    }

    private void listMembersRecursive(JavaType targetClass, InputImpl options, OutputImpl output) {
        if (targetClass == null) {
            return;
        }
        if (ContextImageD.classProcessed(output.processed(), targetClass)) {
            return;
        }
        this.listMembersDeclared(targetClass, options, output);
        JavaType baseClass = targetClass.getSuperclass();
        if (baseClass != null) {
            this.listMembersRecursive(baseClass, options, output);
        }
        for (JavaType baseInterface : targetClass.getInterfaces()) {
            this.listMembersRecursive(baseInterface, options, output);
        }
    }

    private void listMembersDeclared(JavaType targetClass, InputImpl options, OutputImpl output) {
        boolean addVariables = options.input((byte)8);
        boolean addTypes = options.input((byte)4);
        boolean addMethods = options.input((byte)1);
        if (addVariables) {
            for (JavaMember thing : targetClass.getDeclaredFields()) {
                this.processElement(thing, options, output);
            }
        }
        if (addTypes) {
            for (JavaMember thing : targetClass.getDeclaredClasses()) {
                if (!thing.isExported()) continue;
                this.processElement(thing, options, output);
            }
        }
        if (addMethods) {
            boolean isConstructor = "<init>".equals(options.name);
            Iterator things = isConstructor ? targetClass.getDeclaredConstructors().iterator() : targetClass.getDeclaredMethods().iterator();
            while (things.hasNext()) {
                JavaMethod thing = (JavaMethod)things.next();
                this.processElement(thing, options, output);
            }
        }
    }

    private final void listImports(InputImpl options, OutputImpl output) {
        if (options.squash((byte)1)) {
            return;
        }
        FileSym sourceFile = this.symCookie.symFile;
        List importSyms = sourceFile.getSourceImports();
        for (ImportSym importSym : importSyms) {
            if (!importSym.isNarrow() || importSym.isInvalid()) continue;
            this.processImportedNarrow(importSym, options, output);
        }
        String packageName = sourceFile.getPackageName();
        if (packageName.length() > 0) {
            this.processImportedPackage(packageName, options, output);
        }
        for (ImportSym importSym : importSyms) {
            if (importSym.isNarrow() || importSym.isInvalid()) continue;
            if (importSym.isStatic()) {
                this.processImportedMembers(importSym.getQualifyingType(), options, output);
                continue;
            }
            this.processImportedPackage(importSym.getName(), options, output);
        }
        this.processImportedPackage("java.lang.*", options, output);
    }

    private void processImportedNarrow(ImportSym importSym, InputImpl options, OutputImpl output) {
        JavaClass qualifying;
        String fqname = importSym.getName();
        int lastDot = fqname.lastIndexOf(46);
        String importedName = lastDot == -1 ? fqname : fqname.substring(lastDot + 1);
        if (options.name != null && !options.name.equals(importedName)) {
            return;
        }
        if (importSym.isStatic() && (qualifying = importSym.getQualifyingType()) != null) {
            JavaField thing;
            Collection things;
            if (options.input((byte)1) && !(things = qualifying.getMethods(importedName)).isEmpty()) {
                for (JavaMember thing2 : things) {
                    this.processElement(thing2, options, output);
                }
            }
            if (options.input((byte)8) && (thing = qualifying.getField(importedName)) != null) {
                this.processElement(thing, options, output);
            }
        }
        if (options.input((byte)4)) {
            JavaClass result;
            if (options.input((byte)-128) && !importSym.isStatic() && lastDot > 0) {
                String packageName = fqname.substring(0, lastDot);
                this.processImportedPackage(packageName, options, output);
            }
            if ((result = this.compiler.provider.getClass(fqname)) != null) {
                this.processElement(result, options, output);
            }
        }
    }

    private void processImportedPackage(String nameDotStar, InputImpl options, OutputImpl output) {
        if (options.input((byte)4)) {
            String name = nameDotStar.endsWith(".*") ? nameDotStar.substring(0, nameDotStar.length() - 2) : nameDotStar;
            if (output.containsKey(name)) {
                return;
            }
            output.keys().add(name);
            JavaPackage p = this.compiler.provider.getPackage(name);
            Collection things = p.getDeclaredClasses();
            if (!things.isEmpty()) {
                for (JavaType thing : things) {
                    this.processElement(thing, options, output);
                }
            }
        }
    }

    private void processImportedMembers(JavaType qualifying, InputImpl options, OutputImpl output) {
        Collection things;
        if (qualifying == null) {
            return;
        }
        if (options.input((byte)1) && !(things = qualifying.getMethods()).isEmpty()) {
            for (JavaMember thing : things) {
                this.processElement(thing, options, output);
            }
        }
        if (options.input((byte)8) && !(things = qualifying.getFields()).isEmpty()) {
            for (JavaMember thing : things) {
                this.processElement(thing, options, output);
            }
        }
        if (options.input((byte)4) && !(things = qualifying.getClasses()).isEmpty()) {
            for (JavaMember thing : things) {
                this.processElement(thing, options, output);
            }
        }
    }

    private void processElement(JavaHasName thing, InputImpl options, OutputImpl output) {
        String key;
        if (options.input((byte)64)) {
            this.processEnumConstants(thing, options, output);
        }
        if (output.containsKey(key = thing.getName())) {
            return;
        }
        if (!this.checkFilter(thing, options)) {
            return;
        }
        if (this.allowAccess(thing)) {
            output.add(key, thing);
        } else {
            output.add(key, null);
        }
    }

    private void processEnumConstants(JavaHasName thing, InputImpl options, OutputImpl output) {
        if (thing instanceof JavaClass && ((JavaClass)thing).isEnum()) {
            for (JavaField javaField : ((JavaClass)thing).getDeclaredFields()) {
                if (!javaField.isEnumConstant()) continue;
                this.processElement(javaField, options, output);
            }
        }
    }

    private void processElement(JavaMethod thing, InputImpl options, OutputImpl output) {
        String key = thing.getName() + thing.getSignature();
        if (!options.match(thing) || output.containsKey(key)) {
            return;
        }
        if (!this.processVisible(thing) || !this.checkFilter(thing, options)) {
            return;
        }
        if (this.allowAccess(thing)) {
            output.add(key, thing);
        } else {
            output.add(key, null);
        }
    }

    private void processElement(JavaMember thing, InputImpl options, OutputImpl output) {
        if (options.input((byte)64)) {
            this.processEnumConstants(thing, options, output);
        }
        String key = thing.getName();
        if (!options.match(thing) || output.containsKey(key)) {
            return;
        }
        if (!this.processVisible(thing) || !this.checkFilter(thing, options)) {
            return;
        }
        if (this.allowAccess(thing)) {
            output.add(key, thing);
        } else {
            output.add(key, null);
        }
    }

    private boolean checkFilter(JavaMember thing, InputImpl options) {
        JavaClass javaClass;
        if (!this.flag_static && options.squash((byte)4) && (thing.getElementKind() == 3 || thing.isStatic())) {
            return false;
        }
        if (options.squash((byte)16) && thing.isDeprecated()) {
            return false;
        }
        if (options.squash((byte)32) && thing.isHidden()) {
            return false;
        }
        if (options.squash((byte)8) && (javaClass = thing.getOwningClass()) != null && "java.lang.Object".equals(javaClass.getQualifiedName())) {
            return false;
        }
        return this.checkFilter((JavaElement)thing, options);
    }

    private boolean checkFilter(JavaElement thing, InputImpl options) {
        return options.filter == null || options.filter.accepts(thing);
    }
}

