/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageB;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class ContextImageC
extends ContextImageB {
    ContextImageC(CompilerDriver compiler, JavaClass caller) {
        super(compiler, caller);
    }

    ContextImageC(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    ContextImageC(CompilerContext other) {
        super(other);
    }

    protected final JavaType findType(Sym scope, String name) {
        if (scope == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        TreeSym treeSym = (TreeSym)scope;
        return this.lookupType(treeSym, name);
    }

    protected final JavaVariable findVariable(Sym scope, String name, boolean useStrict) {
        if (scope == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        TreeSym treeSym = (TreeSym)scope;
        return this.lookupVariable(treeSym, name, useStrict);
    }

    protected final JavaClass findMemberType(JavaType targetClass, String name) {
        if (targetClass == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.lookupMemberType(targetClass, name);
    }

    protected final JavaVariable findMemberVariable(JavaType targetClass, String name) {
        if (targetClass == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.lookupMemberVariable(targetClass, name);
    }

    protected final JavaVariable findImportedVariable(String name) {
        this.flag_instance = false;
        return this.lookupImportedVariable(name);
    }

    protected final boolean findVisibleType(JavaType targetClass, String name) {
        if (targetClass == null) {
            return false;
        }
        JavaClass inner = targetClass.getDeclaredClass(name);
        if (inner != null && inner.isExported()) {
            return true;
        }
        for (JavaType type : targetClass.getHierarchy()) {
            inner = type.getDeclaredClass(name);
            if (inner == null || !inner.isExported() || !this.processVisible(inner)) continue;
            return true;
        }
        return false;
    }

    protected final boolean findVisibleVariable(JavaType targetClass, String name) {
        if (targetClass == null) {
            return false;
        }
        JavaField member = targetClass.getDeclaredField(name);
        if (member != null) {
            return true;
        }
        for (JavaType type : targetClass.getHierarchy()) {
            JavaField thing = type.getDeclaredField(name);
            if (thing == null || !this.processVisible(thing)) continue;
            return true;
        }
        return false;
    }

    private JavaType lookupType(TreeSym scope, String name) {
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 3: 
            case 6: 
            case 19: {
                ClassSym classSym;
                Iterator iterator = scope.getChildren((byte)26).iterator();
                TypeParameterSym lastFound = null;
                while (iterator.hasNext()) {
                    TypeParameterSym parameterSym = (TypeParameterSym)iterator.next();
                    if (!name.equals(parameterSym.getName())) continue;
                    if (lastFound != null) {
                        this.error((short)35, name);
                    }
                    lastFound = parameterSym;
                }
                if (scopeType == 3 && name.equals((classSym = (ClassSym)scope).getName())) {
                    return classSym;
                }
                return lastFound;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)scope;
                Iterator iterator = blockSym.getLocalClasses().iterator();
                int start = this.symCookie.symStart;
                boolean inScope = false;
                ClassSym lastFound = null;
                while (iterator.hasNext()) {
                    ClassSym classSym = (ClassSym)iterator.next();
                    if (!name.equals(classSym.getName())) continue;
                    if (lastFound != null && inScope) {
                        this.error((short)35, name);
                    }
                    inScope = start == -1 || start < classSym.symStart;
                    lastFound = classSym;
                }
                if (lastFound != null && start != -1 && start < lastFound.symStart) {
                    return null;
                }
                return lastFound;
            }
            case 73: {
                Iterator iterator = scope.getChildren((byte)3).iterator();
                ClassSym lastFound = null;
                while (iterator.hasNext()) {
                    ClassSym classSym = (ClassSym)iterator.next();
                    if (!name.equals(classSym.getName())) continue;
                    if (lastFound != null) {
                        this.error((short)35, name);
                    }
                    lastFound = classSym;
                }
                return lastFound;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaClass lookupMemberType(JavaType targetClass, String name) {
        ArrayList processed = ContextImageC.allocArrayList();
        try {
            JavaClass result;
            JavaClass javaClass = result = (JavaClass)this.findRecursive(targetClass, name, processed, true);
            return javaClass;
        }
        finally {
            ContextImageC.freeArrayList(processed);
        }
    }

    private boolean matchVariable(VariableSym sym, String name, boolean useStrict) {
        if (sym == null || !name.equals(sym.getName())) {
            return false;
        }
        if (useStrict) {
            if (!this.allowAccess(sym)) {
                return false;
            }
            return this.flag_nonfinal || sym.isFinal();
        }
        return true;
    }

    private JavaVariable lookupVariable(TreeSym scope, String name, boolean useStrict) {
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 6: 
            case 19: {
                MethodSym methodSym = (MethodSym)scope;
                for (FormalParameterSym variableSym : methodSym.getSourceParameters()) {
                    if (!this.matchVariable(variableSym, name, useStrict)) continue;
                    return variableSym;
                }
                return null;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)scope;
                Iterator iterator = blockSym.getLocalVariables().iterator();
                int start = this.symCookie.symStart;
                boolean inScope = false;
                LocalVariableSym lastFound = null;
                while (iterator.hasNext()) {
                    LocalVariableSym variableSym = (LocalVariableSym)iterator.next();
                    if (!this.matchVariable(variableSym, name, useStrict)) continue;
                    if (lastFound != null && inScope) {
                        this.error((short)35, name);
                    }
                    inScope = start < variableSym.symStart;
                    lastFound = variableSym;
                }
                if (lastFound != null && start != -1 && start < lastFound.symStart) {
                    return null;
                }
                return lastFound;
            }
            case 1: {
                AnnotateSym annotateSym = (AnnotateSym)scope;
                JavaType annotationType = annotateSym.getAnnotationType();
                if (annotationType == null) {
                    return null;
                }
                JavaMethod method = annotationType.getMethod(name, null);
                if (method == null) {
                    return null;
                }
                QuickComponent qc = QuickComponent.createComponent(method);
                qc.setOwner(annotateSym);
                return qc;
            }
            case 17: {
                LocalVariableSym variableSym = (LocalVariableSym)scope;
                if (this.matchVariable(variableSym, name, useStrict)) {
                    // empty if block
                }
                return null;
            }
            case 38: {
                ForStmt forStmt = (ForStmt)scope;
                for (LocalVariableSym variableSym : forStmt.getForVariables()) {
                    if (!this.matchVariable(variableSym, name, useStrict)) continue;
                    return variableSym;
                }
                return null;
            }
            case 31: {
                CatchStmt catchClause = (CatchStmt)scope;
                FormalParameterSym variableSym = catchClause.getCatchVariableSym();
                if (this.matchVariable(variableSym, name, useStrict)) {
                    return variableSym;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaVariable lookupMemberVariable(JavaType targetClass, String name) {
        ArrayList processed = ContextImageC.allocArrayList();
        try {
            JavaVariable result;
            JavaVariable javaVariable = result = (JavaVariable)((Object)this.findRecursive(targetClass, name, processed, false));
            return javaVariable;
        }
        finally {
            ContextImageC.freeArrayList(processed);
        }
    }

    private JavaMember findRecursive(JavaType targetClass, String targetName, ArrayList processed, boolean isType) {
        if (targetClass == null) {
            return null;
        }
        if (ContextImageC.classProcessed(processed, targetClass)) {
            return null;
        }
        JavaMember declared = this.findDeclared(targetClass, targetName, isType);
        if (declared != null) {
            return declared;
        }
        JavaMember alreadyFound = null;
        JavaType baseClass = targetClass.getSuperclass();
        if (baseClass != null) {
            alreadyFound = this.findRecursive(baseClass, targetName, processed, isType);
        }
        for (JavaType baseInterface : targetClass.getInterfaces()) {
            JavaMember found = this.findRecursive(baseInterface, targetName, processed, isType);
            if (found == null) continue;
            if (alreadyFound != null) {
                this.error((short)35);
            }
            alreadyFound = found;
        }
        return alreadyFound;
    }

    private JavaMember findDeclared(JavaType targetClass, String targetName, boolean isType) {
        if (isType) {
            JavaClass inner = targetClass.getDeclaredClass(targetName);
            if (inner != null && inner.isExported() && this.processVisible(inner)) {
                return inner;
            }
        } else {
            JavaField field = targetClass.getDeclaredField(targetName);
            if (field != null && this.processVisible(field)) {
                return field;
            }
        }
        return null;
    }

    private JavaVariable lookupImportedVariable(String name) {
        FileSym sourceFile = this.symCookie.symFile;
        if (sourceFile == null) {
            return null;
        }
        List<ImportSym> staticImportList = this.getValidStaticImports(sourceFile);
        if (staticImportList.size() == 0) {
            return null;
        }
        for (ImportSym importSym : staticImportList) {
            String fqname;
            int lastDot;
            String importedName;
            if (!importSym.isNarrow() || !(importedName = (lastDot = (fqname = importSym.getName()).lastIndexOf(46)) == -1 ? fqname : fqname.substring(lastDot + 1)).equals(name)) continue;
            importSym.resolve();
            JavaClass qualifying = importSym.getQualifyingType();
            if (qualifying == null || !this.findVisibleVariable(qualifying, name)) continue;
            JavaVariable found = this.findMemberVariable(qualifying, name);
            if (found != null) {
                importSym.setUsed();
                ArrayList importList = importSym.getImportObj().importList;
                if (importList != null && !importList.contains(found)) {
                    importList.add(found);
                }
            }
            return found;
        }
        HashSet<String> importKeys = new HashSet<String>();
        for (ImportSym importSym : staticImportList) {
            String importName;
            if (importSym.isNarrow() || importKeys.contains(importName = importSym.getName())) continue;
            importKeys.add(importName);
            importSym.resolve();
            JavaClass qualifying = importSym.getQualifyingType();
            if (qualifying == null || !this.findVisibleVariable(qualifying, name)) continue;
            JavaVariable found = this.findMemberVariable(qualifying, name);
            if (found != null) {
                importSym.setUsed();
                ArrayList importList = importSym.getImportObj().importList;
                if (importList != null && !importList.contains(found)) {
                    importList.add(found);
                }
            }
            return found;
        }
        return null;
    }
}

