/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer5j;
import oracle.javatools.parser.java.v2.internal.compiler.ImportObj;
import oracle.javatools.parser.java.v2.internal.compiler.TypeVariableObj;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.InitializerSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;

abstract class CompilerLayer5
extends CompilerLayer5j {
    CompilerLayer5() {
    }

    public final void resolve(RootSym rootSym) {
        if (this.inUsageMode()) {
            return;
        }
        HashSet<String> importNames = new HashSet<String>();
        importNames.add("java.lang.*");
        List importSyms = rootSym.getSourceImports();
        HashMap<String, ImportSym> narrowNames = new HashMap<String, ImportSym>(importSyms.size());
        for (ImportSym importSym : importSyms) {
            String name = importSym.getName();
            if (importNames.contains(name)) {
                importSym.setInvalid();
            }
            importNames.add(name);
            if (!importSym.isNarrow()) continue;
            int lastDot = name.lastIndexOf(46);
            String lastname = name.substring(lastDot + 1);
            ImportSym foundImport = (ImportSym)narrowNames.get(lastname);
            if (foundImport != null) {
                if (!foundImport.isInvalid()) {
                    foundImport.setInvalid();
                    this.error(foundImport, (short)34, name);
                }
                importSym.setInvalid();
                this.error(importSym, (short)34, name);
            }
            narrowNames.put(lastname, foundImport);
        }
    }

    public final void compile(RootSym rootSym) {
        if (this.inUsageMode()) {
            return;
        }
        List importSyms = rootSym.getSourceImports();
        for (ImportSym importSym : importSyms) {
            if (importSym.isInvalid()) continue;
            ImportObj importObj = importSym.getImportObj();
            if (importSym.isUsed()) {
                int size;
                if (importObj.importList == null) continue;
                if (importObj.importResults != null) {
                    CompilerLayer5.panic(importSym);
                }
                importObj.importResults = (size = importObj.importList.size()) == 0 ? JavaHasType.EMPTY_ARRAY : importObj.importList.toArray(new JavaHasType[size]);
                importObj.importList = null;
                continue;
            }
            this.error(importSym, (short)71);
        }
    }

    public final void resolve(ImportSym importSym) {
        boolean errorFound;
        ImportObj importObj = importSym.getImportObj();
        if (importObj.flag_resolved) {
            return;
        }
        if (importSym.isInvalid()) {
            return;
        }
        String name = importSym.getName();
        if (name.length() == 0) {
            return;
        }
        if (importSym.isStatic()) {
            String qualifier;
            JavaClass qualifyingType;
            errorFound = true;
            int lastDot = name.lastIndexOf(46);
            if (lastDot != -1 && (qualifyingType = this.provider.getClass(qualifier = name.substring(0, lastDot))) != null) {
                importObj.importQualifyingType = qualifyingType;
                errorFound = false;
            }
        } else {
            errorFound = false;
            if (importSym.isNarrow()) {
                JavaClass result = this.provider.getClass(name);
                if (result != null) {
                    this.recordUsage(importSym, result);
                    importObj.importResults = new JavaHasType[]{result};
                } else {
                    errorFound = true;
                }
            }
        }
        if (errorFound) {
            importSym.setInvalid();
            importObj.importResults = JavaHasType.EMPTY_ARRAY;
            this.error(importSym, (short)48, name);
        }
        if (!importSym.isInvalid() && importObj.importResults == null) {
            importObj.importList.clear();
        } else {
            importObj.importList = null;
        }
        importObj.flag_resolved = true;
    }

    public final JavaClass resolve(ClassSym classSym) {
        ClassObj classObj = classSym.getClassObj();
        if (classObj.flag_resolved) {
            return classSym;
        }
        JavaType superclass = null;
        TypeSym tySuper = classSym.tySuper;
        if (tySuper != null) {
            tySuper.resolve((CompilerDriver)this);
            JavaType resolved = tySuper.getResolvedType();
            if (resolved != null) {
                JavaClass resolvedClass;
                if (resolved.getElementKind() != 3) {
                    this.error(tySuper, (short)45);
                }
                if (!(resolvedClass = (JavaClass)resolved).isInterface()) {
                    superclass = resolvedClass;
                }
            }
        }
        if (superclass == null) {
            superclass = this.resolveSuperclass(classSym);
        }
        classObj.typeSuperclass = superclass;
        for (TypeSym sym : classSym.getSourceInterfaces()) {
            sym.resolve((CompilerDriver)this);
        }
        if (this.needsClinitMethod(classSym)) {
            classObj.classClinit = QuickMethod.createMethod(classSym, '\b', null, "<clinit>", null, null);
        }
        classObj.typeHierarchy = null;
        classObj.flag_resolved = true;
        return classSym;
    }

    public final void compile(ClassSym classSym) {
        this.recordDefine(classSym);
    }

    public final JavaTypeVariable resolve(TypeParameterSym parameterSym) {
        TypeVariableObj typeObj = parameterSym.getTypeVariableObj();
        if (typeObj.flag_resolved) {
            return parameterSym;
        }
        this.resolveBounds(parameterSym);
        typeObj.typeHierarchy = null;
        this.recordDefine(parameterSym);
        parameterSym.setProcessed();
        typeObj.flag_resolved = true;
        return parameterSym;
    }

    public final JavaTypeVariable compile(TypeParameterSym parameterSym) {
        TypeVariableObj typeObj = parameterSym.getTypeVariableObj();
        if (!typeObj.flag_resolved) {
            this.resolve(parameterSym);
        }
        if (typeObj.flag_compiled) {
            return parameterSym;
        }
        typeObj.flag_compiled = true;
        return parameterSym;
    }

    public final JavaElement resolve(FormalsSym sym) {
        if (!this.inUsageMode() && sym.getChild((byte)13) != null) {
            this.processDuplicates(sym.getChildren((byte)13));
        }
        return null;
    }

    public final JavaElement resolve(ClassBodySym sym) {
        if (!this.inUsageMode()) {
            this.processDuplicates(sym.getSourceFieldVariables());
            this.processMethodDuplicates(sym.getSourceMethods());
            this.processMethodDuplicates(sym.getSourceConstructors());
        }
        return null;
    }

    public final JavaMethod resolve(MethodSym sym) {
        boolean canOmitBodies;
        if (sym.isProcessed()) {
            return sym;
        }
        boolean bl = canOmitBodies = (sym.getModifiers() & 0x500) != 0;
        if (!canOmitBodies && sym.getBlock() == null) {
            Sym cookie = sym;
            NameSym nameSym = sym.getNameSym();
            if (nameSym != null) {
                cookie = nameSym;
            }
            this.error(cookie, (short)74);
        }
        this.recordDefine(sym);
        sym.setProcessed();
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaField resolve(EnumConstantSym sym) {
        JavaMethod result;
        ListExpr argumentsSym;
        if (sym.isProcessed()) {
            return sym;
        }
        this.recordDefine(sym);
        String name = sym.getName();
        if (name != null && name.length() > 0) {
            block3: for (Sym parentSym = sym.getParentSym(); parentSym != null; parentSym = parentSym.getParentSym()) {
                if (!(parentSym instanceof ClassBodySym)) continue;
                ClassBodySym classBodySym = (ClassBodySym)parentSym;
                List enums = classBodySym.getSourceEnumConstants();
                for (EnumConstantSym otherEnum : enums) {
                    if (otherEnum == sym || !otherEnum.isProcessed() || !name.equals(otherEnum.getName())) continue;
                    this.error(sym, (short)46, name, otherEnum);
                    break block3;
                }
                break;
            }
        }
        JavaType[] arguments = (argumentsSym = sym.getArgumentsSym()) != null ? this.processArguments(argumentsSym, null) : new JavaType[]{};
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(sym);
            result = this.context.findMethod(sym.getResolvedType(), "<init>", arguments);
        }
        finally {
            this.context = savedContext;
        }
        if (result == null) {
            JavaElement owner;
            String errorName = name;
            for (owner = sym.getOwner(); owner != null; owner = owner.getOwner()) {
                if (!(owner instanceof ClassSym)) continue;
                errorName = ((ClassSym)owner).getName();
                break;
            }
            this.error(sym, (short)54, errorName, arguments, owner != null ? owner : sym);
        } else {
            sym.setResolvedConstructor(result);
        }
        sym.setProcessed();
        return sym;
    }

    private JavaType resolveSuperclass(ClassSym classSym) {
        if ("java.lang.Object".equals(classSym.getQualifiedName())) {
            return null;
        }
        JavaType superclass = null;
        switch (classSym.getTypeKind()) {
            case 2: {
                JavaType[] bounds;
                JavaClass enumType = this.provider.getClassByVMName("java/lang/Enum");
                if (enumType == null || (superclass = CommonUtilities.createParameterizedType(this.provider, enumType, bounds = new JavaType[]{classSym})) != null) break;
                superclass = enumType;
                break;
            }
            case 1: {
                superclass = this.getPreloadedClass((byte)4);
                break;
            }
            case 3: {
                superclass = this.getSystemClass("java/lang/annotation/Annotation");
            }
        }
        if (superclass == null) {
            Sym parentSym;
            JavaType type;
            TypeSym typeSym = (TypeSym)classSym.getSourceSuperclass();
            if (typeSym != null && (type = (JavaType)typeSym.resolve((CompilerDriver)this)) != null) {
                return type;
            }
            if (classSym.isAnonymous() && (parentSym = classSym.getParentSym()) != null && parentSym.symKind == 7) {
                superclass = classSym.getOwningClassSym();
            }
            if (superclass == null) {
                superclass = this.getPreloadedClass((byte)4);
            }
        }
        if (superclass != null) {
            this.recordUsage(classSym, superclass);
        }
        return superclass;
    }

    private void resolveBounds(TypeParameterSym parameterSym) {
        TypeVariableObj obj = parameterSym.getTypeVariableObj();
        obj.typeSuperclass = null;
        obj.typeInterfaces = kEmptyCollection;
        TypeSym firstBound = parameterSym.getFirstBoundSym();
        if (firstBound != null) {
            List bounds = parameterSym.getSourceBounds();
            if (bounds.size() == 1) {
                JavaType type = firstBound.getResolvedType();
                if (type != null) {
                    if (((Object)type).equals(parameterSym)) {
                        this.error(firstBound, (short)44);
                    } else if (!type.isInterface()) {
                        obj.typeSuperclass = type;
                    } else {
                        obj.typeInterfaces = Arrays.asList(type);
                    }
                }
            } else {
                JavaType firstType;
                ArrayList list = new ArrayList();
                list.addAll(parameterSym.getObjects((byte)27));
                if (!list.isEmpty() && !(firstType = (JavaType)list.get(0)).isInterface()) {
                    obj.typeSuperclass = firstType;
                    list.remove(0);
                }
                obj.typeInterfaces = list;
            }
        }
        if (obj.typeSuperclass == null) {
            obj.typeSuperclass = this.getPreloadedClass((byte)4);
        }
    }

    private boolean needsClinitMethod(ClassSym classSym) {
        if (!classSym.getSourceEnumConstants().isEmpty()) {
            return true;
        }
        for (FieldSym field : classSym.getSourceFieldVariables()) {
            if (!field.isStatic() || field.getInitializer() == null) continue;
            return true;
        }
        for (InitializerSym initializer : classSym.getSourceInitializers()) {
            if (!initializer.isStatic()) continue;
            return true;
        }
        return false;
    }
}

