/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.List;
import oracle.javatools.parser.java.v2.common.CastedMethod;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3a;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InvokeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;

abstract class CompilerLayer3b
extends CompilerLayer3a {
    CompilerLayer3b() {
    }

    public final JavaHasType resolve(Expr e) {
        CompilerLayer3b.panic(e);
        return null;
    }

    public final JavaHasType resolve(SimpleNameExpr e) {
        boolean ambiguous = !e.flag_lvalue();
        return this.resolveName(e, null, ambiguous);
    }

    public final JavaHasType resolve(DotExpr e) {
        Expr lhsSym;
        boolean ambiguous = !e.flag_lvalue();
        JavaHasType lhs = this.processLhsOperand(e);
        if (lhs == kEmptyResult && ambiguous && (lhsSym = e.getLhsOperandSym()) != null && lhsSym.flag_maybePackage()) {
            String searchString = e.getQualifiedName();
            JavaType found = this.resolveType(e, searchString);
            if (found != null) {
                this.recordUsage(e, found);
                return found;
            }
            if (!e.flag_maybePackage()) {
                this.error(e, (short)56, searchString);
            }
            return null;
        }
        return this.resolveName(e, lhs, ambiguous);
    }

    public final JavaHasType resolve(MethodCallExpr e) {
        JavaMethod method;
        this.checkCancel();
        JavaHasType lhs = this.processLhsOperand(e);
        String name = e.getName();
        if (name.length() == 0) {
            return (JavaMethod)this.error(e, (short)50);
        }
        if ("this".equals(name) || "super".equals(name)) {
            method = this.resolveExplicitConstructor(e, lhs, name);
            if (method == null) {
                return null;
            }
        } else {
            JavaType lhsType;
            JavaType[] resolvedTypeArguments;
            JavaType[] arguments;
            JavaType[] typeArguments = this.processTypeArguments(e);
            method = this.resolveMethodCall(e, lhs, typeArguments, arguments = this.processArguments(e), false);
            if (method == null) {
                return null;
            }
            if (typeArguments != null && (resolvedTypeArguments = this.resolveTypeArguments(method, e.getTypeArguments())) != null) {
                method = CommonUtilities.createParameterizedMethod(this.provider, method, resolvedTypeArguments);
                this.checkTypeArguments(method);
            }
            if ("clone".equals(method.getName()) && (lhsType = lhs != null ? lhs.getResolvedType() : null) != null && lhsType.isArray()) {
                method = CastedMethod.newInstance(method, lhsType);
            }
        }
        this.resolveExceptions(e, method);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaHasType resolve(ClassCreatorExpr e) {
        ClassSym anonymous;
        JavaType targetType;
        JavaHasType lhs = this.processLhsOperand(e);
        TypeSym typeSym = e.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        if (lhs == null) {
            targetType = (JavaType)typeSym.resolve((CompilerDriver)this);
            if (targetType == null) {
                return null;
            }
            JavaType outerClass = CompilerLayer3b.getOuterClassOfNonstaticInner(targetType);
            if (outerClass != null && (lhs = this.resolveEnclosingScope(e, outerClass)) == null) {
                this.error(e, (short)66, outerClass);
                return targetType.getThisValue();
            }
        } else {
            String name = typeSym.getName();
            if (name.length() == 0) {
                return (JavaHasType)this.error(e, (short)50);
            }
            if (lhs == kEmptyResult) {
                return null;
            }
            CompilerContext savedContext = this.context;
            try {
                this.context = this.newContext(e);
                targetType = this.processInnerCreatorType(e, lhs, name);
            }
            finally {
                this.context = savedContext;
            }
            if (targetType == null) {
                return null;
            }
        }
        JavaType lhsType = null;
        if (lhs != null) {
            lhsType = lhs.getResolvedType();
        }
        if ((anonymous = e.getClassSym()) != null && targetType.isInterface() && e.getArgumentCount() == 0) {
            return targetType.getThisValue();
        }
        JavaType[] typeArguments = this.processTypeArguments(e);
        JavaType[] arguments = this.processArguments(e, lhsType);
        CompilerContext savedContext = this.context;
        try {
            JavaType[] resolvedTypeArguments;
            JavaMethod method;
            if (anonymous != null) {
                this.context = this.newContext(anonymous.getBodySym());
            }
            if (anonymous == null && targetType.isAbstract()) {
                this.error(e, (short)33);
            }
            if ((method = this.resolveMethodCall(e, targetType, typeArguments, arguments)) == null) {
                CompiledTmpVariable compiledTmpVariable = targetType.getThisValue();
                return compiledTmpVariable;
            }
            if (typeArguments != null && (resolvedTypeArguments = this.resolveTypeArguments(method, e.getTypeArguments())) != null) {
                method = CommonUtilities.createParameterizedMethod(this.provider, method, resolvedTypeArguments);
                this.checkTypeArguments(method);
            }
            this.resolveExceptions(e, method);
            CastedMethod castedMethod = anonymous != null ? CastedMethod.newInstance(method, anonymous) : CastedMethod.newInstance(method, targetType);
            CastedMethod castedMethod2 = castedMethod;
            return castedMethod2;
        }
        finally {
            this.context = savedContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMethod resolveExplicitConstructor(MethodCallExpr e, JavaHasType lhs, String name) {
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(e);
            JavaMethod javaMethod = this.processExplicitConstructor(e, lhs, name);
            return javaMethod;
        }
        finally {
            this.context = savedContext;
        }
    }

    private JavaHasType processLhsOperand(Expr e) {
        Expr lhs = (Expr)e.getLhsOperand();
        if (lhs == null) {
            return null;
        }
        JavaHasType result = (JavaHasType)lhs.resolve((CompilerDriver)this);
        if (result != null) {
            return result;
        }
        return kEmptyResult;
    }

    private JavaType[] processArguments(Expr e) {
        return this.processArguments(e, null);
    }

    private JavaType[] processArguments(Expr e, JavaType firstArgument) {
        return this.processArguments((ListExpr)e.getChild((byte)51), firstArgument);
    }

    protected JavaType[] processArguments(ListExpr list, JavaType firstArgument) {
        int opc = list.getOperandCount();
        if (opc == 0) {
            if (firstArgument == null) {
                return JavaType.EMPTY_ARRAY;
            }
            JavaType[] out = new JavaType[]{firstArgument};
            return out;
        }
        if (firstArgument != null) {
            ++opc;
        }
        JavaType[] out = new JavaType[opc];
        int i = 0;
        if (firstArgument != null) {
            out[0] = firstArgument;
            ++i;
        }
        for (Expr operand : list.getOperands()) {
            out[i++] = this.processExpressionType(operand, false);
        }
        return out;
    }

    private JavaMethod processExplicitConstructor(MethodCallExpr e, JavaHasType lhs, String name) {
        JavaType outerClass;
        JavaHasType thisSuper = this.resolveName(e, lhs, name, true);
        if (thisSuper == null) {
            return (JavaMethod)this.error(e, (short)54, name, JavaType.EMPTY_ARRAY);
        }
        JavaType targetType = thisSuper.getResolvedType();
        if (targetType == null) {
            return (JavaMethod)this.error(e, (short)54, name, JavaType.EMPTY_ARRAY);
        }
        if (lhs == null && (outerClass = CompilerLayer3b.getOuterClassOfNonstaticInner(targetType)) != null) {
            ClassSym enclosingClass = e.getOwningClassSym();
            if (enclosingClass != null) {
                lhs = this.resolveEnclosingScope(enclosingClass, outerClass);
            }
            if (lhs == null) {
                this.error(e, (short)66, outerClass);
                return null;
            }
        }
        JavaType lhsType = null;
        if (lhs != null) {
            lhsType = lhs.getResolvedType();
        }
        JavaType[] arguments = this.processArguments(e, lhsType);
        JavaMethod method = this.resolveMethodCall(e, targetType, null, arguments, true);
        this.resolveExceptions(e, method);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaType[] processTypeArguments(InvokeExpr e) {
        List typeArguments = e.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return null;
        }
        CompilerContext savedContext = this.context;
        this.context = this.newContext(e);
        try {
            JavaType[] array = new JavaType[typeArguments.size()];
            int i = 0;
            for (TypeArgumentSym sym : typeArguments) {
                array[i++] = sym.getResolvedType();
            }
            JavaType[] javaTypeArray = array;
            return javaTypeArray;
        }
        finally {
            this.context = savedContext;
        }
    }

    @Override
    protected final JavaType processInnerCreatorType(Expr lhsExpr, String name) {
        JavaHasType lhs = this.processExpression(lhsExpr);
        if (lhs == null) {
            return null;
        }
        return this.processInnerCreatorType(lhsExpr, lhs, name);
    }

    protected final JavaType processInnerCreatorType(Sym cookie, JavaHasType lhs, String name) {
        if (lhs instanceof JavaType) {
            this.error(cookie, (short)65, lhs);
            return null;
        }
        JavaType owningType = lhs.getResolvedType();
        if (owningType == null) {
            return null;
        }
        return this.context.findMemberType(owningType, name);
    }
}

