/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;

public final class CallerContextImpl
extends CallerContext
implements JavaConstants,
CallerContext.Constants {
    public final Sym scopeCookie;
    public final CompilerDriver compiler;

    @Override
    public SourceElement getSourceScope() {
        return this.scopeCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType resolveTypeName(String name) {
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveType(this.scopeCookie, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType resolveTypeName(JavaHasType lhs, String name) {
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            if (lhs == null) {
                return null;
            }
            return this.compiler.resolveType(this.scopeCookie, lhs.getResolvedType(), name);
        }
    }

    @Override
    public JavaHasType resolveExpressionName(String name) {
        return this.resolveName(null, name, false);
    }

    @Override
    public JavaHasType resolveExpressionName(JavaHasType lhs, String name) {
        return this.resolveName(lhs, name, false);
    }

    @Override
    public JavaHasType resolveAmbiguousName(String name) {
        return this.resolveName(null, name, true);
    }

    @Override
    public JavaHasType resolveAmbiguousName(JavaHasType lhs, String name) {
        return this.resolveName(lhs, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaHasType resolveName(JavaHasType lhs, String name, boolean ambiguous) {
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveName(this.scopeCookie, lhs, name, ambiguous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaMethod resolveMethod(JavaHasType lhs, String name, JavaType[] typeArguments, JavaType[] arguments) {
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        if (arguments == null) {
            arguments = JavaType.EMPTY_ARRAY;
        }
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveMethodCall(this.scopeCookie, name, lhs, typeArguments, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaMethod resolveConstructor(JavaType target, JavaType[] arguments) {
        if (arguments == null) {
            arguments = JavaType.EMPTY_ARRAY;
        }
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveMethodCall(this.scopeCookie, "<init>", target, null, arguments);
        }
    }

    @Override
    public CallerContext.Output listNames(JavaPackage lhs, CallerContext.InputOptions options) {
        if (options == null) {
            options = new CallerContext.InputOptions();
        }
        OutputImpl output = new OutputImpl();
        options.input = (byte)(options.input & 0xFFFFFFF6);
        InputImpl inputImpl = new InputImpl(options);
        this.compiler.listNames(this.scopeCookie, lhs, inputImpl, output);
        return output;
    }

    @Override
    public CallerContext.Output listNames(JavaHasType lhs, CallerContext.InputOptions options) {
        if (options == null) {
            options = new CallerContext.InputOptions();
        }
        OutputImpl output = new OutputImpl();
        if (lhs != null) {
            options.input = (byte)(options.input & 0xFFFFFFFD);
        }
        InputImpl inputImpl = new InputImpl(options);
        this.compiler.listNames(this.scopeCookie, lhs, inputImpl, output);
        return output;
    }

    @Override
    public CallerContext.Output listMethods(JavaHasType lhs, String name, JavaType[] tArguments, CallerContext.InputOptions options) {
        if (options == null) {
            options = new CallerContext.InputOptions();
        }
        OutputImpl output = new OutputImpl();
        options.input = (byte)(options.input | 1);
        options.input = (byte)(options.input & 0xFFFFFFF1);
        InputImpl inputImpl = new InputImpl(options, name, tArguments);
        this.compiler.listNames(this.scopeCookie, lhs, inputImpl, output);
        ArrayList methods = output.all;
        if (methods != null && tArguments != null && tArguments.length > 0) {
            ArrayList<JavaMethod> newMethods = new ArrayList<JavaMethod>();
            for (int x = 0; x < methods.size(); ++x) {
                JavaMethod method = (JavaMethod)methods.get(x);
                Collection typeParams = method.getTypeParameters();
                if (typeParams != null && typeParams.size() == tArguments.length) {
                    method = CallerContextImpl.createParameterizedMethod(this.compiler.provider, method, tArguments);
                }
                newMethods.add(method);
            }
            methods.clear();
            methods.addAll(newMethods);
        }
        return output;
    }

    public CallerContextImpl(JavaProvider provider, Sym scope, boolean forgiving) {
        this.compiler = scope != null && scope.symFile != null ? new CompilerDriver(provider, scope.symFile.j2se) : new CompilerDriver(provider);
        this.compiler.flag_forgiving = forgiving;
        this.scopeCookie = scope;
    }
}

