/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.common.WrapperClass;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;

final class TypeErasedClass
extends WrapperClass {
    private JavaType erasedSuperClass = null;
    private Collection<JavaType> erasedInterfaces = null;
    private Collection<JavaMethod> erasedConstructors = null;
    private Collection<JavaMethod> erasedMethods = null;
    private Collection<JavaField> erasedFields = null;

    TypeErasedClass(JavaClass baseType) {
        super(baseType);
    }

    protected boolean containsTypeVariables(JavaType type) {
        if (type.hasActualTypeArguments() && type instanceof JavaClass) {
            Collection typeArguments = type.getActualTypeArguments();
            for (JavaType typeArgument : typeArguments) {
                if (typeArgument.getElementKind() == 10) {
                    return true;
                }
                if (!typeArgument.hasActualTypeArguments()) continue;
                return this.containsTypeVariables(typeArgument);
            }
        }
        return false;
    }

    @Override
    public JavaType getSuperclass() {
        JavaType superType;
        if (this.erasedSuperClass == null && (superType = super.getSuperclass()) != null) {
            this.erasedSuperClass = new TypeErasedClass((JavaClass)superType);
        }
        return this.erasedSuperClass;
    }

    @Override
    public Collection getInterfaces() {
        if (this.erasedInterfaces == null) {
            Collection interfaces = super.getInterfaces();
            if (interfaces.isEmpty()) {
                this.erasedInterfaces = Collections.emptyList();
            } else {
                this.erasedInterfaces = new ArrayList<JavaType>();
                for (JavaType type : interfaces) {
                    this.erasedInterfaces.add(new TypeErasedClass((JavaClass)type));
                }
            }
        }
        return this.erasedInterfaces;
    }

    @Override
    public JavaClass getTypeErasure() {
        return this;
    }

    @Override
    public Collection getDeclaredConstructors() {
        if (this.erasedConstructors == null) {
            Collection thingConstructors = super.getDeclaredConstructors();
            if (thingConstructors.isEmpty()) {
                this.erasedConstructors = Collections.emptyList();
            } else {
                this.erasedConstructors = new ArrayList<JavaMethod>();
                for (JavaMethod thingConstructor : thingConstructors) {
                    this.erasedConstructors.add(new TypeErasedMethod(thingConstructor));
                }
            }
        }
        return this.erasedConstructors;
    }

    @Override
    public Collection getDeclaredMethods() {
        if (this.erasedMethods == null) {
            Collection thingMethods = super.getDeclaredMethods();
            if (thingMethods.isEmpty()) {
                this.erasedMethods = thingMethods;
            } else {
                this.erasedMethods = new ArrayList<JavaMethod>();
                for (JavaMethod thingMethod : thingMethods) {
                    this.erasedMethods.add(new TypeErasedMethod(thingMethod));
                }
            }
        }
        return this.erasedMethods;
    }

    @Override
    public Collection getDeclaredFields() {
        Collection fields = super.getDeclaredFields();
        if (fields.isEmpty()) {
            this.erasedFields = Collections.emptyList();
        } else {
            this.erasedFields = new ArrayList<JavaField>();
            for (JavaField field : fields) {
                this.erasedFields.add(new TypeErasedField(field));
            }
        }
        return this.erasedFields;
    }

    @Override
    public Collection getActualTypeArguments() {
        return Collections.EMPTY_LIST;
    }

    private class TypeErasedField
    extends WrapperField {
        private JavaType erasedResolvedType;

        private TypeErasedField(JavaField baseField) {
            super(baseField);
            this.erasedResolvedType = null;
        }

        @Override
        public JavaType getResolvedType() {
            if (this.erasedResolvedType == null) {
                JavaType resolvedType = super.getResolvedType();
                this.erasedResolvedType = resolvedType == null ? null : (resolvedType.getElementKind() == 10 ? resolvedType.getTypeErasure() : (!(resolvedType instanceof TypeErasedClass) && TypeErasedClass.this.containsTypeVariables(resolvedType) ? new TypeErasedClass((JavaClass)resolvedType) : resolvedType));
            }
            return this.erasedResolvedType;
        }

        @Override
        public JavaClass getOwningClass() {
            return TypeErasedClass.this;
        }
    }

    private class TypeErasedMethod
    extends WrapperMethod {
        private Collection<JavaLocalVariable> erasedParameters;
        private JavaType erasedResolvedType;
        private JavaType erasedReturnType;

        private TypeErasedMethod(JavaMethod baseMethod) {
            super(baseMethod);
            this.erasedParameters = null;
            this.erasedResolvedType = null;
            this.erasedReturnType = null;
        }

        @Override
        public JavaType getResolvedType() {
            JavaType resolvedType;
            if (this.erasedResolvedType == null && (resolvedType = this.thing.getResolvedType()) != null) {
                this.erasedResolvedType = resolvedType.getElementKind() == 10 ? (this.thing.isStatic() && resolvedType.getOwner() == this.thing ? resolvedType : resolvedType.getTypeErasure()) : (!(resolvedType instanceof TypeErasedClass) && TypeErasedClass.this.containsTypeVariables(resolvedType) ? new TypeErasedClass((JavaClass)resolvedType) : resolvedType);
            }
            return this.erasedResolvedType;
        }

        @Override
        public JavaType getReturnType() {
            if (this.erasedReturnType == null) {
                JavaType returnType = this.thing.getReturnType();
                this.erasedReturnType = returnType == null ? null : (returnType.getElementKind() == 10 ? (this.thing.isStatic() && returnType.getOwner() == this.thing ? returnType : returnType.getTypeErasure()) : (!(returnType instanceof TypeErasedClass) && TypeErasedClass.this.containsTypeVariables(returnType) ? new TypeErasedClass((JavaClass)returnType) : returnType));
            }
            return this.erasedReturnType;
        }

        @Override
        public Collection getParameters() {
            if (this.erasedParameters == null) {
                Collection parameters = super.getParameters();
                if (parameters.isEmpty()) {
                    this.erasedParameters = Collections.emptyList();
                } else {
                    this.erasedParameters = new ArrayList<JavaLocalVariable>();
                    for (JavaLocalVariable param : parameters) {
                        this.erasedParameters.add(new TypeErasedParameter(param));
                    }
                }
            }
            return this.erasedParameters;
        }

        @Override
        public JavaMethod getMethodErasure() {
            return this;
        }

        private class TypeErasedParameter
        extends WrapperLocalVariable {
            private JavaType erasedResolvedType;

            private TypeErasedParameter(JavaLocalVariable baseVariable) {
                super(baseVariable);
                this.erasedResolvedType = null;
            }

            @Override
            public JavaType getResolvedType() {
                if (this.erasedResolvedType == null) {
                    JavaType resolvedType = super.getResolvedType();
                    this.erasedResolvedType = resolvedType == null ? null : (resolvedType.getElementKind() == 10 ? (TypeErasedMethod.this.isStatic() && resolvedType.getOwner() == TypeErasedMethod.this.thing ? resolvedType : resolvedType.getTypeErasure()) : (!(resolvedType instanceof TypeErasedClass) && TypeErasedClass.this.containsTypeVariables(resolvedType) ? new TypeErasedClass((JavaClass)resolvedType) : resolvedType));
                }
                return this.erasedResolvedType;
            }

            @Override
            public JavaElement getOwner() {
                return TypeErasedMethod.this;
            }
        }
    }
}

