/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Collection;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public final class QuickMethod
extends AbstractMethod {
    private final JavaClass methodOwning;
    private final char methodAccess;
    private final JavaType methodReturnType;
    private final String methodName;
    private final Collection methodParameters;
    private final Collection methodExceptions;

    public static QuickMethod createMethod(JavaClass owning, char access, JavaType returnType, String name, Collection parameters, Collection exceptions) {
        return new QuickMethod(owning, access, returnType, name, parameters, exceptions);
    }

    @Override
    public int getModifiers() {
        return this.methodAccess;
    }

    @Override
    public JavaType getResolvedType() {
        return this.methodReturnType;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        if (this.methodReturnType != null) {
            return this.methodReturnType.getUnresolvedType();
        }
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Collection getParameters() {
        return this.methodParameters;
    }

    @Override
    public Collection getExceptions() {
        return this.methodExceptions;
    }

    @Override
    public JavaClass getOwningClass() {
        return this.methodOwning;
    }

    @Override
    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    private QuickMethod(JavaClass owning, char access, JavaType returnType, String name, Collection parameters, Collection exceptions) {
        if (returnType == null) {
            returnType = PrimitiveType.PRIMITIVE_objects[9];
        }
        if (parameters == null) {
            parameters = kEmptyCollection;
        }
        if (exceptions == null) {
            exceptions = kEmptyCollection;
        }
        this.methodOwning = owning;
        this.methodAccess = access;
        this.methodReturnType = returnType;
        this.methodName = name;
        this.methodParameters = parameters;
        this.methodExceptions = exceptions;
        if (!parameters.isEmpty()) {
            for (Object o : parameters) {
                if (!(o instanceof QuickLocalVariable)) continue;
                QuickLocalVariable tmp = (QuickLocalVariable)o;
                tmp.setOwner(this);
            }
        }
    }
}

