/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.HashMap;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;

public final class PrimitiveType
extends AbstractClass
implements JavaConstants {
    public static final PrimitiveType[] PRIMITIVE_objects;
    public static final PrimitiveType[] PRIMITIVE_lookup;
    public static final PrimitiveType[] PRIMITIVE_alpha;
    private static final HashMap PRIMITIVE_hashtable;
    private static final HashMap PRIMITIVE_unboxing;
    private static final int NARROWING_BIT = 16;
    private static final int WIDENING_BIT = 8;
    private static final int MASK_ID = 15;
    private static final int FL_INTEGER = 16;
    private static final int FL_NUMERIC = 32;
    private static int[] PRIMITIVE_flags;
    public final byte primCode;

    public static PrimitiveType lookupPrimitive(String name) {
        Object found = PRIMITIVE_hashtable.get(name);
        if (found == null) {
            return null;
        }
        return (PrimitiveType)found;
    }

    public static PrimitiveType applyUnboxingConversion(JavaType input) {
        String name = input.getVMName();
        if (!name.startsWith("java/lang/")) {
            return null;
        }
        return (PrimitiveType)PRIMITIVE_unboxing.get(name);
    }

    public static boolean isNumeric(PrimitiveType subject) {
        int flags = PRIMITIVE_flags[subject.primCode];
        return (flags & 0x20) != 0;
    }

    public static boolean applyWideningConversion(PrimitiveType subject, PrimitiveType target) {
        if (subject == null) {
            return false;
        }
        if (subject.primCode == target.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(subject) || !PrimitiveType.isNumeric(target)) {
            return false;
        }
        int subjectFlags = PRIMITIVE_flags[subject.primCode];
        int assignableBit = 1 << 8 + target.primCode;
        return (subjectFlags & assignableBit) != 0;
    }

    public static boolean applyNarrowingConversion(PrimitiveType subject, PrimitiveType target) {
        if (subject == null) {
            return false;
        }
        if (subject.primCode == target.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(subject) || !PrimitiveType.isNumeric(target)) {
            return false;
        }
        int subjectFlags = PRIMITIVE_flags[subject.primCode];
        int assignableBit = 1 << 16 + target.primCode;
        return (subjectFlags & assignableBit) != 0;
    }

    public boolean isNumeric() {
        return 1 <= this.primCode && this.primCode <= 7;
    }

    public boolean isIntegral() {
        return 1 <= this.primCode && this.primCode <= 5;
    }

    public boolean isFloatingPoint() {
        return this.primCode == 6 || this.primCode == 7;
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getVMName() {
        return this.getName();
    }

    @Override
    public String getName() {
        short tk = PRIMITIVE_tokens[this.primCode];
        if (tk != 15) {
            return KW_words[tk - 96];
        }
        return "null";
    }

    @Override
    public String getDescriptor() {
        return PRIMITIVE_descriptors[this.primCode];
    }

    @Override
    public String getTypeSignature() {
        return this.getDescriptor();
    }

    @Override
    public String getSignature() {
        return this.getDescriptor();
    }

    @Override
    public int getModifiers() {
        return 17;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    protected PrimitiveType(byte code) {
        this.primCode = code;
    }

    static {
        byte i;
        PRIMITIVE_objects = new PrimitiveType[10];
        PRIMITIVE_lookup = new PrimitiveType[50];
        PRIMITIVE_alpha = new PrimitiveType[26];
        for (i = 0; i < 10; i = (byte)(i + 1)) {
            String desc;
            char ch;
            PrimitiveType primitive;
            PrimitiveType.PRIMITIVE_objects[i] = primitive = new PrimitiveType(i);
            short tk = PRIMITIVE_tokens[i];
            if (96 <= tk && tk < 146) {
                PrimitiveType.PRIMITIVE_lookup[tk - 96] = primitive;
            }
            if ('A' > (ch = (desc = PRIMITIVE_descriptors[i]).charAt(0)) || ch > 'Z') continue;
            PrimitiveType.PRIMITIVE_alpha[ch - 65] = primitive;
        }
        PRIMITIVE_hashtable = new HashMap();
        for (i = 0; i < 10; i = (byte)(i + 1)) {
            short tk = PRIMITIVE_tokens[i];
            if (96 > tk || tk >= 146) continue;
            String kw = KW_words[tk - 96];
            PRIMITIVE_hashtable.put(kw, PRIMITIVE_objects[i]);
        }
        PRIMITIVE_unboxing = new HashMap();
        for (i = 0; i < 10; i = (byte)(i + 1)) {
            String autobox = PRIMITIVE_autoboxes[i];
            if (autobox == null) continue;
            PRIMITIVE_unboxing.put(autobox, PRIMITIVE_objects[i]);
        }
        PRIMITIVE_flags = new int[]{0, 64049, 717874, 456755, 978996, 2023477, 4112422, 8290343, 0, 0};
    }
}

