/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;

final class Parameterization
implements JavaConstants {
    private static final LinkedHashMap kEmptyMap = new LinkedHashMap();
    final JavaProvider provider;
    final JavaIsGeneric baseObject;
    final JavaType[] boundArguments;
    private final LinkedHashMap argumentMap;

    Parameterization(JavaProvider provider, JavaIsGeneric baseObject, JavaType[] boundArguments) {
        JavaClass owningClass;
        this.provider = provider;
        this.baseObject = baseObject;
        this.boundArguments = boundArguments;
        LinkedHashMap map = null;
        if (boundArguments.length > 0) {
            map = new LinkedHashMap();
            Iterator parameters = baseObject.getTypeParameters().iterator();
            int i = 0;
            while (parameters.hasNext()) {
                map.put(parameters.next(), boundArguments[i++]);
            }
        }
        if ((owningClass = baseObject.getOwningClass()) instanceof ParameterizedClass) {
            ParameterizedClass owningBoundType = (ParameterizedClass)owningClass;
            if (!owningBoundType.params.argumentMap.isEmpty()) {
                if (map == null) {
                    map = new LinkedHashMap();
                }
                map.putAll(owningBoundType.params.argumentMap);
            }
        }
        this.argumentMap = map == null ? kEmptyMap : map;
    }

    Parameterization(JavaIsGeneric baseObject, Parameterization otherParams) {
        this.provider = otherParams.provider;
        this.baseObject = baseObject;
        this.boundArguments = JavaType.EMPTY_ARRAY;
        this.argumentMap = otherParams.argumentMap;
    }

    final JavaType bind(JavaType thing) {
        JavaType[] boundArgs;
        int argumentCount;
        JavaClass owningClass;
        JavaType owningBound;
        if (thing == null) {
            return null;
        }
        if (thing.isPrimitive()) {
            return thing;
        }
        if (thing.isArray()) {
            JavaType bound = this.bind(thing.getComponentType());
            if (bound == thing) {
                return thing;
            }
            return CommonUtilities.createArrayType(this.provider, bound, 1);
        }
        switch (thing.getElementKind()) {
            case 11: {
                Collection lowers;
                JavaWildcardType wildcard = (JavaWildcardType)thing;
                JavaType upper = null;
                JavaType lower = null;
                Collection uppers = wildcard.getUpperBounds();
                if (!uppers.isEmpty()) {
                    upper = (JavaType)uppers.iterator().next();
                }
                if (!(lowers = wildcard.getLowerBounds()).isEmpty()) {
                    lower = (JavaType)lowers.iterator().next();
                }
                JavaType boundUpper = this.bind(upper);
                JavaType boundLower = this.bind(lower);
                if (upper == boundUpper && lower == boundLower) {
                    return thing;
                }
                return new WildcardType(boundUpper, boundLower, this.provider);
            }
            case 10: {
                JavaType mapped = (JavaType)this.argumentMap.get(thing);
                if (mapped == null) {
                    return thing;
                }
                if (mapped instanceof WildcardType) {
                    JavaTypeVariable typeParamSym;
                    Collection bounds;
                    WildcardType wildcardType = (WildcardType)mapped;
                    if (wildcardType.getUpperBound() == null && wildcardType.getLowerBound() == null) {
                        JavaType bound;
                        JavaTypeVariable typeParamSym2 = (JavaTypeVariable)thing;
                        Collection bounds2 = typeParamSym2.getBounds();
                        if (bounds2 != null && bounds2.size() > 0 && (bound = (JavaType)bounds2.iterator().next()) != null) {
                            return CommonUtilities.createWildcardType((byte)1, bound, this.provider);
                        }
                    } else if (wildcardType.getLowerBound() != null && wildcardType.getUpperBound() == null && (bounds = (typeParamSym = (JavaTypeVariable)thing).getBounds()) != null && bounds.size() > 0) {
                        JavaType upperBound = (JavaType)bounds.iterator().next();
                        JavaType lowerBound = wildcardType.getLowerBound();
                        if (upperBound != null && lowerBound != null) {
                            if (upperBound.isAssignableFrom(lowerBound)) {
                                return CommonUtilities.createWildcardType((byte)1, upperBound, this.provider);
                            }
                            return CommonUtilities.createWildcardType((byte)2, lowerBound, this.provider);
                        }
                    }
                }
                return mapped;
            }
        }
        if (thing.isMemberClass() && (owningBound = this.bind(owningClass = thing.getOwningClass())) != owningClass && (thing = owningBound.getDeclaredClass(thing.getName())) == null) {
            return null;
        }
        if (!thing.hasActualTypeArguments()) {
            return thing;
        }
        Collection arguments = thing.getActualTypeArguments();
        JavaType[] argumentArray = arguments.toArray(new JavaType[argumentCount = arguments.size()]);
        if (argumentArray == (boundArgs = this.bindImpl(argumentArray))) {
            return thing;
        }
        ParameterizedClass paramThing = (ParameterizedClass)thing;
        try {
            return new ParameterizedClass(this.provider, paramThing.thing, boundArgs);
        }
        catch (ClassCastException e) {
            return thing;
        }
    }

    final Collection bind(Collection things) {
        JavaType[] out;
        if (things.isEmpty()) {
            return kEmptyCollection;
        }
        int count = things.size();
        JavaType[] in = things.toArray(new JavaType[count]);
        if (in == (out = this.bindImpl(in))) {
            return things;
        }
        return Arrays.asList(out);
    }

    private JavaType[] bindImpl(JavaType[] things) {
        int count = things.length;
        if (count == 0) {
            return things;
        }
        JavaType[] out = new JavaType[count];
        boolean bound = false;
        for (int i = 0; i < count; ++i) {
            JavaType boundThing;
            JavaType thing = things[i];
            out[i] = boundThing = this.bind(thing);
            if (thing == boundThing) continue;
            bound = true;
        }
        if (!bound) {
            return things;
        }
        return out;
    }
}

