/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.Conversions;

public class MethodHierarchy
extends AbstractCollection
implements JavaConstants {
    private JavaMethod[] methodHierarchy;
    private JavaMethod target;

    @Override
    public Iterator iterator() {
        if (this.methodHierarchy != null) {
            return Arrays.asList(this.methodHierarchy).iterator();
        }
        if (this.target.isConstructor()) {
            this.methodHierarchy = JavaMethod.EMPTY_ARRAY;
            return Arrays.asList(this.methodHierarchy).iterator();
        }
        return new MethodHierarchyIterator();
    }

    @Override
    public int size() {
        this.calculateHierarchy();
        return this.methodHierarchy.length;
    }

    @Override
    public boolean isEmpty() {
        if (this.methodHierarchy != null) {
            return this.methodHierarchy.length == 0;
        }
        return !new MethodHierarchyIterator().hasNext();
    }

    @Override
    public Object[] toArray() {
        this.calculateHierarchy();
        return this.methodHierarchy;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public MethodHierarchy(JavaMethod input) {
        this.target = input;
    }

    private void calculateHierarchy() {
        if (this.methodHierarchy != null) {
            return;
        }
        if (this.target.isConstructor()) {
            this.methodHierarchy = JavaMethod.EMPTY_ARRAY;
            return;
        }
        JavaClass owningClass = this.target.getOwningClass();
        if (owningClass == null) {
            this.methodHierarchy = JavaMethod.EMPTY_ARRAY;
            return;
        }
        Iterator classHierarchy = owningClass.getHierarchy().iterator();
        ArrayList<JavaMethod> processed = new ArrayList<JavaMethod>();
        while (classHierarchy.hasNext()) {
            JavaType type = (JavaType)classHierarchy.next();
            for (JavaMethod method : type.getDeclaredMethods()) {
                if (!Conversions.hasSubsignatureOf(this.target, method) || !this.hasValidVisibility(method)) continue;
                processed.add(method);
            }
        }
        int size = processed.size();
        this.methodHierarchy = size == 0 ? JavaMethod.EMPTY_ARRAY : processed.toArray(new JavaMethod[size]);
    }

    private boolean hasValidVisibility(JavaMethod method) {
        if (this.target.isStatic() || method.isStatic()) {
            return false;
        }
        if (method.isFinal() || method.isPrivate() || this.target.isPrivate()) {
            return false;
        }
        if (method.isPublic() && !this.target.isPublic()) {
            return false;
        }
        if (method.isProtected() && this.target.isPackagePrivate()) {
            return false;
        }
        return !method.isPackagePrivate() || method.getOwningClass().getPackage().equals(this.target.getOwningClass().getPackage());
    }

    static /* synthetic */ JavaMethod[] access$202(MethodHierarchy x0, JavaMethod[] x1) {
        x0.methodHierarchy = x1;
        return x1;
    }

    private class MethodHierarchyIterator
    implements Iterator {
        final ArrayList processed = new ArrayList();
        final LinkedList frontier = new LinkedList();
        final Iterator classHierarchy;
        JavaMethod current = null;

        private MethodHierarchyIterator() {
            JavaClass owningClass = MethodHierarchy.this.target.getOwningClass();
            this.classHierarchy = owningClass == null ? JavaConstants.kEmptyCollection.iterator() : owningClass.getHierarchy().iterator();
        }

        @Override
        public boolean hasNext() {
            this.advance();
            if (this.current != null) {
                return true;
            }
            if (MethodHierarchy.this.methodHierarchy == null) {
                int size = this.processed.size();
                if (size == 0) {
                    MethodHierarchy.access$202(MethodHierarchy.this, JavaMethod.EMPTY_ARRAY);
                } else {
                    MethodHierarchy.access$202(MethodHierarchy.this, this.processed.toArray(new JavaMethod[size]));
                }
            }
            return false;
        }

        public Object next() {
            this.advance();
            JavaMethod saved = this.current;
            this.processed.add(saved);
            this.current = null;
            return saved;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.current == null) {
                if (!this.frontier.isEmpty()) {
                    this.current = (JavaMethod)this.frontier.removeFirst();
                    continue;
                }
                if (!this.classHierarchy.hasNext()) {
                    return;
                }
                JavaType type = (JavaType)this.classHierarchy.next();
                for (JavaMethod method : type.getDeclaredMethods()) {
                    if (!Conversions.hasSubsignatureOf(MethodHierarchy.this.target, method) || !MethodHierarchy.this.hasValidVisibility(method)) continue;
                    this.frontier.add(method);
                }
            }
        }
    }
}

