/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaType;

public class ClassHierarchy
extends AbstractSet
implements JavaConstants {
    private JavaType[] classHierarchy;
    private JavaType target;

    @Override
    public Iterator iterator() {
        if (this.classHierarchy != null) {
            return Arrays.asList(this.classHierarchy).iterator();
        }
        return new ClassHierarchyIterator();
    }

    @Override
    public int size() {
        this.calculateHierarchy();
        return this.classHierarchy.length;
    }

    @Override
    public boolean isEmpty() {
        if (this.classHierarchy != null) {
            return this.classHierarchy.length == 0;
        }
        return !new ClassHierarchyIterator().hasNext();
    }

    @Override
    public Object[] toArray() {
        this.calculateHierarchy();
        return this.classHierarchy;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public ClassHierarchy(JavaType input) {
        this.target = input;
        if (input == null) {
            this.classHierarchy = JavaType.EMPTY_ARRAY;
        }
    }

    private void calculateHierarchy() {
        if (this.classHierarchy != null) {
            return;
        }
        ArrayList processed = new ArrayList();
        ArrayList output = new ArrayList();
        this.calculateHierarchyImpl(this.target, processed, output);
        output.remove(this.target);
        int size = output.size();
        this.classHierarchy = size == 0 ? JavaType.EMPTY_ARRAY : output.toArray(new JavaType[size]);
    }

    private void calculateHierarchyImpl(JavaType targetClass, ArrayList processed, ArrayList output) {
        JavaType baseClass;
        if (targetClass == null) {
            return;
        }
        if (CommonUtilities.classProcessed(processed, targetClass)) {
            return;
        }
        if (targetClass.getElementKind() == 3) {
            output.add(targetClass);
        }
        if ((baseClass = targetClass.getSuperclass()) != null) {
            this.calculateHierarchyImpl(baseClass, processed, output);
        }
        for (JavaType baseInterface : targetClass.getInterfaces()) {
            this.calculateHierarchyImpl(baseInterface, processed, output);
        }
    }

    static /* synthetic */ JavaType[] access$202(ClassHierarchy x0, JavaType[] x1) {
        x0.classHierarchy = x1;
        return x1;
    }

    private class ClassHierarchyIterator
    implements Iterator {
        final ArrayList processed = new ArrayList();
        final ArrayList output = new ArrayList();
        final LinkedList frontier = new LinkedList();
        JavaType current = null;

        private ClassHierarchyIterator() {
            this.frontier.add(ClassHierarchy.this.target);
            this.next();
            this.output.clear();
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advance();
            }
            if (this.current != null) {
                return true;
            }
            if (ClassHierarchy.this.classHierarchy == null) {
                int size = this.output.size();
                if (size == 0) {
                    ClassHierarchy.access$202(ClassHierarchy.this, JavaType.EMPTY_ARRAY);
                } else {
                    ClassHierarchy.access$202(ClassHierarchy.this, this.output.toArray(new JavaType[size]));
                }
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JavaType saved = this.current;
            this.output.add(saved);
            this.current = null;
            return saved;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.current == null && !this.frontier.isEmpty()) {
                JavaType type = (JavaType)this.frontier.removeFirst();
                if (CommonUtilities.classProcessed(this.processed, type)) continue;
                this.current = type;
                JavaType superclass = type.getSuperclass();
                if (superclass != null) {
                    this.frontier.addLast(superclass);
                }
                for (JavaType superinterface : type.getInterfaces()) {
                    this.frontier.addLast(superinterface);
                }
            }
        }
    }
}

