/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class ArrayType
extends AbstractClass
implements JavaConstants {
    private final JavaProvider provider;
    private final JavaType arrayComponent;
    private JavaField[] arrayFields = null;
    private JavaMethod[] arrayMethods = null;
    private Collection arrayInterfaces = null;

    public ArrayType(JavaProvider provider, JavaType componentType) {
        this.provider = provider;
        this.arrayComponent = componentType;
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JavaType getComponentType() {
        return this.arrayComponent;
    }

    @Override
    public int getArrayDimensions() {
        JavaType type = this.arrayComponent;
        if (type == null) {
            return 1;
        }
        int count = 1;
        JavaType nextType = type.getComponentType();
        while (nextType != null && nextType != type) {
            if (++count > 255) {
                return 255;
            }
            type = nextType;
            nextType = type.getComponentType();
        }
        return count;
    }

    @Override
    public JavaType getBaseComponentType() {
        JavaType type = this.arrayComponent;
        if (type == null) {
            return null;
        }
        int count = 1;
        JavaType nextType = type.getComponentType();
        while (nextType != null) {
            if (nextType == type) {
                return null;
            }
            if (++count > 255) {
                return null;
            }
            type = nextType;
            nextType = type.getComponentType();
        }
        return type;
    }

    @Override
    public JavaClass getTypeErasure() {
        if (this.arrayComponent == null) {
            return null;
        }
        JavaClass componentErasure = this.arrayComponent.getTypeErasure();
        if (componentErasure == this.arrayComponent) {
            return this;
        }
        return new ArrayType(this.provider, componentErasure);
    }

    @Override
    public String getName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getName() + "[]";
        }
        return "Object[]";
    }

    @Override
    public String getUnqualifiedName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getUnqualifiedName() + "[]";
        }
        return "Object[]";
    }

    @Override
    public String getQualifiedName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getQualifiedName() + "[]";
        }
        return "java.lang.Object[]";
    }

    @Override
    public String getVMName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getVMName() + "[]";
        }
        return "java/lang/Object[]";
    }

    @Override
    public String getDescriptor() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getDescriptor();
        }
        return "[Ljava/lang/Object;";
    }

    @Override
    public String getTypeSignature() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getTypeSignature();
        }
        return this.getDescriptor();
    }

    @Override
    public String getSignature() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getSignature();
        }
        return this.getDescriptor();
    }

    @Override
    public JavaType getSuperclass() {
        if (this.provider != null) {
            return this.provider.getClassByVMName("java/lang/Object");
        }
        return null;
    }

    @Override
    public Collection getInterfaces() {
        if (this.arrayInterfaces == null) {
            if (this.provider != null) {
                ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                int count = ARRAY_implements.length;
                for (int i = 0; i < count; ++i) {
                    JavaClass type = this.provider.getClassByVMName(ARRAY_implements[i]);
                    if (type == null) continue;
                    list.add(type);
                }
                if (!list.isEmpty()) {
                    this.arrayInterfaces = list;
                }
            }
            if (this.arrayInterfaces == null) {
                this.arrayInterfaces = kEmptyCollection;
            }
        }
        return this.arrayInterfaces;
    }

    @Override
    public Collection getDeclaredFields() {
        if (this.arrayFields == null) {
            JavaField[] fields = new JavaField[]{new ArrayLength()};
            this.arrayFields = fields;
        }
        return Arrays.asList(this.arrayFields);
    }

    @Override
    public Collection getDeclaredMethods() {
        if (this.arrayMethods == null) {
            JavaMethod[] methods = new JavaMethod[]{new ArrayClone()};
            this.arrayMethods = methods;
        }
        return Arrays.asList(this.arrayMethods);
    }

    private class ArrayClone
    extends AbstractMethod {
        private ArrayClone() {
        }

        @Override
        public JavaClass getOwningClass() {
            return ArrayType.this;
        }

        @Override
        public JavaType getResolvedType() {
            if (ArrayType.this.provider != null) {
                return ArrayType.this.provider.getClassByVMName("java/lang/Object");
            }
            return null;
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            JavaType type = this.getResolvedType();
            if (type != null) {
                return type.getUnresolvedType();
            }
            return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
        }

        @Override
        public String getName() {
            return "clone";
        }

        @Override
        public String getDescriptor() {
            return "()Ljava/lang/Object;";
        }

        @Override
        public int getModifiers() {
            return 17;
        }
    }

    private class ArrayLength
    extends AbstractField {
        private ArrayLength() {
        }

        @Override
        public JavaClass getOwningClass() {
            return ArrayType.this;
        }

        @Override
        public JavaType getResolvedType() {
            return PrimitiveType.PRIMITIVE_objects[4];
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.getResolvedType().getUnresolvedType();
        }

        @Override
        public String getName() {
            return "length";
        }

        @Override
        public int getModifiers() {
            return 17;
        }
    }
}

